/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.excel;

import cn.benma666.domain.SysSjglFile;
import cn.benma666.excel.ImageConverterKey;
import cn.benma666.exception.MyException;
import cn.benma666.iframe.Conf;
import cn.benma666.myutils.FileUtil;
import cn.benma666.myutils.HttpUtil;
import cn.benma666.myutils.PicUtils;
import cn.benma666.myutils.StringUtil;
import cn.benma666.sjzt.Db;
import com.alibaba.druid.util.Utils;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ImageData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.ListUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageConverter
implements Converter<ImageConverterKey> {
    private static final Logger log = LoggerFactory.getLogger(ImageConverter.class);

    public Class<?> supportJavaTypeKey() {
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteCellData<?> convertToExcelData(ImageConverterKey value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws IOException {
        ArrayList data = ListUtils.newArrayList();
        if (value.getIn() != null) {
            try {
                ImageData imageData = new ImageData();
                imageData.setImage(PicUtils.compressPicForScale(Utils.readByteArray((InputStream)value.getIn()), 200L));
                imageData.setTop(Integer.valueOf(1));
                imageData.setRight(Integer.valueOf(1));
                imageData.setBottom(Integer.valueOf(1));
                imageData.setLeft(Integer.valueOf(1));
                data.add(imageData);
            }
            finally {
                FileUtil.closeStream(value.getIn());
            }
        } else if (StringUtil.isNotBlank((String)value.getLj())) {
            String[] urls;
            HttpUtil hu = HttpUtil.builder().addRp("RequestMethod", "GET").build();
            int i = 0;
            for (String url : urls = value.getLj().split(",")) {
                InputStream inputStream = null;
                try {
                    if (url.startsWith("http")) {
                        inputStream = hu.getInputStream(url);
                    } else if (url.length() == 32 && !url.contains(".")) {
                        SysSjglFile sysSjglFile = (SysSjglFile)Db.use().lambdaQuery(SysSjglFile.class).andEq(SysSjglFile::getId, url).singleSimple();
                        if (sysSjglFile == null) {
                            throw new MyException("\u6587\u4ef6\u6ca1\u6709\u627e\u5230\uff1a" + url);
                        }
                        inputStream = sysSjglFile.getInputStream();
                    } else {
                        inputStream = hu.getInputStream(Conf.getUtilConfig().getService().getTydlzd() + url);
                    }
                    byte[] bytes = PicUtils.compressPicForScale(Utils.readByteArray((InputStream)inputStream), 200L);
                    ImageData imageData = new ImageData();
                    imageData.setImage(bytes);
                    imageData.setTop(Integer.valueOf(10 * i + 1));
                    imageData.setBottom(Integer.valueOf(10 * (urls.length - i - 1) + 1));
                    imageData.setRight(Integer.valueOf(10 * (urls.length - i - 1) + 1));
                    imageData.setLeft(Integer.valueOf(10 * i + 1));
                    data.add(imageData);
                    ++i;
                }
                catch (Exception e) {
                    try {
                        log.error("\u56fe\u7247\u83b7\u53d6\u5f02\u5e38\uff1a{}", (Object)url, (Object)e);
                    }
                    catch (Throwable throwable) {
                        FileUtil.closeStream(inputStream);
                        throw throwable;
                    }
                    FileUtil.closeStream(inputStream);
                    continue;
                }
                FileUtil.closeStream(inputStream);
            }
        } else {
            return new WriteCellData("\u6682\u65e0\u56fe\u7247");
        }
        WriteCellData cellData = new WriteCellData();
        cellData.setType(CellDataTypeEnum.EMPTY);
        cellData.setImageDataList((List)data);
        return cellData;
    }
}

