/*
 * Decompiled with CFR 0.152.
 */
package cn.benma666.crypt;

import cn.benma666.myutils.StringUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String encodingAlgorithm = "MD5";
    private static String characterEncoding;

    public static String encode(String srcStr) {
        if (srcStr == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(encodingAlgorithm);
            if (StringUtil.isNotBlank((String)characterEncoding)) {
                messageDigest.update(srcStr.getBytes(characterEncoding));
            } else {
                messageDigest.update(srcStr.getBytes());
            }
            byte[] digest = messageDigest.digest();
            return MD5Util.getFormattedText(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFormattedText(byte[] bytes) {
        StringBuilder buf = new StringBuilder(bytes.length * 2);
        for (int j = 0; j < bytes.length; ++j) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
        }
        return buf.toString();
    }

    public static String getCharacterEncoding() {
        return characterEncoding;
    }

    public static void setCharacterEncoding(String characterEncoding) {
        MD5Util.characterEncoding = characterEncoding;
    }

    public static String getEncodingalgorithm() {
        return encodingAlgorithm;
    }
}

