/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.test.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.trans.steps.loadsave.setter.Setter;
import org.pentaho.test.util.JavaBeanManipulator;
import org.pentaho.test.util.ObjectTester;

public class GetterSetterTester<T> {
    private final Map<String, ObjectTester<?>> objectTesterMap;
    private final Class<? extends T> clazz;
    private final Map<String, String> getterMap;
    private final Map<String, String> setterMap;

    public GetterSetterTester(Class<? extends T> clazz) {
        this(clazz, new HashMap<String, String>(), new HashMap<String, String>());
    }

    public GetterSetterTester(Class<? extends T> clazz, Map<String, String> getterMap, Map<String, String> setterMap) {
        this.clazz = clazz;
        this.getterMap = getterMap;
        this.setterMap = setterMap;
        this.objectTesterMap = new HashMap();
    }

    public void test(Object objectUnderTest) {
        JavaBeanManipulator<T> manipulator = new JavaBeanManipulator<T>(this.clazz, new ArrayList<String>(this.objectTesterMap.keySet()), this.getterMap, this.setterMap);
        for (Map.Entry<String, ObjectTester<?>> entry : this.objectTesterMap.entrySet()) {
            String attribute = entry.getKey();
            ObjectTester<?> tester = entry.getValue();
            for (Object testObject : tester.getTestObjects()) {
                Setter<?> setter = manipulator.getSetter(attribute);
                setter.set(objectUnderTest, testObject);
                tester.validate(testObject, manipulator.getGetter(attribute).get(objectUnderTest));
            }
        }
    }

    public void addObjectTester(String attribute, ObjectTester<?> objectTester) {
        this.objectTesterMap.put(attribute, objectTester);
    }
}

