/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www.cache;

import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.www.cache.CachedItem;
import org.pentaho.di.www.cache.CarteStatusCache;

public class CarteStatusCacheTest {
    CarteStatusCache cache = null;
    CarteStatusCache cacheSpy = null;

    @Before
    public void setup() {
        this.cache = CarteStatusCache.getInstance();
        this.cacheSpy = (CarteStatusCache)Mockito.spy((Object)this.cache);
    }

    @Test
    public void testGetInstance() {
        Assert.assertTrue((CarteStatusCache.getInstance() == CarteStatusCache.getInstance() ? 1 : 0) != 0);
    }

    @Test
    public void testPut() throws Exception {
        this.initializeTestData(this.cache.getMap());
        String id = "40";
        this.cacheSpy.put("logId" + id, "test string data", 0);
        Assert.assertEquals((long)41L, (long)this.cache.getMap().size());
        id = "20";
        File mockFile = ((CachedItem)this.cache.getMap().get("logId" + id)).getFile();
        Mockito.when((Object)mockFile.exists()).thenReturn((Object)true);
        this.cacheSpy.put("logId" + id, "test string data", 0);
        Assert.assertEquals((long)41L, (long)this.cache.getMap().size());
    }

    @Test
    public void testGet() throws Exception {
        this.initializeTestData(this.cache.getMap());
        Assert.assertNull((Object)this.cacheSpy.get("logId40", 0));
        File mockFile = ((CachedItem)this.cache.getMap().get("logId1")).getFile();
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)mockFile.toPath()).thenReturn((Object)path);
        this.cacheSpy.get("logId1", 0);
        ((File)Mockito.verify((Object)mockFile)).toPath();
    }

    @Test
    public void testRemove() throws Exception {
        this.initializeTestData(this.cache.getMap());
        Assert.assertEquals((long)40L, (long)this.cache.getMap().size());
        this.cacheSpy.remove("logId1");
        Assert.assertEquals((long)39L, (long)this.cache.getMap().size());
        Assert.assertNull(this.cache.getMap().get("logId1"));
    }

    void initializeTestData(Map<String, CachedItem> map) {
        map.clear();
        for (int i = 0; i < 40; ++i) {
            map.put("logId" + i, new CachedItem((File)Mockito.mock(File.class), 0));
        }
    }
}

