/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.www.SlaveServerJobStatusTest;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.SlaveServerTransStatusLoadSaveTester;
import org.w3c.dom.Node;

public class SlaveServerTransStatusTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Test
    public void testStaticFinal() {
        Assert.assertEquals((Object)"transstatus", (Object)"transstatus");
    }

    @Test
    public void testNoDate() throws KettleException {
        String transName = "testNullDate";
        String id = UUID.randomUUID().toString();
        String status = "Finished";
        SlaveServerTransStatus ts = new SlaveServerTransStatus(transName, id, status);
        String resultXML = ts.getXML();
        Node newTransStatus = XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)resultXML), (String)"transstatus");
        Assert.assertEquals((String)"The XML document should match after rebuilding from XML", (Object)resultXML, (Object)SlaveServerTransStatus.fromXML((String)resultXML).getXML());
        Assert.assertEquals((String)"There should be one \"log_date\" node in the XML", (long)1L, (long)XMLHandler.countNodes((Node)newTransStatus, (String)"log_date"));
        Assert.assertTrue((String)"The \"log_date\" node should have a null value", (boolean)Utils.isEmpty((CharSequence)XMLHandler.getTagValue((Node)newTransStatus, (String)"log_date")));
    }

    @Test
    public void testWithDate() throws KettleException {
        String transName = "testWithDate";
        String id = UUID.randomUUID().toString();
        String status = "Finished";
        Date logDate = new Date();
        SlaveServerTransStatus ts = new SlaveServerTransStatus(transName, id, status);
        ts.setLogDate(logDate);
        String resultXML = ts.getXML();
        Node newTransStatus = XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)resultXML), (String)"transstatus");
        Assert.assertEquals((String)"The XML document should match after rebuilding from XML", (Object)resultXML, (Object)SlaveServerTransStatus.fromXML((String)resultXML).getXML());
        Assert.assertEquals((String)"There should be one \"log_date\" node in the XML", (long)1L, (long)XMLHandler.countNodes((Node)newTransStatus, (String)"log_date"));
        Assert.assertEquals((String)"The \"log_date\" node should match the original value", (Object)XMLHandler.date2string((Date)logDate), (Object)XMLHandler.getTagValue((Node)newTransStatus, (String)"log_date"));
    }

    @Test
    public void testSerialization() throws KettleException {
        List<String> attributes = Arrays.asList("TransName", "Id", "StatusDescription", "ErrorDescription", "LogDate", "Paused", "FirstLoggingLineNr", "LastLoggingLineNr", "LoggingString");
        HashMap attributeMap = new HashMap();
        attributeMap.put("LoggingString", new SlaveServerJobStatusTest.LoggingStringLoadSaveValidator());
        SlaveServerTransStatusLoadSaveTester tester = new SlaveServerTransStatusLoadSaveTester(SlaveServerTransStatus.class, attributes, attributeMap);
        tester.testSerialization();
    }

    @Test
    public void testGetXML() throws KettleException {
        SlaveServerTransStatus transStatus = new SlaveServerTransStatus();
        RowMetaAndData rowMetaAndData = new RowMetaAndData();
        String testData = "testData";
        rowMetaAndData.addValue((ValueMetaInterface)new ValueMetaString(), (Object)testData);
        ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
        rows.add(rowMetaAndData);
        Result result = new Result();
        result.setRows(rows);
        transStatus.setResult(result);
        Assert.assertFalse((boolean)transStatus.getXML().contains(testData));
        Assert.assertTrue((boolean)transStatus.getXML(true).contains(testData));
    }
}

