/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.cluster.HttpUtil;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerJobStatusLoadSaveTester;
import org.w3c.dom.Node;

public class SlaveServerJobStatusTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        KettleEnvironment.init((boolean)false);
    }

    @Test
    public void testStaticFinal() {
        Assert.assertEquals((Object)"jobstatus", (Object)"jobstatus");
    }

    @Test
    public void testNoDate() throws KettleException {
        String jobName = "testNullDate";
        String id = UUID.randomUUID().toString();
        String status = "Finished";
        SlaveServerJobStatus js = new SlaveServerJobStatus(jobName, id, status);
        String resultXML = js.getXML();
        Node newJobStatus = XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)resultXML), (String)"jobstatus");
        Assert.assertEquals((String)"The XML document should match after rebuilding from XML", (Object)resultXML, (Object)SlaveServerJobStatus.fromXML((String)resultXML).getXML());
        Assert.assertEquals((String)"There should be one \"log_date\" node in the XML", (long)1L, (long)XMLHandler.countNodes((Node)newJobStatus, (String)"log_date"));
        Assert.assertTrue((String)"The \"log_date\" node should have a null value", (boolean)Utils.isEmpty((CharSequence)XMLHandler.getTagValue((Node)newJobStatus, (String)"log_date")));
    }

    @Test
    public void testWithDate() throws KettleException {
        String jobName = "testWithDate";
        String id = UUID.randomUUID().toString();
        String status = "Finished";
        Date logDate = new Date();
        SlaveServerJobStatus js = new SlaveServerJobStatus(jobName, id, status);
        js.setLogDate(logDate);
        String resultXML = js.getXML();
        Node newJobStatus = XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)resultXML), (String)"jobstatus");
        Assert.assertEquals((String)"The XML document should match after rebuilding from XML", (Object)resultXML, (Object)SlaveServerJobStatus.fromXML((String)resultXML).getXML());
        Assert.assertEquals((String)"There should be one \"log_date\" node in the XML", (long)1L, (long)XMLHandler.countNodes((Node)newJobStatus, (String)"log_date"));
        Assert.assertEquals((String)"The \"log_date\" node should match the original value", (Object)XMLHandler.date2string((Date)logDate), (Object)XMLHandler.getTagValue((Node)newJobStatus, (String)"log_date"));
    }

    @Test
    public void testSerialization() throws KettleException {
        List<String> attributes = Arrays.asList("JobName", "Id", "StatusDescription", "ErrorDescription", "LogDate", "LoggingString", "FirstLoggingLineNr", "LastLoggingLineNr");
        HashMap attributeMap = new HashMap();
        attributeMap.put("LoggingString", new LoggingStringLoadSaveValidator());
        SlaveServerJobStatusLoadSaveTester tester = new SlaveServerJobStatusLoadSaveTester(SlaveServerJobStatus.class, attributes, attributeMap);
        tester.testSerialization();
    }

    public static class LoggingStringLoadSaveValidator
    implements FieldLoadSaveValidator<String> {
        @Override
        public String getTestObject() {
            try {
                return HttpUtil.encodeBase64ZippedString((String)UUID.randomUUID().toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean validateTestObject(String testObject, Object actual) {
            try {
                return HttpUtil.decodeBase64ZippedString((String)testObject).equals(actual);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

