/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.SlaveServerConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SlaveServerConfigTest {
    public static final String XML_TAG_SLAVE_CONFIG = "slave_config";
    public static final String XML_TAG_JETTY_OPTIONS = "jetty_options";
    public static final String XML_TAG_ACCEPTORS = "acceptors";
    public static final String XML_TAG_ACCEPT_QUEUE_SIZE = "acceptQueueSize";
    public static final String XML_TAG_LOW_RES_MAX_IDLE_TIME = "lowResourcesMaxIdleTime";
    public static final String ACCEPTORS_VALUE = "10";
    public static final String EXPECTED_ACCEPTORS_VALUE = "10";
    public static final String EXPECTED_ACCEPTORS_KEY = "KETTLE_CARTE_JETTY_ACCEPTORS";
    public static final String ACCEPT_QUEUE_SIZE_VALUE = "8000";
    public static final String EXPECTED_ACCEPT_QUEUE_SIZE_VALUE = "8000";
    public static final String EXPECTED_ACCEPT_QUEUE_SIZE_KEY = "KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE";
    public static final String LOW_RES_MAX_IDLE_TIME_VALUE = "300";
    public static final String EXPECTED_LOW_RES_MAX_IDLE_TIME_VALUE = "300";
    public static final String EXPECTED_LOW_RES_MAX_IDLE_TIME_KEY = "KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME";
    Map<String, String> jettyOptions;
    SlaveServerConfig slServerConfig;

    @Before
    public void setup() throws Exception {
        this.slServerConfig = new SlaveServerConfig();
    }

    @After
    public void tearDown() {
        System.getProperties().remove(EXPECTED_ACCEPTORS_KEY);
        System.getProperties().remove(EXPECTED_ACCEPT_QUEUE_SIZE_KEY);
        System.getProperties().remove(EXPECTED_LOW_RES_MAX_IDLE_TIME_KEY);
    }

    @Test
    public void testSetUpJettyOptionsAsSystemParameters() throws KettleXMLException {
        Node configNode = this.getConfigNode(this.getConfigWithAllOptions());
        this.slServerConfig.setUpJettyOptions(configNode);
        Assert.assertTrue((String)"Expected containing jetty option KETTLE_CARTE_JETTY_ACCEPTORS", (boolean)System.getProperties().containsKey(EXPECTED_ACCEPTORS_KEY));
        Assert.assertEquals((Object)"10", (Object)System.getProperty(EXPECTED_ACCEPTORS_KEY));
        Assert.assertTrue((String)"Expected containing jetty option KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE", (boolean)System.getProperties().containsKey(EXPECTED_ACCEPT_QUEUE_SIZE_KEY));
        Assert.assertEquals((Object)"8000", (Object)System.getProperty(EXPECTED_ACCEPT_QUEUE_SIZE_KEY));
        Assert.assertTrue((String)"Expected containing jetty option KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME", (boolean)System.getProperties().containsKey(EXPECTED_LOW_RES_MAX_IDLE_TIME_KEY));
        Assert.assertEquals((Object)"300", (Object)System.getProperty(EXPECTED_LOW_RES_MAX_IDLE_TIME_KEY));
    }

    @Test
    public void testDoNotSetUpJettyOptionsAsSystemParameters_WhenNoOptionsNode() throws KettleXMLException {
        Node configNode = this.getConfigNode(this.getConfigWithNoOptionsNode());
        this.slServerConfig.setUpJettyOptions(configNode);
        Assert.assertFalse((String)"There should not be any jetty option but it is here:  KETTLE_CARTE_JETTY_ACCEPTORS", (boolean)System.getProperties().containsKey(EXPECTED_ACCEPTORS_KEY));
        Assert.assertFalse((String)"There should not be any jetty option but it is here:  KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE", (boolean)System.getProperties().containsKey(EXPECTED_ACCEPT_QUEUE_SIZE_KEY));
        Assert.assertFalse((String)"There should not be any jetty option but it is here:  KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME", (boolean)System.getProperties().containsKey(EXPECTED_LOW_RES_MAX_IDLE_TIME_KEY));
    }

    @Test
    public void testDoNotSetUpJettyOptionsAsSystemParameters_WhenEmptyOptionsNode() throws KettleXMLException {
        Node configNode = this.getConfigNode(this.getConfigWithEmptyOptionsNode());
        this.slServerConfig.setUpJettyOptions(configNode);
        Assert.assertFalse((String)"There should not be any jetty option but it is here:  KETTLE_CARTE_JETTY_ACCEPTORS", (boolean)System.getProperties().containsKey(EXPECTED_ACCEPTORS_KEY));
        Assert.assertFalse((String)"There should not be any jetty option but it is here:  KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE", (boolean)System.getProperties().containsKey(EXPECTED_ACCEPT_QUEUE_SIZE_KEY));
        Assert.assertFalse((String)"There should not be any jetty option but it is here:  KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME", (boolean)System.getProperties().containsKey(EXPECTED_LOW_RES_MAX_IDLE_TIME_KEY));
    }

    @Test
    public void testParseJettyOption_Acceptors() throws KettleXMLException {
        Node configNode = this.getConfigNode(this.getConfigWithAcceptorsOnlyOption());
        Map parseJettyOptions = this.slServerConfig.parseJettyOptions(configNode);
        Assert.assertNotNull((Object)parseJettyOptions);
        Assert.assertEquals((long)1L, (long)parseJettyOptions.size());
        Assert.assertTrue((String)"Expected containing key=KETTLE_CARTE_JETTY_ACCEPTORS", (boolean)parseJettyOptions.containsKey(EXPECTED_ACCEPTORS_KEY));
        Assert.assertEquals((Object)"10", parseJettyOptions.get(EXPECTED_ACCEPTORS_KEY));
    }

    @Test
    public void testParseJettyOption_AcceptQueueSize() throws KettleXMLException {
        Node configNode = this.getConfigNode(this.getConfigWithAcceptQueueSizeOnlyOption());
        Map parseJettyOptions = this.slServerConfig.parseJettyOptions(configNode);
        Assert.assertNotNull((Object)parseJettyOptions);
        Assert.assertEquals((long)1L, (long)parseJettyOptions.size());
        Assert.assertTrue((String)"Expected containing key=KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE", (boolean)parseJettyOptions.containsKey(EXPECTED_ACCEPT_QUEUE_SIZE_KEY));
        Assert.assertEquals((Object)"8000", parseJettyOptions.get(EXPECTED_ACCEPT_QUEUE_SIZE_KEY));
    }

    @Test
    public void testParseJettyOption_LowResourcesMaxIdleTime() throws KettleXMLException {
        Node configNode = this.getConfigNode(this.getConfigWithLowResourcesMaxIdleTimeeOnlyOption());
        Map parseJettyOptions = this.slServerConfig.parseJettyOptions(configNode);
        Assert.assertNotNull((Object)parseJettyOptions);
        Assert.assertEquals((long)1L, (long)parseJettyOptions.size());
        Assert.assertTrue((String)"Expected containing key=KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME", (boolean)parseJettyOptions.containsKey(EXPECTED_LOW_RES_MAX_IDLE_TIME_KEY));
        Assert.assertEquals((Object)"300", parseJettyOptions.get(EXPECTED_LOW_RES_MAX_IDLE_TIME_KEY));
    }

    @Test
    public void testParseJettyOption_AllOptions() throws KettleXMLException {
        Node configNode = this.getConfigNode(this.getConfigWithAllOptions());
        Map parseJettyOptions = this.slServerConfig.parseJettyOptions(configNode);
        Assert.assertNotNull((Object)parseJettyOptions);
        Assert.assertEquals((long)3L, (long)parseJettyOptions.size());
        Assert.assertTrue((String)"Expected containing key=KETTLE_CARTE_JETTY_ACCEPTORS", (boolean)parseJettyOptions.containsKey(EXPECTED_ACCEPTORS_KEY));
        Assert.assertEquals((Object)"10", parseJettyOptions.get(EXPECTED_ACCEPTORS_KEY));
        Assert.assertTrue((String)"Expected containing key=KETTLE_CARTE_JETTY_ACCEPT_QUEUE_SIZE", (boolean)parseJettyOptions.containsKey(EXPECTED_ACCEPT_QUEUE_SIZE_KEY));
        Assert.assertEquals((Object)"8000", parseJettyOptions.get(EXPECTED_ACCEPT_QUEUE_SIZE_KEY));
        Assert.assertTrue((String)"Expected containing key=KETTLE_CARTE_JETTY_RES_MAX_IDLE_TIME", (boolean)parseJettyOptions.containsKey(EXPECTED_LOW_RES_MAX_IDLE_TIME_KEY));
        Assert.assertEquals((Object)"300", parseJettyOptions.get(EXPECTED_LOW_RES_MAX_IDLE_TIME_KEY));
    }

    @Test
    public void testParseJettyOption_EmptyOptionsNode() throws KettleXMLException {
        Node configNode = this.getConfigNode(this.getConfigWithEmptyOptionsNode());
        Map parseJettyOptions = this.slServerConfig.parseJettyOptions(configNode);
        Assert.assertNotNull((Object)parseJettyOptions);
        Assert.assertEquals((long)0L, (long)parseJettyOptions.size());
    }

    @Test
    public void testParseJettyOption_NoOptionsNode() throws KettleXMLException {
        Node configNode = this.getConfigNode(this.getConfigWithNoOptionsNode());
        Map parseJettyOptions = this.slServerConfig.parseJettyOptions(configNode);
        Assert.assertNull((Object)parseJettyOptions);
    }

    private Node getConfigNode(String configString) throws KettleXMLException {
        Document document = XMLHandler.loadXMLString((String)configString);
        Node configNode = XMLHandler.getSubNode((Node)document, (String)XML_TAG_SLAVE_CONFIG);
        return configNode;
    }

    private String getConfigWithAcceptorsOnlyOption() {
        this.jettyOptions = new HashMap<String, String>();
        this.jettyOptions.put(XML_TAG_ACCEPTORS, "10");
        return this.getConfig(this.jettyOptions);
    }

    private String getConfigWithAcceptQueueSizeOnlyOption() {
        this.jettyOptions = new HashMap<String, String>();
        this.jettyOptions.put(XML_TAG_ACCEPT_QUEUE_SIZE, "8000");
        return this.getConfig(this.jettyOptions);
    }

    private String getConfigWithLowResourcesMaxIdleTimeeOnlyOption() {
        this.jettyOptions = new HashMap<String, String>();
        this.jettyOptions.put(XML_TAG_LOW_RES_MAX_IDLE_TIME, "300");
        return this.getConfig(this.jettyOptions);
    }

    private String getConfigWithAllOptions() {
        this.jettyOptions = new HashMap<String, String>();
        this.jettyOptions.put(XML_TAG_ACCEPTORS, "10");
        this.jettyOptions.put(XML_TAG_ACCEPT_QUEUE_SIZE, "8000");
        this.jettyOptions.put(XML_TAG_LOW_RES_MAX_IDLE_TIME, "300");
        return this.getConfig(this.jettyOptions);
    }

    private String getConfigWithEmptyOptionsNode() {
        this.jettyOptions = new HashMap<String, String>();
        return this.getConfig(this.jettyOptions);
    }

    private String getConfigWithNoOptionsNode() {
        return this.getConfig(this.jettyOptions);
    }

    private String getConfig(Map<String, String> jettyOptions) {
        StringBuilder xml = new StringBuilder(50);
        xml.append(XMLHandler.getXMLHeader((String)"UTF-8"));
        xml.append("<slave_config>").append(Const.CR);
        if (jettyOptions != null) {
            xml.append("<jetty_options>").append(Const.CR);
            for (Map.Entry<String, String> jettyOption : jettyOptions.entrySet()) {
                xml.append("<" + jettyOption.getKey() + ">").append(jettyOption.getValue());
                xml.append("</" + jettyOption.getKey() + ">").append(Const.CR);
            }
            xml.append("</jetty_options>").append(Const.CR);
        }
        xml.append("</slave_config>").append(Const.CR);
        return xml.toString();
    }
}

