/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.www.RunTransServlet;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.TransformationMap;

@RunWith(value=MockitoJUnitRunner.class)
public class RunTransServletTest {
    @Mock
    TransMeta transMeta;
    @Mock
    Trans trans;
    List<StepMetaDataCombi> stepList;
    ByteArrayOutputStream outData;
    PrintWriter out;
    String lineSeparator = System.getProperty("line.separator");
    String transId = "testId";
    String expectedOutputIfNoServletOutputSteps = "<webresult>" + this.lineSeparator + "  <result>OK</result>" + this.lineSeparator + "  <message>Transformation started</message>" + this.lineSeparator + "  <id>testId</id>" + this.lineSeparator + "</webresult>" + this.lineSeparator + this.lineSeparator;
    RunTransServlet runTransServlet;

    @Before
    public void setup() throws Exception {
        this.runTransServlet = new RunTransServlet();
        this.outData = new ByteArrayOutputStream();
        this.out = new PrintWriter(this.outData);
        this.stepList = new ArrayList<StepMetaDataCombi>();
        for (int i = 0; i < 5; ++i) {
            StepMetaDataCombi stepMetaDataCombi = new StepMetaDataCombi();
            StepMetaInterface stepMeta = (StepMetaInterface)Mockito.mock(StepMetaInterface.class);
            Mockito.when((Object)stepMeta.passDataToServletOutput()).thenReturn((Object)false);
            stepMetaDataCombi.meta = stepMeta;
            this.stepList.add(stepMetaDataCombi);
        }
        Mockito.when((Object)this.trans.getSteps()).thenReturn(this.stepList);
        Mockito.when((Object)this.trans.getContainerObjectId()).thenReturn((Object)this.transId);
    }

    @Test
    public void testFinishProcessingTransWithoutServletOutputSteps() throws Exception {
        this.runTransServlet.finishProcessing(this.trans, this.out);
        Assert.assertEquals((Object)this.expectedOutputIfNoServletOutputSteps, (Object)this.outData.toString());
    }

    @Test
    public void testFinishProcessingTransWithServletOutputSteps() throws Exception {
        StepMetaDataCombi stepMetaDataCombi = new StepMetaDataCombi();
        StepMetaInterface stepMeta = (StepMetaInterface)Mockito.mock(StepMetaInterface.class);
        Mockito.when((Object)stepMeta.passDataToServletOutput()).thenReturn((Object)true);
        stepMetaDataCombi.meta = stepMeta;
        this.stepList.add(stepMetaDataCombi);
        ((Trans)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Thread.currentThread();
                Thread.sleep(2000L);
                return null;
            }
        }).when((Object)this.trans)).waitUntilFinished();
        this.runTransServlet.finishProcessing(this.trans, this.out);
        Assert.assertTrue((boolean)this.outData.toString().isEmpty());
    }

    @Test
    public void testRunTransServletCheckParameter() throws Exception {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)request.getParameter("trans")).thenReturn((Object)"home/test.rtr");
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/kettle/runTrans");
        Mockito.when((Object)response.getWriter()).thenReturn((Object)printWriter);
        TransformationMap mockTransformationMap = (TransformationMap)Mockito.mock(TransformationMap.class);
        SlaveServerConfig slaveServerConfig = (SlaveServerConfig)Mockito.mock(SlaveServerConfig.class);
        Mockito.when((Object)mockTransformationMap.getSlaveServerConfig()).thenReturn((Object)slaveServerConfig);
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)slaveServerConfig.getRepository()).thenReturn((Object)repository);
        RepositoryDirectoryInterface repositoryDirectoryInterface = (RepositoryDirectoryInterface)Mockito.mock(RepositoryDirectoryInterface.class);
        Mockito.when((Object)repository.loadRepositoryDirectoryTree()).thenReturn((Object)repositoryDirectoryInterface);
        Mockito.when((Object)repositoryDirectoryInterface.findDirectory(Mockito.anyString())).thenReturn((Object)repositoryDirectoryInterface);
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Mockito.when((Object)repository.loadTransformation((ObjectId)Mockito.any(), (String)Mockito.any())).thenReturn((Object)transMeta);
        String testParameter = "testParameter";
        Mockito.when((Object)transMeta.listVariables()).thenReturn((Object)new String[]{testParameter});
        Mockito.when((Object)transMeta.getVariable(Mockito.anyString())).thenReturn((Object)"default value");
        Mockito.when((Object)transMeta.listParameters()).thenReturn((Object)new String[]{testParameter});
        Mockito.when((Object)request.getParameterNames()).thenReturn((Object)new StringTokenizer(testParameter));
        String testValue = "testValue";
        Mockito.when((Object)request.getParameterValues(testParameter)).thenReturn((Object)new String[]{testValue});
        RunTransServlet runTransServlet = (RunTransServlet)Mockito.mock(RunTransServlet.class);
        ((RunTransServlet)Mockito.doCallRealMethod().when((Object)runTransServlet)).doGet((HttpServletRequest)Mockito.anyObject(), (HttpServletResponse)Mockito.anyObject());
        Trans trans = new Trans(transMeta, (LoggingObjectInterface)new SimpleLoggingObject("/kettle/runTrans", LoggingObjectType.CARTE, null));
        Mockito.when((Object)runTransServlet.createTrans((TransMeta)Mockito.anyObject(), (SimpleLoggingObject)Mockito.anyObject())).thenReturn((Object)trans);
        Mockito.when((Object)transMeta.getParameterValue((String)Mockito.eq((Object)testParameter))).thenReturn((Object)testValue);
        runTransServlet.log = new LogChannel((Object)"RunTransServlet");
        runTransServlet.transformationMap = mockTransformationMap;
        runTransServlet.doGet(request, response);
        Assert.assertEquals((Object)testValue, (Object)trans.getParameterValue(testParameter));
    }
}

