/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.owasp.encoder.Encode;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.RemoveJobServlet;
import org.pentaho.di.www.ServletTestUtils;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class RemoveJobServletTest {
    private JobMap mockJobMap;
    private RemoveJobServlet removeJobServlet;

    @Before
    public void setup() {
        this.mockJobMap = (JobMap)Mockito.mock(JobMap.class);
        this.removeJobServlet = new RemoveJobServlet(this.mockJobMap);
    }

    @Test
    @PrepareForTest(value={Encode.class})
    public void testRemoveJobServletEscapesHtmlWhenTransNotFound() throws ServletException, IOException {
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        PowerMockito.spy(Encode.class);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/removeJob");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        this.removeJobServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("H1", out.toString())));
        PowerMockito.verifyStatic((VerificationMode)Mockito.atLeastOnce());
        Encode.forHtml((String)Matchers.anyString());
    }

    @Test
    @PrepareForTest(value={Encode.class})
    public void testRemoveJobServletEscapesHtmlWhenTransFound() throws ServletException, IOException {
        KettleLogStore.init();
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Job mockJob = (Job)Mockito.mock(Job.class);
        JobMeta mockJobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        LogChannelInterface mockLogChannelInterface = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        mockJob.setName("!@#$%\"'^&*()<>&/test string&");
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        PowerMockito.spy(Encode.class);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/removeJob");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        Mockito.when((Object)this.mockJobMap.getJob((CarteObjectEntry)Matchers.any(CarteObjectEntry.class))).thenReturn((Object)mockJob);
        Mockito.when((Object)mockJob.getLogChannelId()).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockJob.getLogChannel()).thenReturn((Object)mockLogChannelInterface);
        Mockito.when((Object)mockJob.getJobMeta()).thenReturn((Object)mockJobMeta);
        Mockito.when((Object)mockJobMeta.getMaximum()).thenReturn((Object)new Point(10, 10));
        this.removeJobServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("H3", out.toString())));
        PowerMockito.verifyStatic((VerificationMode)Mockito.atLeastOnce());
        Encode.forHtml((String)Matchers.anyString());
    }
}

