/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.owasp.encoder.Encode;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.GetTransStatusServlet;
import org.pentaho.di.www.ServletTestUtils;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.cache.CarteStatusCache;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class GetTransStatusServletTest {
    private TransformationMap mockTransformationMap;
    private GetTransStatusServlet getTransStatusServlet;

    @Before
    public void setup() {
        this.mockTransformationMap = (TransformationMap)Mockito.mock(TransformationMap.class);
        this.getTransStatusServlet = new GetTransStatusServlet(this.mockTransformationMap);
    }

    @Test
    @PrepareForTest(value={Encode.class})
    public void testGetTransStatusServletEscapesHtmlWhenTransNotFound() throws ServletException, IOException {
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        PowerMockito.spy(Encode.class);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/transStatus");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        this.getTransStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("H1", out.toString())));
        PowerMockito.verifyStatic((VerificationMode)Mockito.atLeastOnce());
        Encode.forHtml((String)Matchers.anyString());
    }

    @Test
    @PrepareForTest(value={Encode.class})
    public void testGetTransStatusServletEscapesHtmlWhenTransFound() throws ServletException, IOException {
        KettleLogStore.init();
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Trans mockTrans = (Trans)Mockito.mock(Trans.class);
        TransMeta mockTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        LogChannelInterface mockChannelInterface = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        PowerMockito.spy(Encode.class);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/transStatus");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        Mockito.when((Object)this.mockTransformationMap.getTransformation((CarteObjectEntry)Matchers.any(CarteObjectEntry.class))).thenReturn((Object)mockTrans);
        Mockito.when((Object)mockTrans.getLogChannel()).thenReturn((Object)mockChannelInterface);
        Mockito.when((Object)mockTrans.getTransMeta()).thenReturn((Object)mockTransMeta);
        Mockito.when((Object)mockTransMeta.getMaximum()).thenReturn((Object)new Point(10, 10));
        this.getTransStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("TITLE", out.toString())));
        PowerMockito.verifyStatic((VerificationMode)Mockito.atLeastOnce());
        Encode.forHtml((String)Matchers.anyString());
    }

    @Test
    public void testGetTransStatus() throws ServletException, IOException {
        CarteStatusCache cacheMock;
        KettleLogStore.init();
        this.getTransStatusServlet.cache = cacheMock = (CarteStatusCache)Mockito.mock(CarteStatusCache.class);
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Trans mockTrans = (Trans)Mockito.mock(Trans.class);
        TransMeta mockTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        LogChannelInterface mockChannelInterface = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        ServletOutputStream outMock = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        String id = "123";
        String logId = "logId";
        String useXml = "Y";
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/transStatus");
        Mockito.when((Object)mockHttpServletRequest.getParameter("id")).thenReturn((Object)id);
        Mockito.when((Object)mockHttpServletRequest.getParameter("xml")).thenReturn((Object)useXml);
        Mockito.when((Object)mockHttpServletResponse.getOutputStream()).thenReturn((Object)outMock);
        Mockito.when((Object)this.mockTransformationMap.getTransformation((CarteObjectEntry)Matchers.any(CarteObjectEntry.class))).thenReturn((Object)mockTrans);
        Mockito.when((Object)mockTrans.getLogChannel()).thenReturn((Object)mockChannelInterface);
        Mockito.when((Object)mockTrans.getTransMeta()).thenReturn((Object)mockTransMeta);
        Mockito.when((Object)mockTrans.getLogChannelId()).thenReturn((Object)logId);
        Mockito.when((Object)mockTrans.isFinishedOrStopped()).thenReturn((Object)true);
        Mockito.when((Object)mockTrans.getStatus()).thenReturn((Object)"Finished");
        Mockito.when((Object)mockTransMeta.getMaximum()).thenReturn((Object)new Point(10, 10));
        this.getTransStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Mockito.when((Object)cacheMock.get(logId, 0)).thenReturn((Object)new byte[]{0, 1, 2});
        this.getTransStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        ((CarteStatusCache)Mockito.verify((Object)cacheMock, (VerificationMode)Mockito.times((int)2))).get(logId, 0);
        ((CarteStatusCache)Mockito.verify((Object)cacheMock, (VerificationMode)Mockito.times((int)1))).put((String)Matchers.eq((Object)logId), Matchers.anyString(), Matchers.eq((int)0));
        ((Trans)Mockito.verify((Object)mockTrans, (VerificationMode)Mockito.times((int)1))).getLogChannel();
    }
}

