/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.www.GetSlavesServlet;
import org.pentaho.di.www.SlaveServerDetection;

public class GetSlavesServletTest {
    private GetSlavesServlet servlet;
    private HttpServletRequest request;
    private HttpServletResponse response;

    @Before
    public void before() {
        this.servlet = (GetSlavesServlet)Mockito.mock(GetSlavesServlet.class);
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    }

    @Test
    public void testUpdateActivityStatusInDoGet() throws Exception {
        LogChannelInterface log = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        ServletOutputStream outputStream = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        SlaveServerDetection activeServerDetection = (SlaveServerDetection)Mockito.mock(SlaveServerDetection.class);
        SlaveServerDetection inactiveServerDetection = (SlaveServerDetection)Mockito.mock(SlaveServerDetection.class);
        SlaveServer activeSlaveServer = (SlaveServer)Mockito.mock(SlaveServer.class);
        SlaveServer inactiveSlaveServer = (SlaveServer)Mockito.mock(SlaveServer.class);
        this.servlet.log = log;
        ArrayList<SlaveServerDetection> detections = new ArrayList<SlaveServerDetection>();
        detections.add(activeServerDetection);
        detections.add(inactiveServerDetection);
        ((LogChannelInterface)Mockito.doReturn((Object)false).when((Object)log)).isDebug();
        ((HttpServletResponse)Mockito.doReturn((Object)outputStream).when((Object)this.response)).getOutputStream();
        ((GetSlavesServlet)Mockito.doReturn(detections).when((Object)this.servlet)).getDetections();
        ((SlaveServerDetection)Mockito.doReturn((Object)activeSlaveServer).when((Object)activeServerDetection)).getSlaveServer();
        ((SlaveServerDetection)Mockito.doReturn((Object)inactiveSlaveServer).when((Object)inactiveServerDetection)).getSlaveServer();
        ((SlaveServer)Mockito.doThrow((Throwable)new Exception()).when((Object)inactiveSlaveServer)).getStatus();
        ((GetSlavesServlet)Mockito.doCallRealMethod().when((Object)this.servlet)).doGet(this.request, this.response);
        this.servlet.doGet(this.request, this.response);
        ((SlaveServer)Mockito.verify((Object)activeSlaveServer)).getStatus();
        ((SlaveServerDetection)Mockito.verify((Object)activeServerDetection, (VerificationMode)Mockito.never())).setActive(false);
        ((SlaveServerDetection)Mockito.verify((Object)activeServerDetection, (VerificationMode)Mockito.never())).setLastInactiveDate((Date)Matchers.anyObject());
        ((SlaveServerDetection)Mockito.verify((Object)activeServerDetection)).getXML();
        ((SlaveServer)Mockito.verify((Object)inactiveSlaveServer)).getStatus();
        ((SlaveServerDetection)Mockito.verify((Object)inactiveServerDetection)).setActive(false);
        ((SlaveServerDetection)Mockito.verify((Object)inactiveServerDetection)).setLastInactiveDate((Date)Matchers.anyObject());
        ((SlaveServerDetection)Mockito.verify((Object)inactiveServerDetection)).getXML();
    }
}

