/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.www.GetPropertiesServlet;

public class GetPropertiesServletTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void beforeClass() throws KettleException {
        PluginRegistry.addPluginType((PluginTypeInterface)TwoWayPasswordEncoderPluginType.getInstance());
        PluginRegistry.init();
        String passwordEncoderPluginID = Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_PASSWORD_ENCODER_PLUGIN"), (String)"Kettle");
        Encr.init((String)passwordEncoderPluginID);
    }

    @Test
    public void getContextPath() throws Exception {
        GetPropertiesServlet servlet = new GetPropertiesServlet();
        servlet.setJettyMode(true);
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/properties");
        Mockito.when((Object)mockHttpServletRequest.getParameter("xml")).thenReturn((Object)"Y");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        Mockito.when((Object)mockHttpServletResponse.getOutputStream()).thenReturn((Object)new ServletOutputStream(){
            private ByteArrayOutputStream baos = new ByteArrayOutputStream();

            public void write(int b) throws IOException {
                this.baos.write(b);
            }

            public String toString() {
                return this.baos.toString();
            }
        });
        servlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)mockHttpServletResponse.getOutputStream().toString().startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
    }
}

