/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.owasp.encoder.Encode;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.GetJobStatusServlet;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.ServletTestUtils;
import org.pentaho.di.www.cache.CarteStatusCache;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class GetJobStatusServletTest {
    private JobMap mockJobMap;
    private GetJobStatusServlet getJobStatusServlet;

    @Before
    public void setup() {
        this.mockJobMap = (JobMap)Mockito.mock(JobMap.class);
        this.getJobStatusServlet = new GetJobStatusServlet(this.mockJobMap);
    }

    @Test
    @PrepareForTest(value={Encode.class})
    public void testGetJobStatusServletEscapesHtmlWhenTransNotFound() throws ServletException, IOException {
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        PowerMockito.spy(Encode.class);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/jobStatus");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        this.getJobStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(ServletTestUtils.getInsideOfTag("H1", out.toString())));
        PowerMockito.verifyStatic((VerificationMode)Mockito.atLeastOnce());
        Encode.forHtml((String)Matchers.anyString());
    }

    @Test
    @PrepareForTest(value={Encode.class, Job.class})
    public void testGetJobStatusServletEscapesHtmlWhenTransFound() throws ServletException, IOException {
        KettleLogStore.init();
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Job mockJob = (Job)PowerMockito.mock(Job.class);
        JobMeta mockJobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        LogChannelInterface mockLogChannelInterface = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        StringWriter out = new StringWriter();
        PrintWriter printWriter = new PrintWriter(out);
        PowerMockito.spy(Encode.class);
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/jobStatus");
        Mockito.when((Object)mockHttpServletRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockHttpServletResponse.getWriter()).thenReturn((Object)printWriter);
        Mockito.when((Object)this.mockJobMap.getJob((CarteObjectEntry)Matchers.any(CarteObjectEntry.class))).thenReturn((Object)mockJob);
        PowerMockito.when((Object)mockJob.getJobname()).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        PowerMockito.when((Object)mockJob.getLogChannel()).thenReturn((Object)mockLogChannelInterface);
        PowerMockito.when((Object)mockJob.getJobMeta()).thenReturn((Object)mockJobMeta);
        PowerMockito.when((Object)mockJobMeta.getMaximum()).thenReturn((Object)new Point(10, 10));
        this.getJobStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Assert.assertFalse((boolean)out.toString().contains("!@#$%\"'^&*()<>&/test string&"));
        PowerMockito.verifyStatic((VerificationMode)Mockito.atLeastOnce());
        Encode.forHtml((String)Matchers.anyString());
    }

    @Test
    @PrepareForTest(value={Job.class})
    public void testGetJobStatus() throws ServletException, IOException {
        CarteStatusCache cacheMock;
        KettleLogStore.init();
        this.getJobStatusServlet.cache = cacheMock = (CarteStatusCache)Mockito.mock(CarteStatusCache.class);
        HttpServletRequest mockHttpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockHttpServletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Job mockJob = (Job)PowerMockito.mock(Job.class);
        JobMeta mockJobMeta = (JobMeta)Mockito.mock(JobMeta.class);
        LogChannelInterface mockLogChannelInterface = (LogChannelInterface)Mockito.mock(LogChannelInterface.class);
        ServletOutputStream outMock = (ServletOutputStream)Mockito.mock(ServletOutputStream.class);
        String id = "123";
        String logId = "logId";
        String useXml = "Y";
        Mockito.when((Object)mockHttpServletRequest.getContextPath()).thenReturn((Object)"/kettle/jobStatus");
        Mockito.when((Object)mockHttpServletRequest.getParameter("id")).thenReturn((Object)id);
        Mockito.when((Object)mockHttpServletRequest.getParameter("xml")).thenReturn((Object)useXml);
        Mockito.when((Object)mockHttpServletResponse.getOutputStream()).thenReturn((Object)outMock);
        Mockito.when((Object)this.mockJobMap.findJob(id)).thenReturn((Object)mockJob);
        PowerMockito.when((Object)mockJob.getJobname()).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        PowerMockito.when((Object)mockJob.getLogChannel()).thenReturn((Object)mockLogChannelInterface);
        PowerMockito.when((Object)mockJob.getJobMeta()).thenReturn((Object)mockJobMeta);
        PowerMockito.when((Object)mockJob.isFinished()).thenReturn((Object)true);
        PowerMockito.when((Object)mockJob.getLogChannelId()).thenReturn((Object)logId);
        PowerMockito.when((Object)mockJobMeta.getMaximum()).thenReturn((Object)new Point(10, 10));
        Mockito.when((Object)mockJob.getStatus()).thenReturn((Object)"Finished");
        this.getJobStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        Mockito.when((Object)cacheMock.get(logId, 0)).thenReturn((Object)new byte[]{0, 1, 2});
        this.getJobStatusServlet.doGet(mockHttpServletRequest, mockHttpServletResponse);
        ((CarteStatusCache)Mockito.verify((Object)cacheMock, (VerificationMode)Mockito.times((int)2))).get(logId, 0);
        ((CarteStatusCache)Mockito.verify((Object)cacheMock, (VerificationMode)Mockito.times((int)1))).put((String)Mockito.eq((Object)logId), Matchers.anyString(), Mockito.eq((int)0));
        ((Job)Mockito.verify((Object)mockJob, (VerificationMode)Mockito.times((int)1))).getLogChannel();
    }
}

