/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.util.Base64;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.www.Carte;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SlaveServerStatus;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Client.class})
public class CarteTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Ignore
    @Test
    public void test() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        System.setProperty("KETTLE_SLAVE_DETECTION_TIMER", "100");
        SlaveServer master = new SlaveServer();
        master.setHostname("127.0.0.1");
        master.setPort("9000");
        master.setUsername("cluster");
        master.setPassword("cluster");
        master.setMaster(true);
        SlaveServerConfig config = new SlaveServerConfig();
        config.setSlaveServer(master);
        final Carte carte = new Carte(config);
        SlaveServerDetection slaveServerDetection = (SlaveServerDetection)Mockito.mock(SlaveServerDetection.class);
        carte.getWebServer().getDetections().add(slaveServerDetection);
        SlaveServer slaveServer = (SlaveServer)Mockito.mock(SlaveServer.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)slaveServerDetection.getSlaveServer()).thenReturn((Object)slaveServer);
        Mockito.when((Object)slaveServer.getStatus()).thenAnswer((Answer)new Answer<SlaveServerStatus>(){

            public SlaveServerStatus answer(InvocationOnMock invocation) throws Throwable {
                SlaveServerDetection anotherDetection = (SlaveServerDetection)Mockito.mock(SlaveServerDetection.class);
                carte.getWebServer().getDetections().add(anotherDetection);
                latch.countDown();
                return new SlaveServerStatus();
            }
        });
        latch.await(10L, TimeUnit.SECONDS);
        Assert.assertEquals((long)carte.getWebServer().getDetections().size(), (long)2L);
        carte.getWebServer().stopServer();
    }

    @Test
    public void callStopCarteRestService() throws Exception {
        WebResource status = (WebResource)Mockito.mock(WebResource.class);
        ((WebResource)Mockito.doReturn((Object)"<serverstatus>").when((Object)status)).get(String.class);
        WebResource stop = (WebResource)Mockito.mock(WebResource.class);
        ((WebResource)Mockito.doReturn((Object)"Shutting Down").when((Object)stop)).get(String.class);
        Client client = (Client)Mockito.mock(Client.class);
        ((Client)Mockito.doCallRealMethod().when((Object)client)).addFilter((ClientFilter)Matchers.any(HTTPBasicAuthFilter.class));
        ((Client)Mockito.doCallRealMethod().when((Object)client)).getHeadHandler();
        ((Client)Mockito.doReturn((Object)status).when((Object)client)).resource("http://localhost:8080/kettle/status/?xml=Y");
        ((Client)Mockito.doReturn((Object)stop).when((Object)client)).resource("http://localhost:8080/kettle/stopCarte");
        PowerMockito.mockStatic(Client.class, (Class[])new Class[0]);
        Mockito.when((Object)Client.create((ClientConfig)((ClientConfig)Matchers.any(ClientConfig.class)))).thenReturn((Object)client);
        Carte.callStopCarteRestService((String)"localhost", (String)"8080", (String)"admin", (String)"Encrypted 2be98afc86aa7f2e4bb18bd63c99dbdde");
        Assert.assertEquals((Object)("Basic " + new String(Base64.getEncoder().encode("admin:password".getBytes("utf-8")))), (Object)Whitebox.getInternalState((Object)client.getHeadHandler(), (String)"authentication"));
    }
}

