/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.owasp.encoder.Encode;
import org.pentaho.di.www.AllocateServerSocketServlet;
import org.pentaho.di.www.ServletTestUtils;
import org.pentaho.di.www.SocketPortAllocation;
import org.pentaho.di.www.TransformationMap;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class AllocateServerSocketServletTest {
    private TransformationMap mockTransformationMap;
    private AllocateServerSocketServlet allocateServerSocketServlet;

    @Before
    public void setup() {
        this.mockTransformationMap = (TransformationMap)Mockito.mock(TransformationMap.class);
        this.allocateServerSocketServlet = new AllocateServerSocketServlet(this.mockTransformationMap);
    }

    @Test
    @PrepareForTest(value={Encode.class})
    public void testAllocateServerSocketServletEncodesParametersForHmtlResponse() throws ServletException, IOException {
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        SocketPortAllocation mockSocketPortAllocation = (SocketPortAllocation)Mockito.mock(SocketPortAllocation.class);
        PowerMockito.spy(Encode.class);
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ServletOutputStream servletOutputStream = new ServletOutputStream(){

            public void write(int b) throws IOException {
                byteArrayOutputStream.write(b);
            }
        };
        Mockito.when((Object)mockRequest.getContextPath()).thenReturn((Object)"/kettle/allocateSocket");
        Mockito.when((Object)mockRequest.getParameter(Matchers.anyString())).thenReturn((Object)"!@#$%\"'^&*()<>&/test string&");
        Mockito.when((Object)mockResponse.getOutputStream()).thenReturn((Object)servletOutputStream);
        Mockito.when((Object)this.mockTransformationMap.allocateServerSocketPort(Matchers.anyInt(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)mockSocketPortAllocation);
        this.allocateServerSocketServlet.doGet(mockRequest, mockResponse);
        String response = byteArrayOutputStream.toString();
        String dynamicBody = ServletTestUtils.getInsideOfTag("BODY", response).replaceAll("<p>", "").replaceAll("<br>", "").replaceAll("<H1>.+</H1>", "").replaceAll("--> port", "");
        Assert.assertFalse((boolean)ServletTestUtils.hasBadText(dynamicBody));
        PowerMockito.verifyStatic((VerificationMode)Mockito.atLeastOnce());
        Encode.forHtml((String)Matchers.anyString());
    }
}

