/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.utils;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.junit.Assert;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;

public class TestUtils {
    @Deprecated
    public static String createTempDir() {
        String ret = null;
        try {
            File file = File.createTempFile("temp_pentaho_test_dir", String.valueOf(System.currentTimeMillis()));
            file.delete();
            file.mkdir();
            file.deleteOnExit();
            ret = file.getAbsolutePath();
        }
        catch (Exception ex) {
            System.out.println("Can't create temp folder");
            ex.printStackTrace();
        }
        return ret;
    }

    public static File getInputFile(String prefix, String suffix) throws IOException {
        File inputFile = File.createTempFile(prefix, suffix);
        inputFile.deleteOnExit();
        FileUtils.writeStringToFile((File)inputFile, (String)UUID.randomUUID().toString(), (String)"UTF-8");
        return inputFile;
    }

    public static String createRamFile(String path) {
        return TestUtils.createRamFile(path, null);
    }

    public static String createRamFile(String path, VariableSpace space) {
        if (space == null) {
            space = new Variables();
            space.initializeVariablesFrom(null);
        }
        try {
            FileObject file = KettleVFS.getFileObject((String)("ram://" + path), (VariableSpace)space);
            file.createFile();
            return file.getName().getURI();
        }
        catch (FileSystemException | KettleFileException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileObject getFileObject(String vfsPath) {
        return TestUtils.getFileObject(vfsPath, null);
    }

    public static FileObject getFileObject(String vfsPath, VariableSpace space) {
        if (space == null) {
            space = new Variables();
            space.initializeVariablesFrom(null);
        }
        try {
            return KettleVFS.getFileObject((String)vfsPath, (VariableSpace)space);
        }
        catch (KettleFileException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toUnixLineSeparators(String string) {
        if (string != null) {
            string = string.replaceAll("\r", "");
        }
        return string;
    }

    public static void checkEqualsHashCodeConsistency(Object object1, Object object2) {
        if (object1.equals(object2)) {
            Assert.assertTrue((String)"inconsistent hashcode and equals", (object1.hashCode() == object2.hashCode() ? 1 : 0) != 0);
        }
    }
}

