/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.utils;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.FileUtil;
import org.pentaho.di.utils.TestUtils;

public class FileUtilsTest {
    @Test
    public void testCreateTempDir() {
        String tempDir = TestUtils.createTempDir();
        if (tempDir != null) {
            File fl = new File(tempDir);
            Assert.assertTrue((String)"Dir should be created", (boolean)fl.exists());
            try {
                fl.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Test
    public void testCreateParentFolder() {
        String tempDir = TestUtils.createTempDir();
        String suff = tempDir.substring(tempDir.lastIndexOf(File.separator) + 1);
        tempDir = tempDir + File.separator + suff + File.separator + suff;
        Assert.assertTrue((String)"Dir should be created", (boolean)FileUtil.createParentFolder(this.getClass(), (String)tempDir, (boolean)true, (LogChannelInterface)new LogChannel((Object)this), null));
        File fl = new File(tempDir.substring(0, tempDir.lastIndexOf(File.separator)));
        Assert.assertTrue((String)"Dir should exist", (boolean)fl.exists());
        fl.delete();
        new File(tempDir).delete();
    }

    @Test
    public void testIsFullyQualified() {
        Assert.assertTrue((boolean)FileUtil.isFullyQualified((String)"/test"));
        Assert.assertTrue((boolean)FileUtil.isFullyQualified((String)"\\test"));
    }
}

