/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.streaming.common;

import io.reactivex.Flowable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogChannelInterfaceFactory;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.streaming.api.StreamSource;
import org.pentaho.di.trans.streaming.api.StreamWindow;
import org.pentaho.di.trans.streaming.common.BaseStreamStep;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseStreamStepTest {
    private BaseStreamStep baseStreamStep;
    @Mock
    BaseStreamStepMeta meta;
    @Mock
    BaseStreamStepMeta metaWithVariables;
    @Mock
    StepDataInterface stepData;
    @Mock
    StreamSource<List<Object>> streamSource;
    @Mock
    StreamWindow<List<Object>, Result> streamWindow;
    @Mock
    LogChannelInterfaceFactory logChannelFactory;
    @Mock
    LogChannelInterface logChannel;
    @Mock
    private StepMeta parentStepMeta;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Before
    public void setUp() throws KettleException {
        KettleLogStore.setLogChannelInterfaceFactory((LogChannelInterfaceFactory)this.logChannelFactory);
        Mockito.when((Object)this.logChannelFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any())).thenReturn((Object)this.logChannel);
        StepMeta stepMeta = new StepMeta("BaseStreamStep", (StepMetaInterface)this.meta);
        TransMeta transMeta = new TransMeta();
        transMeta.addStep(stepMeta);
        Trans trans = new Trans(transMeta);
        this.baseStreamStep = new BaseStreamStep(stepMeta, this.stepData, 1, transMeta, trans);
        this.baseStreamStep.source = this.streamSource;
        this.baseStreamStep.window = this.streamWindow;
        this.baseStreamStep.setParentVariableSpace((VariableSpace)new Variables());
        StepMetaDataCombi stepMetaDataCombi = new StepMetaDataCombi();
        stepMetaDataCombi.step = this.baseStreamStep;
        stepMetaDataCombi.data = this.stepData;
        stepMetaDataCombi.stepMeta = stepMeta;
        stepMetaDataCombi.meta = this.meta;
        trans.prepareExecution(new String[0]);
        trans.getSteps().add(stepMetaDataCombi);
    }

    @Test
    public void testInitMissingFilename() {
        Mockito.when((Object)this.meta.getSpecificationMethod()).thenReturn((Object)ObjectLocationSpecificationMethod.FILENAME);
        Assert.assertFalse((boolean)this.baseStreamStep.init((StepMetaInterface)this.meta, this.stepData));
        ((LogChannelInterface)Mockito.verify((Object)this.logChannel)).logError(Matchers.contains((String)"Unable to load transformation "), (Throwable)Matchers.any(KettleException.class));
    }

    @Test
    public void testInitFilenameSubstitution() throws IOException, KettleException {
        KettleEnvironment.init();
        File testFile = File.createTempFile("testInitFilenameSubstitution", ".ktr", this.folder.getRoot());
        try (PrintWriter pw = new PrintWriter(testFile);){
            pw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<transformation/>");
        }
        Mockito.when((Object)this.meta.getParentStepMeta()).thenReturn((Object)this.parentStepMeta);
        Mockito.when((Object)this.metaWithVariables.getFileName()).thenReturn((Object)"noSuchFilename.ktr");
        Mockito.when((Object)this.meta.withVariables((VariableSpace)this.baseStreamStep)).thenReturn((Object)this.metaWithVariables);
        this.baseStreamStep.getParentVariableSpace().setVariable("Internal.Entry.Current.Directory", testFile.getParentFile().getAbsolutePath());
        Mockito.when((Object)this.metaWithVariables.getSpecificationMethod()).thenReturn((Object)ObjectLocationSpecificationMethod.FILENAME);
        Mockito.when((Object)this.meta.getSpecificationMethod()).thenReturn((Object)ObjectLocationSpecificationMethod.FILENAME);
        Mockito.when((Object)this.meta.getFileName()).thenReturn((Object)("${Internal.Entry.Current.Directory}/" + testFile.getName()));
        Assert.assertTrue((boolean)this.baseStreamStep.init((StepMetaInterface)this.meta, this.stepData));
        Assert.assertThat((Object)this.baseStreamStep.variablizedStepMeta, (Matcher)IsEqual.equalTo((Object)this.metaWithVariables));
    }

    @Test
    public void testStop() throws KettleException {
        Result result = new Result();
        result.setSafeStop(false);
        result.setRows(Collections.emptyList());
        Mockito.when((Object)this.streamWindow.buffer((Flowable)Matchers.any())).thenReturn(Collections.singletonList(result));
        this.baseStreamStep.processRow((StepMetaInterface)this.meta, this.stepData);
        Assert.assertFalse((boolean)this.baseStreamStep.isSafeStopped());
        ((StreamSource)Mockito.verify(this.streamSource)).close();
    }

    @Test
    public void testSafeStop() throws KettleException {
        Result result = new Result();
        result.setSafeStop(true);
        Mockito.when((Object)this.streamWindow.buffer((Flowable)Matchers.any())).thenReturn(Collections.singletonList(result));
        this.baseStreamStep.processRow((StepMetaInterface)this.meta, this.stepData);
        Assert.assertTrue((boolean)this.baseStreamStep.isSafeStopped());
        ((StreamSource)Mockito.verify(this.streamSource, (VerificationMode)Mockito.times((int)2))).close();
    }

    @Test
    public void testAlwaysCloses() throws KettleException {
        Mockito.when((Object)this.streamWindow.buffer((Flowable)Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException("run for your life!!!")});
        try {
            this.baseStreamStep.processRow((StepMetaInterface)this.meta, this.stepData);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((StreamSource)Mockito.verify(this.streamSource)).close();
    }
}

