/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.streaming.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.encryption.TwoWayPasswordEncoderPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogChannelInterfaceFactory;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.powermock.api.mockito.PowerMockito;
import org.w3c.dom.Node;

@RunWith(value=MockitoJUnitRunner.class)
public class BaseStreamStepMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private BaseStreamStepMeta meta;
    @Mock
    private LogChannelInterfaceFactory logChannelFactory;
    @Mock
    private LogChannelInterface logChannel;
    @Mock
    private RowMetaInterface rowMeta;
    @Mock
    private RowMetaInterface prevRowMeta;
    @Mock
    private StepMeta subTransStepMeta;
    @Mock
    private StepMeta nextStepMeta;
    @Mock
    private StepMetaInterface stepMetaInterface;
    @Mock
    private VariableSpace space;
    @Mock
    private Repository repo;
    @Mock
    private BaseStreamStepMeta.MappingMetaRetriever mappingMetaRetriever;
    @Mock
    private TransMeta subTransMeta;
    @Mock
    private TransMeta transMeta;

    @BeforeClass
    public static void setUpBeforeClass() throws KettleException {
        PluginRegistry.addPluginType((PluginTypeInterface)TwoWayPasswordEncoderPluginType.getInstance());
        PluginRegistry.init((boolean)false);
        String passwordEncoderPluginID = Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_PASSWORD_ENCODER_PLUGIN"), (String)"Kettle");
        Encr.init((String)passwordEncoderPluginID);
    }

    @Before
    public void setUp() throws Exception {
        this.meta = new StuffStreamMeta();
        KettleLogStore.setLogChannelInterfaceFactory((LogChannelInterfaceFactory)this.logChannelFactory);
        PowerMockito.when((Object)this.logChannelFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any())).thenReturn((Object)this.logChannel);
        PowerMockito.when((Object)this.logChannelFactory.create(Matchers.any())).thenReturn((Object)this.logChannel);
        PowerMockito.when((Object)this.mappingMetaRetriever.get((StepWithMappingMeta)Matchers.any(), (Repository)Matchers.any(), (IMetaStore)Matchers.any(), (VariableSpace)Matchers.any())).thenReturn((Object)this.subTransMeta);
        PowerMockito.when((Object)this.subTransMeta.getPrevStepFields(Matchers.anyString())).thenReturn((Object)this.prevRowMeta);
        PowerMockito.when((Object)this.subTransMeta.getSteps()).thenReturn(Collections.singletonList(this.subTransStepMeta));
        PowerMockito.when((Object)this.subTransStepMeta.getStepMetaInterface()).thenReturn((Object)this.stepMetaInterface);
        PowerMockito.when((Object)this.subTransStepMeta.getName()).thenReturn((Object)"SubStepName");
        this.meta.mappingMetaRetriever = this.mappingMetaRetriever;
    }

    @Test
    public void testCheckErrorsOnZeroSizeAndDuration() {
        this.meta.setBatchDuration("0");
        this.meta.setBatchSize("0");
        ArrayList remarks = new ArrayList();
        this.meta.check(remarks, null, null, null, null, null, null, (VariableSpace)new Variables(), null, null);
        org.junit.Assert.assertEquals((long)1L, (long)remarks.size());
        org.junit.Assert.assertEquals((Object)"The \"Number of records\" and \"Duration\" fields can\u2019t both be set to 0. Please set a value of 1 or higher for one of the fields.", (Object)((CheckResultInterface)remarks.get(0)).getText());
    }

    @Test
    public void testCheckErrorsOnNaN() {
        ArrayList remarks = new ArrayList();
        this.meta.setBatchDuration("blah");
        this.meta.setBatchSize("blah");
        this.meta.check(remarks, null, null, null, null, null, null, (VariableSpace)new Variables(), null, null);
        org.junit.Assert.assertEquals((long)2L, (long)remarks.size());
        org.junit.Assert.assertEquals((long)4L, (long)((CheckResultInterface)remarks.get(0)).getType());
        org.junit.Assert.assertEquals((Object)"The \"Duration\" field is using a non-numeric value. Please set a numeric value.", (Object)((CheckResultInterface)remarks.get(0)).getText());
        org.junit.Assert.assertEquals((long)4L, (long)((CheckResultInterface)remarks.get(1)).getType());
        org.junit.Assert.assertEquals((Object)"The \"Number of records\" field is using a non-numeric value. Please set a numeric value.", (Object)((CheckResultInterface)remarks.get(1)).getText());
    }

    @Test
    public void testCheckErrorsOnVariables() {
        ArrayList remarks = new ArrayList();
        Variables space = new Variables();
        space.setVariable("something", "1000");
        this.meta.setBatchSize("${something}");
        this.meta.setBatchDuration("0");
        this.meta.check(remarks, null, null, null, null, null, null, (VariableSpace)space, null, null);
        org.junit.Assert.assertEquals((long)0L, (long)remarks.size());
    }

    @Test
    public void testCheckErrorsOnSubStepName() {
        ArrayList remarks = new ArrayList();
        Variables space = new Variables();
        this.meta.setBatchSize("10");
        this.meta.setBatchDuration("10");
        this.meta.setSubStep("MissingStep");
        this.meta.check(remarks, null, null, null, null, null, null, (VariableSpace)space, null, null);
        org.junit.Assert.assertEquals((long)1L, (long)remarks.size());
        org.junit.Assert.assertEquals((Object)"Unable to complete \"null\".  Cannot return fields from \"MissingStep\" because it does not exist in the sub-transformation.", (Object)((CheckResultInterface)remarks.get(0)).getText());
    }

    @Test
    public void testCheckErrorsOnVariablesSubstituteError() {
        ArrayList remarks = new ArrayList();
        Variables space = new Variables();
        space.setVariable("something", "0");
        this.meta.setBatchSize("${something}");
        this.meta.setBatchDuration("${something}");
        this.meta.check(remarks, null, null, null, null, null, null, (VariableSpace)space, null, null);
        org.junit.Assert.assertEquals((long)1L, (long)remarks.size());
        org.junit.Assert.assertEquals((Object)"The \"Number of records\" and \"Duration\" fields can\u2019t both be set to 0. Please set a value of 1 or higher for one of the fields.", (Object)((CheckResultInterface)remarks.get(0)).getText());
        this.testRoundTrip(this.meta);
    }

    @Test
    public void testBasicRoundTrip() {
        this.meta.setBatchDuration("1000");
        this.meta.setBatchSize("100");
        this.meta.setTransformationPath("aPath");
        this.testRoundTrip(this.meta);
    }

    @Test
    public void testRoundTripInjectionList() {
        StuffStreamMeta startingMeta = new StuffStreamMeta();
        startingMeta.stuff = new ArrayList<String>();
        startingMeta.stuff.add("foo");
        startingMeta.stuff.add("bar");
        startingMeta.stuff.add("baz");
        startingMeta.setBatchDuration("1000");
        startingMeta.setBatchSize("100");
        startingMeta.setTransformationPath("aPath");
        startingMeta.setParallelism("4");
        this.testRoundTrip(startingMeta);
    }

    @Test
    public void testSaveDefaultEmptyConnection() {
        StuffStreamMeta meta = new StuffStreamMeta();
        this.testRoundTrip(meta);
    }

    @Test
    public void testGetResourceDependencies() {
        String stepId = "KafkConsumerInput";
        String path = "/home/bgroves/fake.ktr";
        StepMeta stepMeta = new StepMeta();
        stepMeta.setStepID(stepId);
        StuffStreamMeta inputMeta = new StuffStreamMeta();
        List resourceDependencies = inputMeta.getResourceDependencies(new TransMeta(), stepMeta);
        org.junit.Assert.assertEquals((long)0L, (long)((ResourceReference)resourceDependencies.get(0)).getEntries().size());
        inputMeta.setTransformationPath(path);
        resourceDependencies = inputMeta.getResourceDependencies(new TransMeta(), stepMeta);
        org.junit.Assert.assertEquals((long)1L, (long)((ResourceReference)resourceDependencies.get(0)).getEntries().size());
        org.junit.Assert.assertEquals((Object)path, (Object)((ResourceEntry)((ResourceReference)resourceDependencies.get(0)).getEntries().get(0)).getResource());
        org.junit.Assert.assertEquals((Object)ResourceEntry.ResourceType.ACTIONFILE, (Object)((ResourceEntry)((ResourceReference)resourceDependencies.get(0)).getEntries().get(0)).getResourcetype());
        this.testRoundTrip(inputMeta);
    }

    @Test
    public void testReferencedObjectHasDescription() {
        StuffStreamMeta meta = new StuffStreamMeta();
        org.junit.Assert.assertEquals((long)1L, (long)meta.getReferencedObjectDescriptions().length);
        Assert.assertTrue((meta.getReferencedObjectDescriptions()[0] != null ? 1 : 0) != 0);
        this.testRoundTrip(meta);
    }

    @Test
    public void testIsReferencedObjectEnabled() {
        StuffStreamMeta meta = new StuffStreamMeta();
        org.junit.Assert.assertEquals((long)1L, (long)meta.isReferencedObjectEnabled().length);
        org.junit.Assert.assertFalse((boolean)meta.isReferencedObjectEnabled()[0]);
        meta.setTransformationPath("/some/path");
        Assert.assertTrue((boolean)meta.isReferencedObjectEnabled()[0]);
        this.testRoundTrip(meta);
    }

    @Test
    public void testLoadReferencedObject() {
        StuffStreamMeta meta = new StuffStreamMeta();
        meta.setFileName(this.getClass().getResource("/org/pentaho/di/trans/subtrans-executor-sub.ktr").getPath());
        meta.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        try {
            TransMeta subTrans = (TransMeta)meta.loadReferencedObject(0, null, null, (VariableSpace)new Variables());
            org.junit.Assert.assertEquals((Object)"subtrans-executor-sub", (Object)subTrans.getName());
        }
        catch (KettleException e) {
            org.junit.Assert.fail();
        }
        this.testRoundTrip(meta);
    }

    @Test
    public void testGetFieldsDoesEnvSubstitutionForSubStepName() throws KettleStepException {
        StuffStreamMeta meta = new StuffStreamMeta();
        meta.setSubStep("${parameter}");
        PowerMockito.when((Object)this.space.environmentSubstitute("${parameter}")).thenReturn((Object)"realSubStepName");
        PowerMockito.when((Object)this.subTransStepMeta.getName()).thenReturn((Object)"realSubStepName");
        meta.mappingMetaRetriever = this.mappingMetaRetriever;
        meta.getFields(this.rowMeta, "origin", null, this.nextStepMeta, this.space, this.repo, null);
        ((VariableSpace)Mockito.verify((Object)this.space)).environmentSubstitute("${parameter}");
        ((TransMeta)Mockito.verify((Object)this.subTransMeta)).getPrevStepFields("realSubStepName");
        ((StepMetaInterface)Mockito.verify((Object)this.stepMetaInterface)).getFields(this.rowMeta, "origin", null, this.nextStepMeta, this.space, this.repo, null);
    }

    @Test
    public void replacingFileNameAlsoSetsTransformationPath() {
        StuffStreamMeta stuffStreamMeta = new StuffStreamMeta();
        stuffStreamMeta.replaceFileName("someName");
        org.junit.Assert.assertEquals((Object)"someName", (Object)stuffStreamMeta.getTransformationPath());
    }

    @Test
    public void testGetFileName() {
        this.meta = new StuffStreamMeta();
        String testPathName = "transformationPathName";
        String testFileName = "testFileName";
        this.meta.setTransformationPath(testPathName);
        MatcherAssert.assertThat((Object)this.meta.getFileName(), (Matcher)CoreMatchers.equalTo((Object)testPathName));
        this.meta.setFileName(testFileName);
        MatcherAssert.assertThat((Object)this.meta.getFileName(), (Matcher)CoreMatchers.equalTo((Object)testFileName));
    }

    private void testRoundTrip(BaseStreamStepMeta thisMeta) {
        StuffStreamMeta startingMeta = (StuffStreamMeta)thisMeta;
        String xml = startingMeta.getXML();
        StuffStreamMeta metaToRoundTrip = new StuffStreamMeta();
        try {
            Node stepNode = XMLHandler.getSubNode((Node)XMLHandler.loadXMLString((String)("<step>" + xml + "</step>")), (String)"step");
            metaToRoundTrip.loadXML(stepNode, Collections.emptyList(), null);
        }
        catch (KettleXMLException e) {
            throw new RuntimeException(e);
        }
        MatcherAssert.assertThat((Object)startingMeta.getBatchDuration(), (Matcher)CoreMatchers.equalTo((Object)metaToRoundTrip.getBatchDuration()));
        MatcherAssert.assertThat((Object)startingMeta.getBatchSize(), (Matcher)CoreMatchers.equalTo((Object)metaToRoundTrip.getBatchSize()));
        MatcherAssert.assertThat((Object)startingMeta.getTransformationPath(), (Matcher)CoreMatchers.equalTo((Object)metaToRoundTrip.getTransformationPath()));
        MatcherAssert.assertThat((Object)startingMeta.getParallelism(), (Matcher)CoreMatchers.equalTo((Object)metaToRoundTrip.getParallelism()));
        MatcherAssert.assertThat(startingMeta.stuff, (Matcher)CoreMatchers.equalTo(metaToRoundTrip.stuff));
    }

    @Step(id="StuffStream", name="Stuff Stream")
    @InjectionSupported(localizationPrefix="stuff", groups={"stuffGroup"})
    private static class StuffStreamMeta
    extends BaseStreamStepMeta {
        @Injection(name="stuff", group="stuffGroup")
        List<String> stuff = new ArrayList<String>();
        @Injection(name="AUTH_PASSWORD")
        String password;

        private StuffStreamMeta() {
            this.stuff.add("one");
            this.stuff.add("two");
            this.password = "test";
        }

        public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            return null;
        }

        public StepDataInterface getStepData() {
            return null;
        }

        public RowMeta getRowMeta(String origin, VariableSpace space) {
            return null;
        }
    }
}

