/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.zipfile;

import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.named.cluster.NamedClusterEmbedManager;
import org.pentaho.di.trans.steps.zipfile.ZipFile;
import org.pentaho.di.trans.steps.zipfile.ZipFileMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class ZipFileMetaTest {
    private static final String SOURCE_FILENAME = "Files";
    private static final String TARGET_FILENAME = "ZipFile";
    private static final String BASE_FOLDER = "BaseFolder";
    private static final String OPERATION_TYPE = "move";
    private static final boolean ADD_RESULT_FILENAME = true;
    private static final boolean OVERWRITE_ZIP_ENTRY = true;
    private static final boolean CREATE_PARENT_FOLDER = true;
    private static final boolean KEEP_SOURCE_FOLDER = true;
    private static final String MOVE_TO_FOLDER_FIELD = "movetothisfolder";

    @Test
    public void testGettersSetters() {
        ZipFileMeta zipFileMeta = new ZipFileMeta();
        zipFileMeta.setDynamicSourceFileNameField(SOURCE_FILENAME);
        zipFileMeta.setDynamicTargetFileNameField(TARGET_FILENAME);
        zipFileMeta.setBaseFolderField(BASE_FOLDER);
        zipFileMeta.setOperationType(ZipFileMeta.getOperationTypeByDesc((String)OPERATION_TYPE));
        zipFileMeta.setaddTargetFileNametoResult(true);
        zipFileMeta.setOverwriteZipEntry(true);
        zipFileMeta.setCreateParentFolder(true);
        zipFileMeta.setKeepSouceFolder(true);
        zipFileMeta.setMoveToFolderField(MOVE_TO_FOLDER_FIELD);
        Assert.assertEquals((Object)SOURCE_FILENAME, (Object)zipFileMeta.getDynamicSourceFileNameField());
        Assert.assertEquals((Object)TARGET_FILENAME, (Object)zipFileMeta.getDynamicTargetFileNameField());
        Assert.assertEquals((Object)BASE_FOLDER, (Object)zipFileMeta.getBaseFolderField());
        Assert.assertEquals((long)ZipFileMeta.getOperationTypeByDesc((String)OPERATION_TYPE), (long)zipFileMeta.getOperationType());
        Assert.assertEquals((Object)MOVE_TO_FOLDER_FIELD, (Object)zipFileMeta.getMoveToFolderField());
        Assert.assertTrue((boolean)zipFileMeta.isaddTargetFileNametoResult());
        Assert.assertTrue((boolean)zipFileMeta.isOverwriteZipEntry());
        Assert.assertTrue((boolean)zipFileMeta.isKeepSouceFolder());
        Assert.assertTrue((boolean)zipFileMeta.isCreateParentFolder());
        Assert.assertEquals((Object)MOVE_TO_FOLDER_FIELD, (Object)zipFileMeta.getMoveToFolderField());
        Assert.assertNotNull((Object)zipFileMeta.getStepData());
        Assert.assertTrue((boolean)zipFileMeta.supportsErrorHandling());
    }

    @Test
    public void testLoadAndGetXml() throws Exception {
        ZipFileMeta zipFileMeta = new ZipFileMeta();
        Node stepnode = this.getTestNode();
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        IMetaStore metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
        StepMeta mockParentStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        zipFileMeta.setParentStepMeta(mockParentStepMeta);
        TransMeta mockTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        NamedClusterEmbedManager embedManager = (NamedClusterEmbedManager)Mockito.mock(NamedClusterEmbedManager.class);
        Mockito.when((Object)mockParentStepMeta.getParentTransMeta()).thenReturn((Object)mockTransMeta);
        Mockito.when((Object)mockTransMeta.getNamedClusterEmbedManager()).thenReturn((Object)embedManager);
        zipFileMeta.loadXML(stepnode, Collections.singletonList(dbMeta), metaStore);
        this.assertXmlOutputMeta(zipFileMeta);
    }

    @Test
    public void testReadRep() throws Exception {
        ZipFileMeta zipFileMeta = new ZipFileMeta();
        Repository rep = (Repository)Mockito.mock(Repository.class);
        IMetaStore metastore = (IMetaStore)Mockito.mock(IMetaStore.class);
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        StringObjectId oid = new StringObjectId("oid");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)oid, "sourcefilenamefield")).thenReturn((Object)SOURCE_FILENAME);
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)oid, "targetfilenamefield")).thenReturn((Object)TARGET_FILENAME);
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)oid, "baseFolderField")).thenReturn((Object)BASE_FOLDER);
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)oid, "operation_type")).thenReturn((Object)OPERATION_TYPE);
        Mockito.when((Object)rep.getStepAttributeBoolean((ObjectId)oid, "addresultfilenames")).thenReturn((Object)true);
        Mockito.when((Object)rep.getStepAttributeBoolean((ObjectId)oid, "overwritezipentry")).thenReturn((Object)true);
        Mockito.when((Object)rep.getStepAttributeBoolean((ObjectId)oid, "createparentfolder")).thenReturn((Object)true);
        Mockito.when((Object)rep.getStepAttributeBoolean((ObjectId)oid, "keepsourcefolder")).thenReturn((Object)true);
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)oid, "movetofolderfield")).thenReturn((Object)MOVE_TO_FOLDER_FIELD);
        zipFileMeta.readRep(rep, metastore, (ObjectId)oid, Collections.singletonList(dbMeta));
        Assert.assertEquals((Object)SOURCE_FILENAME, (Object)zipFileMeta.getDynamicSourceFileNameField());
        Assert.assertEquals((Object)TARGET_FILENAME, (Object)zipFileMeta.getDynamicTargetFileNameField());
        Assert.assertEquals((Object)BASE_FOLDER, (Object)zipFileMeta.getBaseFolderField());
        Assert.assertEquals((long)ZipFileMeta.getOperationTypeByDesc((String)OPERATION_TYPE), (long)zipFileMeta.getOperationType());
        Assert.assertEquals((Object)MOVE_TO_FOLDER_FIELD, (Object)zipFileMeta.getMoveToFolderField());
        Assert.assertTrue((boolean)zipFileMeta.isaddTargetFileNametoResult());
        Assert.assertTrue((boolean)zipFileMeta.isOverwriteZipEntry());
        Assert.assertTrue((boolean)zipFileMeta.isKeepSouceFolder());
        Assert.assertTrue((boolean)zipFileMeta.isCreateParentFolder());
        Mockito.reset((Object[])new Object[]{rep, metastore});
        StringObjectId transid = new StringObjectId("transid");
        zipFileMeta.saveRep(rep, metastore, (ObjectId)transid, (ObjectId)oid);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)transid, (ObjectId)oid, "sourcefilenamefield", SOURCE_FILENAME);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)transid, (ObjectId)oid, "targetfilenamefield", TARGET_FILENAME);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)transid, (ObjectId)oid, "baseFolderField", BASE_FOLDER);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)transid, (ObjectId)oid, "operation_type", OPERATION_TYPE);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)transid, (ObjectId)oid, "addresultfilenames", true);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)transid, (ObjectId)oid, "overwritezipentry", true);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)transid, (ObjectId)oid, "createparentfolder", true);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)transid, (ObjectId)oid, "keepsourcefolder", true);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)transid, (ObjectId)oid, "movetofolderfield", MOVE_TO_FOLDER_FIELD);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{rep, metastore});
    }

    @Test
    public void testCheck() {
        ZipFileMeta zipFileMeta = new ZipFileMeta();
        zipFileMeta.setDefault();
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        StepMeta stepInfo = (StepMeta)Mockito.mock(StepMeta.class);
        RowMetaInterface prev = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Repository repos = (Repository)Mockito.mock(Repository.class);
        IMetaStore metastore = (IMetaStore)Mockito.mock(IMetaStore.class);
        RowMetaInterface info = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ArrayList remarks = new ArrayList();
        zipFileMeta.check(remarks, transMeta, stepInfo, prev, new String[]{"input"}, new String[]{"output"}, info, (VariableSpace)new Variables(), repos, metastore);
        Assert.assertEquals((long)2L, (long)remarks.size());
        Assert.assertEquals((Object)"Source Filename field is missing!", (Object)((CheckResultInterface)remarks.get(0)).getText());
        Assert.assertEquals((Object)"Step is receiving info from other steps.", (Object)((CheckResultInterface)remarks.get(1)).getText());
        remarks = new ArrayList();
        zipFileMeta = new ZipFileMeta();
        zipFileMeta.setDynamicSourceFileNameField("sourceFileField");
        zipFileMeta.check(remarks, transMeta, stepInfo, prev, new String[0], new String[]{"output"}, info, (VariableSpace)new Variables(), repos, metastore);
        Assert.assertEquals((long)2L, (long)remarks.size());
        Assert.assertEquals((Object)"Target Filename field was specified", (Object)((CheckResultInterface)remarks.get(0)).getText());
        Assert.assertEquals((Object)"No input received from other steps!", (Object)((CheckResultInterface)remarks.get(1)).getText());
    }

    @Test
    public void testGetStep() throws Exception {
        StepMeta stepInfo = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)stepInfo.getName()).thenReturn((Object)"Zip Step Name");
        StepDataInterface stepData = (StepDataInterface)Mockito.mock(StepDataInterface.class);
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Mockito.when((Object)transMeta.findStep("Zip Step Name")).thenReturn((Object)stepInfo);
        Trans trans = (Trans)Mockito.mock(Trans.class);
        ZipFileMeta zipFileMeta = new ZipFileMeta();
        ZipFile zipFile = (ZipFile)zipFileMeta.getStep(stepInfo, stepData, 0, transMeta, trans);
        Assert.assertEquals((Object)stepInfo, (Object)zipFile.getStepMeta());
        Assert.assertEquals((Object)stepData, (Object)zipFile.getStepDataInterface());
        Assert.assertEquals((Object)transMeta, (Object)zipFile.getTransMeta());
        Assert.assertEquals((Object)trans, (Object)zipFile.getTrans());
        Assert.assertEquals((long)0L, (long)zipFile.getCopy());
    }

    @Test
    public void testOperationType() {
        Assert.assertEquals((long)0L, (long)ZipFileMeta.getOperationTypeByDesc(null));
        Assert.assertEquals((long)1L, (long)ZipFileMeta.getOperationTypeByDesc((String)"Move source file"));
        Assert.assertEquals((long)1L, (long)ZipFileMeta.getOperationTypeByDesc((String)OPERATION_TYPE));
        Assert.assertEquals((long)0L, (long)ZipFileMeta.getOperationTypeByDesc((String)"doesn't exist"));
        Assert.assertEquals((Object)"Move source file", (Object)ZipFileMeta.getOperationTypeDesc((int)1));
        Assert.assertEquals((Object)"Do nothing", (Object)ZipFileMeta.getOperationTypeDesc((int)100));
        Assert.assertEquals((Object)"Do nothing", (Object)ZipFileMeta.getOperationTypeDesc((int)-1));
    }

    private Node getTestNode() throws KettleXMLException {
        String xml = "<step>" + Const.CR + "<name>Zip file</name>" + Const.CR + "<type>ZipFile</type>" + Const.CR + "<description/>" + Const.CR + "<distribute>Y</distribute>" + Const.CR + "<custom_distribution/>" + Const.CR + "<copies>1</copies>" + Const.CR + "<partitioning>" + Const.CR + "  <method>none</method>" + Const.CR + "  <schema_name/>" + Const.CR + "</partitioning>" + Const.CR + "<sourcefilenamefield>Files</sourcefilenamefield>" + Const.CR + "<targetfilenamefield>ZipFile</targetfilenamefield>" + Const.CR + "<baseFolderField>BaseFolder</baseFolderField>" + Const.CR + "<operation_type>move</operation_type>" + Const.CR + "<addresultfilenames>Y</addresultfilenames>" + Const.CR + "<overwritezipentry>Y</overwritezipentry>" + Const.CR + "<createparentfolder>Y</createparentfolder>" + Const.CR + "<keepsourcefolder>Y</keepsourcefolder>" + Const.CR + "<movetofolderfield/>" + Const.CR + "<cluster_schema/>" + Const.CR + "<remotesteps>" + Const.CR + "  <input></input>" + Const.CR + "  <output></output>" + Const.CR + "</remotesteps>" + Const.CR + "<GUI>" + Const.CR + "  <xloc>608</xloc>" + Const.CR + "  <yloc>48</yloc>" + Const.CR + "  <draw>Y</draw>" + Const.CR + "</GUI>" + Const.CR + "</step>" + Const.CR;
        return XMLHandler.loadXMLString((String)xml, (String)"step");
    }

    private void assertXmlOutputMeta(ZipFileMeta zipOutputFile) {
        Assert.assertEquals((Object)BASE_FOLDER, (Object)zipOutputFile.getBaseFolderField());
        Assert.assertEquals((Object)SOURCE_FILENAME, (Object)zipOutputFile.getDynamicSourceFileNameField());
        Assert.assertEquals((Object)TARGET_FILENAME, (Object)zipOutputFile.getDynamicTargetFileNameField());
        Assert.assertEquals(null, (Object)zipOutputFile.getMoveToFolderField());
        Assert.assertEquals((Object)("    <sourcefilenamefield>Files</sourcefilenamefield>" + Const.CR + "    <targetfilenamefield>ZipFile</targetfilenamefield>" + Const.CR + "    <baseFolderField>BaseFolder</baseFolderField>" + Const.CR + "    <operation_type>move</operation_type>" + Const.CR + "    <addresultfilenames>Y</addresultfilenames>" + Const.CR + "    <overwritezipentry>Y</overwritezipentry>" + Const.CR + "    <createparentfolder>Y</createparentfolder>" + Const.CR + "    <keepsourcefolder>Y</keepsourcefolder>" + Const.CR + "    <movetofolderfield/>" + Const.CR), (Object)zipOutputFile.getXML());
        zipOutputFile.setDefault();
        Assert.assertEquals((Object)("    <sourcefilenamefield>Files</sourcefilenamefield>" + Const.CR + "    <targetfilenamefield>ZipFile</targetfilenamefield>" + Const.CR + "    <baseFolderField>BaseFolder</baseFolderField>" + Const.CR + "    <operation_type/>" + Const.CR + "    <addresultfilenames>N</addresultfilenames>" + Const.CR + "    <overwritezipentry>N</overwritezipentry>" + Const.CR + "    <createparentfolder>N</createparentfolder>" + Const.CR + "    <keepsourcefolder>N</keepsourcefolder>" + Const.CR + "    <movetofolderfield/>" + Const.CR), (Object)zipOutputFile.getXML());
    }
}

