/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.yamlinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.yamlinput.YamlInputField;
import org.pentaho.di.trans.steps.yamlinput.YamlInputMeta;

public class YamlInputMetaTest
implements InitializerInterface<StepMetaInterface> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;
    Class<YamlInputMeta> testMetaClass = YamlInputMeta.class;

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("includeFilename", "filenameField", "includeRowNumber", "rowNumberField", "rowLimit", "encoding", "yamlField", "inFields", "IsAFile", "addResultFile", "validating", "IsIgnoreEmptyFile", "doNotFailIfNoFile", "fileName", "fileMask", "fileRequired", "includeSubFolders", "inputFields");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("includeFilename", "includeFilename");
                this.put("filenameField", "getFilenameField");
                this.put("includeRowNumber", "includeRowNumber");
                this.put("rowNumberField", "getRowNumberField");
                this.put("rowLimit", "getRowLimit");
                this.put("encoding", "getEncoding");
                this.put("yamlField", "getYamlField");
                this.put("inFields", "isInFields");
                this.put("IsAFile", "getIsAFile");
                this.put("addResultFile", "addResultFile");
                this.put("validating", "isValidating");
                this.put("IsIgnoreEmptyFile", "isIgnoreEmptyFile");
                this.put("doNotFailIfNoFile", "isdoNotFailIfNoFile");
                this.put("fileName", "getFileName");
                this.put("fileMask", "getFileMask");
                this.put("fileRequired", "getFileRequired");
                this.put("includeSubFolders", "getIncludeSubFolders");
                this.put("inputFields", "getInputFields");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("includeFilename", "setIncludeFilename");
                this.put("filenameField", "setFilenameField");
                this.put("includeRowNumber", "setIncludeRowNumber");
                this.put("rowNumberField", "setRowNumberField");
                this.put("rowLimit", "setRowLimit");
                this.put("encoding", "setEncoding");
                this.put("yamlField", "setYamlField");
                this.put("inFields", "setInFields");
                this.put("IsAFile", "setIsAFile");
                this.put("addResultFile", "setAddResultFile");
                this.put("validating", "setValidating");
                this.put("IsIgnoreEmptyFile", "setIgnoreEmptyFile");
                this.put("doNotFailIfNoFile", "setdoNotFailIfNoFile");
                this.put("fileName", "setFileName");
                this.put("fileMask", "setFileMask");
                this.put("fileRequired", "setFileRequired");
                this.put("includeSubFolders", "setIncludeSubFolders");
                this.put("inputFields", "setInputFields");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        ArrayLoadSaveValidator<YamlInputField> yamlInputFieldArrayLoadSaveValidator = new ArrayLoadSaveValidator<YamlInputField>(new YamlInputFieldLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fileName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileRequired", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fileMask", stringArrayLoadSaveValidator);
        attrValidatorMap.put("includeSubFolders", stringArrayLoadSaveValidator);
        attrValidatorMap.put("inputFields", yamlInputFieldArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof YamlInputMeta) {
            ((YamlInputMeta)someMeta).allocate(5, 5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class YamlInputFieldLoadSaveValidator
    implements FieldLoadSaveValidator<YamlInputField> {
        final Random rand = new Random();

        @Override
        public YamlInputField getTestObject() {
            YamlInputField rtn = new YamlInputField();
            rtn.setCurrencySymbol(UUID.randomUUID().toString());
            rtn.setDecimalSymbol(UUID.randomUUID().toString());
            rtn.setFormat(UUID.randomUUID().toString());
            rtn.setGroupSymbol(UUID.randomUUID().toString());
            rtn.setName(UUID.randomUUID().toString());
            rtn.setTrimType(this.rand.nextInt(4));
            rtn.setPrecision(this.rand.nextInt(9));
            rtn.setLength(this.rand.nextInt(50));
            rtn.setPath(UUID.randomUUID().toString());
            rtn.setType(this.rand.nextInt(8));
            return rtn;
        }

        @Override
        public boolean validateTestObject(YamlInputField testObject, Object actual) {
            if (!(actual instanceof YamlInputField)) {
                return false;
            }
            YamlInputField actualInput = (YamlInputField)actual;
            return testObject.getXML().equals(actualInput.getXML());
        }
    }
}

