/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices;

import java.net.URISyntaxException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicHeader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.webservices.WebService;
import org.pentaho.di.trans.steps.webservices.WebServiceData;
import org.pentaho.di.trans.steps.webservices.WebServiceMeta;

public class WebServiceTest {
    private static final String LOCATION_HEADER = "Location";
    private static final String TEST_URL = "TEST_URL";
    private static final String NOT_VALID_URL = "NOT VALID URL";
    private StepMockHelper<WebServiceMeta, WebServiceData> mockHelper;
    private WebService webServiceStep;

    @Before
    public void setUpBefore() {
        this.mockHelper = new StepMockHelper<WebServiceMeta, WebServiceData>("WebService", WebServiceMeta.class, WebServiceData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
        this.webServiceStep = (WebService)Mockito.spy((Object)new WebService(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans));
    }

    @After
    public void cleanUp() {
        this.mockHelper.cleanUp();
    }

    @Test(expected=URISyntaxException.class)
    public void newHttpMethodWithInvalidUrl() throws URISyntaxException {
        this.webServiceStep.getHttpMethod(NOT_VALID_URL);
    }

    @Test
    public void getLocationFrom() {
        HttpPost postMethod = (HttpPost)Mockito.mock(HttpPost.class);
        BasicHeader locationHeader = new BasicHeader(LOCATION_HEADER, TEST_URL);
        ((HttpPost)Mockito.doReturn((Object)locationHeader).when((Object)postMethod)).getFirstHeader(LOCATION_HEADER);
        Assert.assertEquals((Object)TEST_URL, (Object)WebService.getLocationFrom((HttpPost)postMethod));
    }
}

