/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.webservices.WebServiceField;
import org.pentaho.di.trans.steps.webservices.WebServiceMeta;
import org.pentaho.di.utils.TestUtils;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class WebServiceMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        KettleClientEnvironment.init();
    }

    @Test
    public void testLoadXml() throws Exception {
        Node node = this.getTestNode();
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        IMetaStore metastore = (IMetaStore)Mockito.mock(IMetaStore.class);
        WebServiceMeta webServiceMeta = new WebServiceMeta(node, Collections.singletonList(dbMeta), metastore);
        Assert.assertEquals((Object)"httpUser", (Object)webServiceMeta.getHttpLogin());
        Assert.assertEquals((Object)"tryandguess", (Object)webServiceMeta.getHttpPassword());
        Assert.assertEquals((Object)"http://webservices.gama-system.com/exchangerates.asmx?WSDL", (Object)webServiceMeta.getUrl());
        Assert.assertEquals((Object)"GetCurrentExchangeRate", (Object)webServiceMeta.getOperationName());
        Assert.assertEquals((Object)"opRequestName", (Object)webServiceMeta.getOperationRequestName());
        Assert.assertEquals((Object)"GetCurrentExchangeRateResult", (Object)webServiceMeta.getOutFieldArgumentName());
        Assert.assertEquals((Object)"aProxy", (Object)webServiceMeta.getProxyHost());
        Assert.assertEquals((Object)"4444", (Object)webServiceMeta.getProxyPort());
        Assert.assertEquals((long)1L, (long)webServiceMeta.getCallStep());
        Assert.assertFalse((boolean)webServiceMeta.isPassingInputData());
        Assert.assertTrue((boolean)webServiceMeta.isCompatible());
        Assert.assertFalse((boolean)webServiceMeta.isReturningReplyAsString());
        List fieldsIn = webServiceMeta.getFieldsIn();
        Assert.assertEquals((long)3L, (long)fieldsIn.size());
        this.assertWebServiceField((WebServiceField)fieldsIn.get(0), "Bank", "strBank", "string", 2);
        this.assertWebServiceField((WebServiceField)fieldsIn.get(1), "ToCurrency", "strCurrency", "string", 2);
        this.assertWebServiceField((WebServiceField)fieldsIn.get(2), "Rank", "intRank", "int", 5);
        List fieldsOut = webServiceMeta.getFieldsOut();
        Assert.assertEquals((long)1L, (long)fieldsOut.size());
        this.assertWebServiceField((WebServiceField)fieldsOut.get(0), "GetCurrentExchangeRateResult", "GetCurrentExchangeRateResult", "decimal", 6);
        WebServiceMeta clone = webServiceMeta.clone();
        Assert.assertNotSame((Object)clone, (Object)webServiceMeta);
        Assert.assertEquals((Object)clone.getXML(), (Object)webServiceMeta.getXML());
    }

    void assertWebServiceField(WebServiceField webServiceField, String name, String wsName, String xsdType, int type) {
        Assert.assertEquals((Object)name, (Object)webServiceField.getName());
        Assert.assertEquals((Object)wsName, (Object)webServiceField.getWsName());
        Assert.assertEquals((Object)xsdType, (Object)webServiceField.getXsdType());
        Assert.assertEquals((long)type, (long)webServiceField.getType());
    }

    @Test
    public void testReadRep() throws Exception {
        Repository rep = (Repository)Mockito.mock(Repository.class);
        IMetaStore metastore = (IMetaStore)Mockito.mock(IMetaStore.class);
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        StringObjectId id_step = new StringObjectId("oid");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "wsOperation")).thenReturn((Object)"GetCurrentExchangeRate");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "wsOperationRequest")).thenReturn((Object)"opRequest");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "wsOperationNamespace")).thenReturn((Object)"opNamespace");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "wsInFieldContainer")).thenReturn((Object)"ifc");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "wsInFieldArgument")).thenReturn((Object)"ifa");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "wsOutFieldContainer")).thenReturn((Object)"ofc");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "wsOutFieldArgument")).thenReturn((Object)"ofa");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "proxyHost")).thenReturn((Object)"phost");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "proxyPort")).thenReturn((Object)"1234");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "httpLogin")).thenReturn((Object)"user");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "httpPassword")).thenReturn((Object)"password");
        Mockito.when((Object)rep.getStepAttributeInteger((ObjectId)id_step, "callStep")).thenReturn((Object)2L);
        Mockito.when((Object)rep.getStepAttributeBoolean((ObjectId)id_step, "passingInputData")).thenReturn((Object)true);
        Mockito.when((Object)rep.getStepAttributeBoolean((ObjectId)id_step, 0, "compatible", true)).thenReturn((Object)false);
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, "repeating_element")).thenReturn((Object)"repeat");
        Mockito.when((Object)rep.getStepAttributeBoolean((ObjectId)id_step, 0, "reply_as_string")).thenReturn((Object)true);
        Mockito.when((Object)rep.countNrStepAttributes((ObjectId)id_step, "fieldIn_ws_name")).thenReturn((Object)2);
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 0, "fieldIn_name")).thenReturn((Object)"bank");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 0, "fieldIn_ws_name")).thenReturn((Object)"inBank");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 0, "fieldIn_xsd_type")).thenReturn((Object)"string");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 1, "fieldIn_name")).thenReturn((Object)"branch");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 1, "fieldIn_ws_name")).thenReturn((Object)"inBranch");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 1, "fieldIn_xsd_type")).thenReturn((Object)"string");
        Mockito.when((Object)rep.countNrStepAttributes((ObjectId)id_step, "fieldOut_ws_name")).thenReturn((Object)2);
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 0, "fieldOut_name")).thenReturn((Object)"balance");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 0, "fieldOut_ws_name")).thenReturn((Object)"outBalance");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 0, "fieldOut_xsd_type")).thenReturn((Object)"int");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 1, "fieldOut_name")).thenReturn((Object)"transactions");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 1, "fieldOut_ws_name")).thenReturn((Object)"outTransactions");
        Mockito.when((Object)rep.getStepAttributeString((ObjectId)id_step, 1, "fieldOut_xsd_type")).thenReturn((Object)"int");
        WebServiceMeta webServiceMeta = new WebServiceMeta(rep, metastore, (ObjectId)id_step, Collections.singletonList(dbMeta));
        String expectedXml = "    <wsURL/>\n    <wsOperation>GetCurrentExchangeRate</wsOperation>\n    <wsOperationRequest>opRequest</wsOperationRequest>\n    <wsOperationNamespace>opNamespace</wsOperationNamespace>\n    <wsInFieldContainer>ifc</wsInFieldContainer>\n    <wsInFieldArgument>ifa</wsInFieldArgument>\n    <wsOutFieldContainer>ofc</wsOutFieldContainer>\n    <wsOutFieldArgument>ofa</wsOutFieldArgument>\n    <proxyHost>phost</proxyHost>\n    <proxyPort>1234</proxyPort>\n    <httpLogin>user</httpLogin>\n    <httpPassword>password</httpPassword>\n    <callStep>2</callStep>\n    <passingInputData>Y</passingInputData>\n    <compatible>N</compatible>\n    <repeating_element>repeat</repeating_element>\n    <reply_as_string>Y</reply_as_string>\n    <fieldsIn>\n    <field>\n        <name>bank</name>\n        <wsName>inBank</wsName>\n        <xsdType>string</xsdType>\n    </field>\n    <field>\n        <name>branch</name>\n        <wsName>inBranch</wsName>\n        <xsdType>string</xsdType>\n    </field>\n      </fieldsIn>\n    <fieldsOut>\n    <field>\n        <name>balance</name>\n        <wsName>outBalance</wsName>\n        <xsdType>int</xsdType>\n    </field>\n    <field>\n        <name>transactions</name>\n        <wsName>outTransactions</wsName>\n        <xsdType>int</xsdType>\n    </field>\n      </fieldsOut>\n";
        String actualXml = TestUtils.toUnixLineSeparators(webServiceMeta.getXML());
        Assert.assertEquals((Object)expectedXml, (Object)actualXml);
    }

    @Test
    public void testSaveRep() throws Exception {
        Node node = this.getTestNode();
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        IMetaStore metastore = (IMetaStore)Mockito.mock(IMetaStore.class);
        Repository rep = (Repository)Mockito.mock(Repository.class);
        WebServiceMeta webServiceMeta = new WebServiceMeta();
        webServiceMeta.loadXML(node, Collections.singletonList(dbMeta), metastore);
        StringObjectId aTransId = new StringObjectId("aTransId");
        StringObjectId aStepId = new StringObjectId("aStepId");
        webServiceMeta.saveRep(rep, metastore, (ObjectId)aTransId, (ObjectId)aStepId);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "wsUrl", "http://webservices.gama-system.com/exchangerates.asmx?WSDL");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "wsOperation", "GetCurrentExchangeRate");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "wsOperationRequest", "opRequestName");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "wsOperationNamespace", "http://www.gama-system.com/webservices");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "wsInFieldContainer", null);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "wsInFieldArgument", null);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "wsOutFieldContainer", "GetCurrentExchangeRateResult");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "wsOutFieldArgument", "GetCurrentExchangeRateResult");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "proxyHost", "aProxy");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "proxyPort", "4444");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "httpLogin", "httpUser");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "httpPassword", "tryandguess");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "callStep", 1L);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "passingInputData", false);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "compatible", true);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "repeating_element", null);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, "reply_as_string", false);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 0, "fieldIn_name", "Bank");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 0, "fieldIn_ws_name", "strBank");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 0, "fieldIn_xsd_type", "string");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 1, "fieldIn_name", "ToCurrency");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 1, "fieldIn_ws_name", "strCurrency");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 1, "fieldIn_xsd_type", "string");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 2, "fieldIn_name", "Rank");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 2, "fieldIn_ws_name", "intRank");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 2, "fieldIn_xsd_type", "int");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 0, "fieldOut_name", "GetCurrentExchangeRateResult");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 0, "fieldOut_ws_name", "GetCurrentExchangeRateResult");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)aTransId, (ObjectId)aStepId, 0, "fieldOut_xsd_type", "decimal");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{rep});
    }

    @Test
    public void testGetFields() throws Exception {
        WebServiceMeta webServiceMeta = new WebServiceMeta();
        webServiceMeta.setDefault();
        RowMetaInterface rmi = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        RowMetaInterface rmi2 = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        StepMeta nextStep = (StepMeta)Mockito.mock(StepMeta.class);
        IMetaStore metastore = (IMetaStore)Mockito.mock(IMetaStore.class);
        Repository rep = (Repository)Mockito.mock(Repository.class);
        WebServiceField field1 = new WebServiceField();
        field1.setName("field1");
        field1.setWsName("field1WS");
        field1.setXsdType("string");
        WebServiceField field2 = new WebServiceField();
        field2.setName("field2");
        field2.setWsName("field2WS");
        field2.setXsdType("string");
        WebServiceField field3 = new WebServiceField();
        field3.setName("field3");
        field3.setWsName("field3WS");
        field3.setXsdType("string");
        webServiceMeta.setFieldsOut(Arrays.asList(field1, field2, field3));
        webServiceMeta.getFields(rmi, "idk", new RowMetaInterface[]{rmi2}, nextStep, (VariableSpace)new Variables(), rep, metastore);
        ((RowMetaInterface)Mockito.verify((Object)rmi)).addValueMeta((ValueMetaInterface)Mockito.argThat(this.matchValueMetaString("field1")));
        ((RowMetaInterface)Mockito.verify((Object)rmi)).addValueMeta((ValueMetaInterface)Mockito.argThat(this.matchValueMetaString("field2")));
        ((RowMetaInterface)Mockito.verify((Object)rmi)).addValueMeta((ValueMetaInterface)Mockito.argThat(this.matchValueMetaString("field3")));
    }

    private Matcher<ValueMetaInterface> matchValueMetaString(final String fieldName) {
        return new BaseMatcher<ValueMetaInterface>(){

            public boolean matches(Object item) {
                return fieldName.equals(((ValueMetaString)item).getName());
            }

            public void describeTo(Description description) {
            }
        };
    }

    @Test
    public void testCheck() throws Exception {
        WebServiceMeta webServiceMeta = new WebServiceMeta();
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        RowMetaInterface prev = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        RowMetaInterface info = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Repository rep = (Repository)Mockito.mock(Repository.class);
        IMetaStore metastore = (IMetaStore)Mockito.mock(IMetaStore.class);
        String[] input = new String[]{"one"};
        ArrayList remarks = new ArrayList();
        webServiceMeta.check(remarks, transMeta, stepMeta, null, input, null, info, (VariableSpace)new Variables(), rep, metastore);
        Assert.assertEquals((long)2L, (long)remarks.size());
        Assert.assertEquals((Object)"Not receiving any fields from previous steps!", (Object)((CheckResultInterface)remarks.get(0)).getText());
        Assert.assertEquals((Object)"Step is receiving info from other steps.", (Object)((CheckResultInterface)remarks.get(1)).getText());
        remarks.clear();
        webServiceMeta.setInFieldArgumentName("ifan");
        Mockito.when((Object)prev.size()).thenReturn((Object)2);
        webServiceMeta.check(remarks, transMeta, stepMeta, prev, new String[0], null, info, (VariableSpace)new Variables(), rep, metastore);
        Assert.assertEquals((long)2L, (long)remarks.size());
        Assert.assertEquals((Object)"Step is connected to previous one, receiving 2 fields", (Object)((CheckResultInterface)remarks.get(0)).getText());
        Assert.assertEquals((Object)"No input received from other steps!", (Object)((CheckResultInterface)remarks.get(1)).getText());
    }

    @Test
    public void testGetFieldOut() throws Exception {
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        IMetaStore metastore = (IMetaStore)Mockito.mock(IMetaStore.class);
        WebServiceMeta webServiceMeta = new WebServiceMeta(this.getTestNode(), Collections.singletonList(dbMeta), metastore);
        Assert.assertNull((Object)webServiceMeta.getFieldOutFromWsName("", true));
        Assert.assertEquals((Object)"GetCurrentExchangeRateResult", (Object)webServiceMeta.getFieldOutFromWsName("GetCurrentExchangeRateResult", false).getName());
        Assert.assertEquals((Object)"GetCurrentExchangeRateResult", (Object)webServiceMeta.getFieldOutFromWsName("something:GetCurrentExchangeRateResult", true).getName());
    }

    private Node getTestNode() throws KettleXMLException {
        String xml = "  <step>\n    <name>Web services lookup</name>\n    <type>WebServiceLookup</type>\n    <description/>\n    <distribute>Y</distribute>\n    <custom_distribution/>\n    <copies>1</copies>\n         <partitioning>\n           <method>none</method>\n           <schema_name/>\n           </partitioning>\n    <wsURL>http&#x3a;&#x2f;&#x2f;webservices.gama-system.com&#x2f;exchangerates.asmx&#x3f;WSDL</wsURL>\n    <wsOperation>GetCurrentExchangeRate</wsOperation>\n    <wsOperationRequest>opRequestName</wsOperationRequest>\n    <wsOperationNamespace>http&#x3a;&#x2f;&#x2f;www.gama-system.com&#x2f;webservices</wsOperationNamespace>\n    <wsInFieldContainer/>\n    <wsInFieldArgument/>\n    <wsOutFieldContainer>GetCurrentExchangeRateResult</wsOutFieldContainer>\n    <wsOutFieldArgument>GetCurrentExchangeRateResult</wsOutFieldArgument>\n    <proxyHost>aProxy</proxyHost>\n    <proxyPort>4444</proxyPort>\n    <httpLogin>httpUser</httpLogin>\n    <httpPassword>tryandguess</httpPassword>\n    <callStep>1</callStep>\n    <passingInputData>N</passingInputData>\n    <compatible>Y</compatible>\n    <repeating_element/>\n    <reply_as_string>N</reply_as_string>\n    <fieldsIn>\n    <field>\n        <name>Bank</name>\n        <wsName>strBank</wsName>\n        <xsdType>string</xsdType>\n    </field>\n    <field>\n        <name>ToCurrency</name>\n        <wsName>strCurrency</wsName>\n        <xsdType>string</xsdType>\n    </field>\n    <field>\n        <name>Rank</name>\n        <wsName>intRank</wsName>\n        <xsdType>int</xsdType>\n    </field>\n      </fieldsIn>\n    <fieldsOut>\n    <field>\n        <name>GetCurrentExchangeRateResult</name>\n        <wsName>GetCurrentExchangeRateResult</wsName>\n        <xsdType>decimal</xsdType>\n    </field>\n      </fieldsOut>\n     <cluster_schema/>\n <remotesteps>   <input>   </input>   <output>   </output> </remotesteps>    <GUI>\n      <xloc>331</xloc>\n      <yloc>207</yloc>\n      <draw>Y</draw>\n      </GUI>\n    </step>\n";
        return XMLHandler.loadXMLString((String)xml, (String)"step");
    }
}

