/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.ListLoadSaveValidator;
import org.pentaho.di.trans.steps.webservices.WebServiceField;
import org.pentaho.di.trans.steps.webservices.WebServiceMeta;
import org.pentaho.di.trans.steps.webservices.wsdl.XsdType;

public class WebServiceMetaLoadSaveTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;
    Class<WebServiceMeta> testMetaClass = WebServiceMeta.class;

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("url", "operationName", "operationRequestName", "operationNamespace", "inFieldContainerName", "inFieldArgumentName", "outFieldContainerName", "outFieldArgumentName", "proxyHost", "proxyPort", "httpLogin", "httpPassword", "passingInputData", "callStep", "compatible", "repeatingElementName", "returningReplyAsString", "fieldsIn", "fieldsOut");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fieldsIn", new ListLoadSaveValidator<WebServiceField>(new WebServiceFieldLoadSaveValidator(), 5));
        attrValidatorMap.put("fieldsOut", new ListLoadSaveValidator<WebServiceField>(new WebServiceFieldLoadSaveValidator(), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<WebServiceMeta>(this.testMetaClass, attributes, getterMap, setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class WebServiceFieldLoadSaveValidator
    implements FieldLoadSaveValidator<WebServiceField> {
        final Random rand = new Random();

        @Override
        public WebServiceField getTestObject() {
            WebServiceField rtn = new WebServiceField();
            rtn.setName(UUID.randomUUID().toString());
            rtn.setWsName(UUID.randomUUID().toString());
            rtn.setXsdType(XsdType.TYPES[this.rand.nextInt(XsdType.TYPES.length)]);
            return rtn;
        }

        @Override
        public boolean validateTestObject(WebServiceField testObject, Object actual) {
            if (!(actual instanceof WebServiceField)) {
                return false;
            }
            WebServiceField another = (WebServiceField)actual;
            return new EqualsBuilder().append((Object)testObject.getName(), (Object)another.getName()).append((Object)testObject.getWsName(), (Object)another.getWsName()).append((Object)testObject.getXsdType(), (Object)another.getXsdType()).isEquals();
        }
    }
}

