/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.valuemapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.valuemapper.ValueMapperMeta;

public class ValueMapperMetaTest
implements InitializerInterface<StepMetaInterface> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;
    Class<ValueMapperMeta> testMetaClass = ValueMapperMeta.class;

    @Before
    public void setUpLoadSave() throws Exception {
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 7);
        this.init(stringArrayLoadSaveValidator, stringArrayLoadSaveValidator);
    }

    private void init(FieldLoadSaveValidator<String[]> sourceStringArrayLoadSaveValidator, FieldLoadSaveValidator<String[]> targetStringArrayLoadSaveValidator) throws KettleException {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("fieldToUse", "targetField", "nonMatchDefault", "sourceValue", "targetValue");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("fieldToUse", "getFieldToUse");
                this.put("targetField", "getTargetField");
                this.put("nonMatchDefault", "getNonMatchDefault");
                this.put("sourceValue", "getSourceValue");
                this.put("targetValue", "getTargetValue");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("fieldToUse", "setFieldToUse");
                this.put("targetField", "setTargetField");
                this.put("nonMatchDefault", "setNonMatchDefault");
                this.put("sourceValue", "setSourceValue");
                this.put("targetValue", "setTargetValue");
            }
        };
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("sourceValue", sourceStringArrayLoadSaveValidator);
        attrValidatorMap.put("targetValue", targetStringArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof ValueMapperMeta) {
            ((ValueMapperMeta)someMeta).allocate(7);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testSerializationWithNullAttr() throws KettleException {
        String abc = "abc";
        String stringNull = "null";
        String[] sourceAttrs = new String[]{abc, null, abc, null, stringNull, null, stringNull};
        String[] targetAttrs = new String[]{abc, null, null, abc, null, stringNull, stringNull};
        ArrayLoadSaveValidator<String> sourceValidator = new ArrayLoadSaveValidator<String>(new CustomStringLoadSaveValidator(sourceAttrs), sourceAttrs.length);
        ArrayLoadSaveValidator<String> targetValidator = new ArrayLoadSaveValidator<String>(new CustomStringLoadSaveValidator(targetAttrs), targetAttrs.length);
        this.init(sourceValidator, targetValidator);
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testPDI16559() throws Exception {
        ValueMapperMeta valueMapper = new ValueMapperMeta();
        valueMapper.setSourceValue(new String[]{"value1", "value2", "value3", "value4"});
        valueMapper.setTargetValue(new String[]{"targ1", "targ2"});
        try {
            String badXml = valueMapper.getXML();
            Assert.fail((String)"Before calling afterInjectionSynchronization, should have thrown an ArrayIndexOOB");
        }
        catch (Exception badXml) {
            // empty catch block
        }
        valueMapper.afterInjectionSynchronization();
        String ktrXml = valueMapper.getXML();
        Assert.assertEquals((long)valueMapper.getSourceValue().length, (long)valueMapper.getTargetValue().length);
    }

    private static class CustomStringLoadSaveValidator
    extends StringLoadSaveValidator {
        private String[] values;
        private int index = 0;

        public CustomStringLoadSaveValidator(String ... values) {
            this.values = values;
        }

        @Override
        public String getTestObject() {
            int i = this.index++;
            this.index %= this.values.length;
            return this.values[i];
        }

        @Override
        public boolean validateTestObject(String test, Object actual) {
            return test == null ? this.nullOrEmpty(actual) : test.equals(actual);
        }

        private boolean nullOrEmpty(Object o) {
            return o == null || StringUtils.isEmpty((String)o.toString());
        }
    }
}

