/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.validator;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.validator.Validation;
import org.pentaho.di.trans.steps.validator.Validator;
import org.pentaho.di.trans.steps.validator.ValidatorData;
import org.pentaho.di.trans.steps.validator.ValidatorMeta;

public class ValidatorTest {
    private Validator validator;
    private StepMockHelper<ValidatorMeta, ValidatorData> mockHelper;

    @Before
    public void setUp() throws Exception {
        this.mockHelper = new StepMockHelper<ValidatorMeta, ValidatorData>("Validator", ValidatorMeta.class, ValidatorData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
        this.validator = (Validator)Mockito.spy((Object)new Validator(this.mockHelper.stepMeta, this.mockHelper.stepDataInterface, 0, this.mockHelper.transMeta, this.mockHelper.trans));
    }

    @After
    public void cleanUp() {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testPatternExpectedCompile() throws KettlePluginException {
        ValidatorData data = new ValidatorData();
        ValidatorMeta meta = new ValidatorMeta();
        data.regularExpression = new String[1];
        data.regularExpressionNotAllowed = new String[1];
        data.patternExpected = new Pattern[1];
        data.patternDisallowed = new Pattern[1];
        Validation v = new Validation();
        v.setFieldName("field");
        v.setDataType(1);
        v.setRegularExpression("${param}");
        v.setRegularExpressionNotAllowed("${param}");
        meta.setValidations(Collections.singletonList(v));
        this.validator.setVariable("param", "^(((0[1-9]|[12]\\d|3[01])\\/(0[13578]|1[02])\\/((1[6-9]|[2-9]\\d)\\d{2}))|((0[1-9]|[12]\\d|30)\\/(0[13456789]|1[012])\\/((1[6-9]|[2-9]\\d)\\d{2}))|((0[1-9]|1\\d|2[0-8])\\/02\\/((1[6-9]|[2-9]\\d)\\d{2}))|(29\\/02\\/((1[6-9]|[2-9]\\d)(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))))$");
        ((Validator)Mockito.doReturn((Object)new ValueMetaString("field")).when((Object)this.validator)).createValueMeta(Matchers.anyString(), Matchers.anyInt());
        ((Validator)Mockito.doReturn((Object)new ValueMetaString("field")).when((Object)this.validator)).cloneValueMeta((ValueMetaInterface)Matchers.anyObject(), Matchers.anyInt());
        this.validator.init((StepMetaInterface)meta, (StepDataInterface)data);
    }

    @Test
    public void assertNumeric_Integer() throws Exception {
        this.assertNumericForNumberMeta((ValueMetaInterface)new ValueMetaInteger("int"), 1L);
    }

    @Test
    public void assertNumeric_Number() throws Exception {
        this.assertNumericForNumberMeta((ValueMetaInterface)new ValueMetaNumber("number"), 1.0);
    }

    @Test
    public void assertNumeric_BigNumber() throws Exception {
        this.assertNumericForNumberMeta((ValueMetaInterface)new ValueMetaBigNumber("big-number"), BigDecimal.ONE);
    }

    private void assertNumericForNumberMeta(ValueMetaInterface numeric, Object data) throws Exception {
        Assert.assertTrue((boolean)numeric.isNumeric());
        Assert.assertNull((Object)this.validator.assertNumeric(numeric, data, new Validation()));
    }

    @Test
    public void assertNumeric_StringWithDigits() throws Exception {
        ValueMetaString metaString = new ValueMetaString("string-with-digits");
        Assert.assertNull((String)"Strings with digits are allowed", (Object)this.validator.assertNumeric((ValueMetaInterface)metaString, (Object)"123", new Validation()));
    }

    @Test
    public void assertNumeric_String() throws Exception {
        ValueMetaString metaString = new ValueMetaString("string");
        Assert.assertNotNull((String)"General strings are not allowed", (Object)this.validator.assertNumeric((ValueMetaInterface)metaString, (Object)"qwerty", new Validation()));
    }

    @Test
    public void readSourceValuesFromInfoStepsTest() throws Exception {
        String name = "Valid list";
        String field = "sourcing field 1";
        String values = "A";
        this.mockHelper.stepMeta.setName(name);
        ValidatorMeta meta = new ValidatorMeta();
        ArrayList<Validation> validations = new ArrayList<Validation>();
        Validation validation1 = new Validation("validation1");
        validation1.setSourcingValues(true);
        validation1.setSourcingField(field);
        validations.add(validation1);
        Validation validation2 = new Validation("validation2");
        validation2.setSourcingValues(true);
        validation2.setSourcingField("sourcing field 2");
        validations.add(validation2);
        meta.setValidations(validations);
        StepMeta stepMeta = new StepMeta();
        stepMeta.setName(name);
        RowSet rowSet = (RowSet)Mockito.mock(RowSet.class);
        Mockito.when((Object)rowSet.getOriginStepName()).thenReturn((Object)name);
        Mockito.when((Object)rowSet.getDestinationStepName()).thenReturn((Object)"Validator");
        Mockito.when((Object)rowSet.getOriginStepCopy()).thenReturn((Object)0);
        Mockito.when((Object)rowSet.getDestinationStepCopy()).thenReturn((Object)0);
        Mockito.when((Object)rowSet.getRow()).thenReturn((Object)new String[]{values}).thenReturn(null);
        Mockito.when((Object)rowSet.isDone()).thenReturn((Object)true);
        RowMetaInterface allowedRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)rowSet.getRowMeta()).thenReturn((Object)allowedRowMeta);
        Mockito.when((Object)rowSet.getRowMeta()).thenReturn(Mockito.mock(RowMetaInterface.class));
        Mockito.when((Object)allowedRowMeta.indexOfValue(field)).thenReturn((Object)0);
        Mockito.when((Object)allowedRowMeta.getValueMeta(0)).thenReturn(Mockito.mock(ValueMetaInterface.class));
        ArrayList<RowSet> rowSets = new ArrayList<RowSet>();
        rowSets.add(rowSet);
        this.validator.setInputRowSets(rowSets);
        this.mockHelper.transMeta.setStep(0, stepMeta);
        Mockito.when((Object)this.mockHelper.transMeta.findStep((String)Mockito.eq((Object)name))).thenReturn((Object)stepMeta);
        StepMeta stepMetaValidList = new StepMeta();
        stepMetaValidList.setName(name);
        ((StreamInterface)meta.getStepIOMeta().getInfoStreams().get(0)).setStepMeta(stepMetaValidList);
        ((StreamInterface)meta.getStepIOMeta().getInfoStreams().get(1)).setStepMeta(stepMetaValidList);
        Class<Validator> validatorClass = Validator.class;
        Field metaField = validatorClass.getDeclaredField("meta");
        metaField.setAccessible(true);
        metaField.set(this.validator, meta);
        ValidatorData data = new ValidatorData();
        data.constantsMeta = new ValueMetaInterface[2];
        Field dataField = validatorClass.getDeclaredField("data");
        dataField.setAccessible(true);
        dataField.set(this.validator, data);
        data.listValues = new Object[2][2];
        this.validator.readSourceValuesFromInfoSteps();
        Assert.assertEquals((Object)values, (Object)data.listValues[0][0]);
        Assert.assertEquals((Object)values, (Object)data.listValues[1][0]);
    }
}

