/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.ListLoadSaveValidator;
import org.pentaho.di.trans.steps.validator.Validation;
import org.pentaho.di.trans.steps.validator.ValidatorMeta;

public class ValidatorMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<ValidatorMeta> testMetaClass = ValidatorMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("validatingAll", "concatenatingErrors", "concatenationSeparator", "validations");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("validatingAll", "isValidatingAll");
                this.put("concatenatingErrors", "isConcatenatingErrors");
                this.put("concatenationSeparator", "getConcatenationSeparator");
                this.put("validations", "getValidations");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("validatingAll", "setValidatingAll");
                this.put("concatenatingErrors", "setConcatenatingErrors");
                this.put("concatenationSeparator", "setConcatenationSeparator");
                this.put("validations", "setValidations");
            }
        };
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("validations", new ListLoadSaveValidator<Validation>(new ValidationLoadSaveValidator(), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof ValidatorMeta) {
            ((ValidatorMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class ValidationLoadSaveValidator
    implements FieldLoadSaveValidator<Validation> {
        final Random rand = new Random();

        @Override
        public Validation getTestObject() {
            Validation rtn = new Validation();
            rtn.setName(UUID.randomUUID().toString());
            rtn.setFieldName(UUID.randomUUID().toString());
            rtn.setMaximumLength(UUID.randomUUID().toString());
            rtn.setMinimumLength(UUID.randomUUID().toString());
            rtn.setNullAllowed(this.rand.nextBoolean());
            rtn.setOnlyNullAllowed(this.rand.nextBoolean());
            rtn.setOnlyNumericAllowed(this.rand.nextBoolean());
            rtn.setDataType(this.rand.nextInt(9));
            rtn.setDataTypeVerified(this.rand.nextBoolean());
            rtn.setConversionMask(UUID.randomUUID().toString());
            rtn.setDecimalSymbol(UUID.randomUUID().toString());
            rtn.setGroupingSymbol(UUID.randomUUID().toString());
            rtn.setMinimumValue(UUID.randomUUID().toString());
            rtn.setMaximumValue(UUID.randomUUID().toString());
            rtn.setAllowedValues(new String[]{UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString(), UUID.randomUUID().toString()});
            rtn.setSourcingValues(this.rand.nextBoolean());
            rtn.setSourcingStepName(UUID.randomUUID().toString());
            rtn.setSourcingStep(null);
            rtn.setSourcingField(UUID.randomUUID().toString());
            rtn.setStartString(UUID.randomUUID().toString());
            rtn.setStartStringNotAllowed(UUID.randomUUID().toString());
            rtn.setEndString(UUID.randomUUID().toString());
            rtn.setEndStringNotAllowed(UUID.randomUUID().toString());
            rtn.setRegularExpression(UUID.randomUUID().toString());
            rtn.setRegularExpressionNotAllowed(UUID.randomUUID().toString());
            rtn.setErrorCode(UUID.randomUUID().toString());
            rtn.setErrorDescription(UUID.randomUUID().toString());
            return rtn;
        }

        @Override
        public boolean validateTestObject(Validation testObject, Object actual) {
            if (!(actual instanceof Validation)) {
                return false;
            }
            Validation actualInput = (Validation)actual;
            return testObject.getXML().equals(actualInput.getXML());
        }
    }
}

