/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.userdefinedjavaclass;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClassDef;
import org.pentaho.di.trans.steps.userdefinedjavaclass.UserDefinedJavaClassMeta;

public class UserDefinedJavaClassMetaTest {
    @Test
    public void cookClassErrorCompilationTest() throws Exception {
        String wrongCode = "public boolean processRow() {\n   return true;\n}\n\npublic boolean processRow() {\n   return true;\n}\n";
        UserDefinedJavaClassMeta userDefinedJavaClassMeta = new UserDefinedJavaClassMeta();
        UserDefinedJavaClassDef userDefinedJavaClassDef = (UserDefinedJavaClassDef)Mockito.mock(UserDefinedJavaClassDef.class);
        Mockito.when((Object)userDefinedJavaClassDef.isTransformClass()).thenReturn((Object)false);
        Mockito.when((Object)userDefinedJavaClassDef.getSource()).thenReturn((Object)wrongCode);
        Mockito.when((Object)userDefinedJavaClassDef.getClassName()).thenReturn((Object)"MainClass");
        Mockito.when((Object)userDefinedJavaClassDef.isActive()).thenReturn((Object)true);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)stepMeta.getName()).thenReturn((Object)"User Defined Java Class");
        userDefinedJavaClassMeta.setParentStepMeta(stepMeta);
        UserDefinedJavaClassMeta userDefinedJavaClassMetaSpy = (UserDefinedJavaClassMeta)Mockito.spy((Object)userDefinedJavaClassMeta);
        Mockito.when((Object)userDefinedJavaClassMetaSpy.getDefinitions()).thenReturn(Collections.singletonList(userDefinedJavaClassDef));
        userDefinedJavaClassMetaSpy.cookClasses();
        Assert.assertEquals((long)1L, (long)userDefinedJavaClassMeta.cookErrors.size());
    }

    @Test
    public void cookClassesCachingTest() throws Exception {
        String codeBlock1 = "public boolean processRow() {\n    return true;\n}\n\n";
        String codeBlock2 = "public boolean processRow() {\n    // Random comment\n    return true;\n}\n\n";
        UserDefinedJavaClassMeta userDefinedJavaClassMeta1 = new UserDefinedJavaClassMeta();
        UserDefinedJavaClassDef userDefinedJavaClassDef1 = new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.NORMAL_CLASS, "MainClass", codeBlock1);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)stepMeta.getName()).thenReturn((Object)"User Defined Java Class");
        userDefinedJavaClassMeta1.setParentStepMeta(stepMeta);
        UserDefinedJavaClassMeta userDefinedJavaClassMetaSpy = (UserDefinedJavaClassMeta)Mockito.spy((Object)userDefinedJavaClassMeta1);
        Class clazz1 = userDefinedJavaClassMetaSpy.cookClass(userDefinedJavaClassDef1, null);
        Class clazz2 = userDefinedJavaClassMetaSpy.cookClass(userDefinedJavaClassDef1, clazz1.getClassLoader());
        Assert.assertTrue((clazz1 == clazz2 ? 1 : 0) != 0);
        UserDefinedJavaClassMeta userDefinedJavaClassMeta2 = new UserDefinedJavaClassMeta();
        UserDefinedJavaClassDef userDefinedJavaClassDef2 = new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.NORMAL_CLASS, "AnotherClass", codeBlock2);
        StepMeta stepMeta2 = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)stepMeta2.getName()).thenReturn((Object)"Another UDJC");
        userDefinedJavaClassMeta2.setParentStepMeta(stepMeta2);
        UserDefinedJavaClassMeta userDefinedJavaClassMeta2Spy = (UserDefinedJavaClassMeta)Mockito.spy((Object)userDefinedJavaClassMeta2);
        Class clazz3 = userDefinedJavaClassMeta2Spy.cookClass(userDefinedJavaClassDef2, clazz2.getClassLoader());
        Assert.assertTrue((clazz3 != clazz1 ? 1 : 0) != 0);
    }

    @Test
    public void oderDefinitionTest() throws Exception {
        String codeBlock1 = "public boolean processRow() {\n    return true;\n}\n\n";
        String codeBlock2 = "public boolean extraClassA() {\n    // Random comment\n    return true;\n}\n\n";
        String codeBlock3 = "public boolean extraClassB() {\n    // Random comment\n    return true;\n}\n\n";
        UserDefinedJavaClassMeta userDefinedJavaClassMeta = new UserDefinedJavaClassMeta();
        UserDefinedJavaClassDef processClassDef = new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.TRANSFORM_CLASS, "Process", codeBlock1);
        UserDefinedJavaClassDef processClassDefA = new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.TRANSFORM_CLASS, "ProcessA", codeBlock1);
        UserDefinedJavaClassDef normalClassADef = new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.NORMAL_CLASS, "A", codeBlock1);
        UserDefinedJavaClassDef normalClassBDef = new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.NORMAL_CLASS, "B", codeBlock1);
        UserDefinedJavaClassDef normalClassCDef = new UserDefinedJavaClassDef(UserDefinedJavaClassDef.ClassType.NORMAL_CLASS, "C", codeBlock1);
        ArrayList<UserDefinedJavaClassDef> defs = new ArrayList<UserDefinedJavaClassDef>(5);
        defs.add(processClassDefA);
        defs.add(processClassDef);
        defs.add(normalClassCDef);
        defs.add(normalClassBDef);
        defs.add(normalClassADef);
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)stepMeta.getName()).thenReturn((Object)"User Defined Java Class");
        userDefinedJavaClassMeta.setParentStepMeta(stepMeta);
        List orderDefs = userDefinedJavaClassMeta.orderDefinitions(defs);
        Assert.assertTrue((boolean)((UserDefinedJavaClassDef)orderDefs.get(0)).getClassName().equals("A"));
        Assert.assertTrue((boolean)((UserDefinedJavaClassDef)orderDefs.get(1)).getClassName().equals("B"));
        Assert.assertTrue((boolean)((UserDefinedJavaClassDef)orderDefs.get(2)).getClassName().equals("C"));
        Assert.assertTrue((boolean)((UserDefinedJavaClassDef)orderDefs.get(3)).getClassName().equals("Process"));
        Assert.assertTrue((boolean)((UserDefinedJavaClassDef)orderDefs.get(4)).getClassName().equals("ProcessA"));
        defs.clear();
        defs.add(normalClassADef);
        defs.add(normalClassCDef);
        defs.add(processClassDefA);
        defs.add(normalClassBDef);
        defs.add(processClassDef);
        orderDefs = userDefinedJavaClassMeta.orderDefinitions(defs);
        Assert.assertTrue((boolean)((UserDefinedJavaClassDef)orderDefs.get(0)).getClassName().equals("A"));
        Assert.assertTrue((boolean)((UserDefinedJavaClassDef)orderDefs.get(1)).getClassName().equals("B"));
        Assert.assertTrue((boolean)((UserDefinedJavaClassDef)orderDefs.get(2)).getClassName().equals("C"));
        Assert.assertTrue((boolean)((UserDefinedJavaClassDef)orderDefs.get(3)).getClassName().equals("Process"));
        Assert.assertTrue((boolean)((UserDefinedJavaClassDef)orderDefs.get(4)).getClassName().equals("ProcessA"));
    }
}

