/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.userdefinedjavaclass;

import java.net.InetAddress;
import java.sql.Timestamp;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBigNumber;
import org.pentaho.di.core.row.value.ValueMetaBinary;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaInternetAddress;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaSerializable;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.row.value.ValueMetaTimestamp;
import org.pentaho.di.trans.steps.userdefinedjavaclass.FieldHelper;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={FieldHelper.class, FieldHelperTest.class})
public class FieldHelperTest {
    @Test
    public void getNativeDataTypeSimpleName_Unknown() throws Exception {
        KettleValueException e = new KettleValueException();
        ValueMetaInterface v = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        ((ValueMetaInterface)Mockito.doThrow((Throwable)e).when((Object)v)).getNativeDataTypeClass();
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        PowerMockito.whenNew(LogChannel.class).withAnyArguments().thenReturn((Object)log);
        Assert.assertEquals((Object)"Object", (Object)FieldHelper.getNativeDataTypeSimpleName((ValueMetaInterface)v));
        ((LogChannel)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)1))).logDebug("Unable to get name from data type");
    }

    @Test
    public void getNativeDataTypeSimpleName_String() {
        ValueMetaString v = new ValueMetaString();
        Assert.assertEquals((Object)"String", (Object)FieldHelper.getNativeDataTypeSimpleName((ValueMetaInterface)v));
    }

    @Test
    public void getNativeDataTypeSimpleName_InetAddress() {
        ValueMetaInternetAddress v = new ValueMetaInternetAddress();
        Assert.assertEquals((Object)"InetAddress", (Object)FieldHelper.getNativeDataTypeSimpleName((ValueMetaInterface)v));
    }

    @Test
    public void getNativeDataTypeSimpleName_Timestamp() {
        ValueMetaTimestamp v = new ValueMetaTimestamp();
        Assert.assertEquals((Object)"Timestamp", (Object)FieldHelper.getNativeDataTypeSimpleName((ValueMetaInterface)v));
    }

    @Test
    public void getNativeDataTypeSimpleName_Binary() {
        ValueMetaBinary v = new ValueMetaBinary();
        Assert.assertEquals((Object)"Binary", (Object)FieldHelper.getNativeDataTypeSimpleName((ValueMetaInterface)v));
    }

    @Test
    public void getGetSignature_String() {
        ValueMetaString v = new ValueMetaString("Name");
        String accessor = FieldHelper.getAccessor((boolean)true, (String)"Name");
        Assert.assertEquals((Object)"String Name = get(Fields.In, \"Name\").getString(r);", (Object)FieldHelper.getGetSignature((String)accessor, (ValueMetaInterface)v));
        Assert.assertNotNull((Object)Whitebox.getMethod(FieldHelper.class, (String)"getString", (Class[])new Class[]{Object[].class}));
    }

    @Test
    public void getGetSignature_InetAddress() {
        ValueMetaInternetAddress v = new ValueMetaInternetAddress("IP");
        String accessor = FieldHelper.getAccessor((boolean)true, (String)"IP");
        Assert.assertEquals((Object)"InetAddress IP = get(Fields.In, \"IP\").getInetAddress(r);", (Object)FieldHelper.getGetSignature((String)accessor, (ValueMetaInterface)v));
        Assert.assertNotNull((Object)Whitebox.getMethod(FieldHelper.class, (String)"getInetAddress", (Class[])new Class[]{Object[].class}));
    }

    @Test
    public void getGetSignature_Timestamp() {
        ValueMetaTimestamp v = new ValueMetaTimestamp("TS");
        String accessor = FieldHelper.getAccessor((boolean)true, (String)"TS");
        Assert.assertEquals((Object)"Timestamp TS = get(Fields.In, \"TS\").getTimestamp(r);", (Object)FieldHelper.getGetSignature((String)accessor, (ValueMetaInterface)v));
        Assert.assertNotNull((Object)Whitebox.getMethod(FieldHelper.class, (String)"getTimestamp", (Class[])new Class[]{Object[].class}));
    }

    @Test
    public void getGetSignature_Binary() {
        ValueMetaBinary v = new ValueMetaBinary("Data");
        String accessor = FieldHelper.getAccessor((boolean)true, (String)"Data");
        Assert.assertEquals((Object)"byte[] Data = get(Fields.In, \"Data\").getBinary(r);", (Object)FieldHelper.getGetSignature((String)accessor, (ValueMetaInterface)v));
        Assert.assertNotNull((Object)Whitebox.getMethod(FieldHelper.class, (String)"getBinary", (Class[])new Class[]{Object[].class}));
    }

    @Test
    public void getGetSignature_BigNumber() {
        ValueMetaBigNumber v = new ValueMetaBigNumber("Number");
        String accessor = FieldHelper.getAccessor((boolean)true, (String)"Number");
        Assert.assertEquals((Object)"BigDecimal Number = get(Fields.In, \"Number\").getBigDecimal(r);", (Object)FieldHelper.getGetSignature((String)accessor, (ValueMetaInterface)v));
        Assert.assertNotNull((Object)Whitebox.getMethod(FieldHelper.class, (String)"getBigDecimal", (Class[])new Class[]{Object[].class}));
    }

    @Test
    public void getGetSignature_Boolean() {
        ValueMetaBoolean v = new ValueMetaBoolean("Value");
        String accessor = FieldHelper.getAccessor((boolean)true, (String)"Value");
        Assert.assertEquals((Object)"Boolean Value = get(Fields.In, \"Value\").getBoolean(r);", (Object)FieldHelper.getGetSignature((String)accessor, (ValueMetaInterface)v));
        Assert.assertNotNull((Object)Whitebox.getMethod(FieldHelper.class, (String)"getBoolean", (Class[])new Class[]{Object[].class}));
    }

    @Test
    public void getGetSignature_Date() {
        ValueMetaDate v = new ValueMetaDate("DT");
        String accessor = FieldHelper.getAccessor((boolean)true, (String)"DT");
        Assert.assertEquals((Object)"Date DT = get(Fields.In, \"DT\").getDate(r);", (Object)FieldHelper.getGetSignature((String)accessor, (ValueMetaInterface)v));
        Assert.assertNotNull((Object)Whitebox.getMethod(FieldHelper.class, (String)"getDate", (Class[])new Class[]{Object[].class}));
    }

    @Test
    public void getGetSignature_Integer() {
        ValueMetaInteger v = new ValueMetaInteger("Value");
        String accessor = FieldHelper.getAccessor((boolean)true, (String)"Value");
        Assert.assertEquals((Object)"Long Value = get(Fields.In, \"Value\").getLong(r);", (Object)FieldHelper.getGetSignature((String)accessor, (ValueMetaInterface)v));
        Assert.assertNotNull((Object)Whitebox.getMethod(FieldHelper.class, (String)"getLong", (Class[])new Class[]{Object[].class}));
    }

    @Test
    public void getGetSignature_Number() {
        ValueMetaNumber v = new ValueMetaNumber("Value");
        String accessor = FieldHelper.getAccessor((boolean)true, (String)"Value");
        Assert.assertEquals((Object)"Double Value = get(Fields.In, \"Value\").getDouble(r);", (Object)FieldHelper.getGetSignature((String)accessor, (ValueMetaInterface)v));
        Assert.assertNotNull((Object)Whitebox.getMethod(FieldHelper.class, (String)"getDouble", (Class[])new Class[]{Object[].class}));
    }

    @Test
    public void getGetSignature_Serializable() throws Exception {
        LogChannel log = (LogChannel)Mockito.mock(LogChannel.class);
        PowerMockito.whenNew(LogChannel.class).withAnyArguments().thenReturn((Object)log);
        ValueMetaSerializable v = new ValueMetaSerializable("Data");
        String accessor = FieldHelper.getAccessor((boolean)true, (String)"Data");
        Assert.assertEquals((Object)"Object Data = get(Fields.In, \"Data\").getObject(r);", (Object)FieldHelper.getGetSignature((String)accessor, (ValueMetaInterface)v));
        Assert.assertNotNull((Object)Whitebox.getMethod(FieldHelper.class, (String)"getObject", (Class[])new Class[]{Object[].class}));
    }

    @Test
    public void getInetAddress_Test() throws Exception {
        ValueMetaInternetAddress v = new ValueMetaInternetAddress("IP");
        RowMetaInterface row = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ((RowMetaInterface)Mockito.doReturn((Object)v).when((Object)row)).searchValueMeta(Matchers.anyString());
        ((RowMetaInterface)Mockito.doReturn((Object)0).when((Object)row)).indexOfValue(Matchers.anyString());
        Assert.assertEquals((Object)InetAddress.getLoopbackAddress(), (Object)new FieldHelper(row, "IP").getInetAddress(new Object[]{InetAddress.getLoopbackAddress()}));
    }

    @Test
    public void getTimestamp_Test() throws Exception {
        ValueMetaTimestamp v = new ValueMetaTimestamp("TS");
        RowMetaInterface row = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ((RowMetaInterface)Mockito.doReturn((Object)v).when((Object)row)).searchValueMeta(Matchers.anyString());
        ((RowMetaInterface)Mockito.doReturn((Object)0).when((Object)row)).indexOfValue(Matchers.anyString());
        Assert.assertEquals((Object)Timestamp.valueOf("2018-07-23 12:40:55"), (Object)new FieldHelper(row, "TS").getTimestamp(new Object[]{Timestamp.valueOf("2018-07-23 12:40:55")}));
    }

    @Test
    public void getSerializable_Test() throws Exception {
        ValueMetaSerializable v = new ValueMetaSerializable("Data");
        RowMetaInterface row = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ((RowMetaInterface)Mockito.doReturn((Object)v).when((Object)row)).searchValueMeta(Matchers.anyString());
        ((RowMetaInterface)Mockito.doReturn((Object)0).when((Object)row)).indexOfValue(Matchers.anyString());
        Assert.assertEquals((Object)"...", (Object)new FieldHelper(row, "Data").getSerializable(new Object[]{"..."}));
    }

    @Test
    public void getBinary_Test() throws Exception {
        ValueMetaBinary v = new ValueMetaBinary("Data");
        RowMetaInterface row = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ((RowMetaInterface)Mockito.doReturn((Object)v).when((Object)row)).searchValueMeta(Matchers.anyString());
        ((RowMetaInterface)Mockito.doReturn((Object)0).when((Object)row)).indexOfValue(Matchers.anyString());
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2}, (byte[])new FieldHelper(row, "Data").getBinary(new Object[]{new byte[]{0, 1, 2}}));
    }

    @Test
    public void setValue_String() {
        ValueMetaString v = new ValueMetaString("Name");
        RowMetaInterface row = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ((RowMetaInterface)Mockito.doReturn((Object)v).when((Object)row)).searchValueMeta(Matchers.anyString());
        ((RowMetaInterface)Mockito.doReturn((Object)0).when((Object)row)).indexOfValue(Matchers.anyString());
        Object[] data = new Object[1];
        new FieldHelper(row, "Name").setValue(data, (Object)"Hitachi Vantara");
        Assert.assertEquals((Object)"Hitachi Vantara", (Object)data[0]);
    }

    @Test
    public void setValue_InetAddress() throws Exception {
        ValueMetaInternetAddress v = new ValueMetaInternetAddress("IP");
        RowMetaInterface row = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ((RowMetaInterface)Mockito.doReturn((Object)v).when((Object)row)).searchValueMeta(Matchers.anyString());
        ((RowMetaInterface)Mockito.doReturn((Object)0).when((Object)row)).indexOfValue(Matchers.anyString());
        Object[] data = new Object[1];
        new FieldHelper(row, "IP").setValue(data, (Object)InetAddress.getLoopbackAddress());
        Assert.assertEquals((Object)InetAddress.getLoopbackAddress(), (Object)data[0]);
    }

    @Test
    public void setValue_ValueMetaBinary() throws Exception {
        ValueMetaBinary v = new ValueMetaBinary("Data");
        RowMetaInterface row = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ((RowMetaInterface)Mockito.doReturn((Object)v).when((Object)row)).searchValueMeta(Matchers.anyString());
        ((RowMetaInterface)Mockito.doReturn((Object)0).when((Object)row)).indexOfValue(Matchers.anyString());
        Object[] data = new Object[1];
        new FieldHelper(row, "Data").setValue(data, new byte[]{0, 1, 2});
        Assert.assertArrayEquals((byte[])new byte[]{0, 1, 2}, (byte[])((byte[])data[0]));
    }
}

