/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.DatabaseMetaLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.update.Update;
import org.pentaho.di.trans.steps.update.UpdateData;
import org.pentaho.di.trans.steps.update.UpdateMeta;
import org.pentaho.metastore.api.IMetaStore;

public class UpdateMetaTest
implements InitializerInterface<StepMetaInterface> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private StepMeta stepMeta;
    private Update upd;
    private UpdateData ud;
    private UpdateMeta umi;
    LoadSaveTester loadSaveTester;
    Class<UpdateMeta> testMetaClass = UpdateMeta.class;
    private StepMockHelper<UpdateMeta, UpdateData> mockHelper;
    public static final String databaseXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><connection><name>lookup</name><server>127.0.0.1</server><type>H2</type><access>Native</access><database>mem:db</database><port></port><username>sa</username><password></password></connection>";

    @Before
    public void setUp() throws KettleException {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        TransMeta transMeta = new TransMeta();
        transMeta.setName("delete1");
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("max.sz", "10");
        transMeta.injectVariables(vars);
        this.umi = new UpdateMeta();
        this.ud = new UpdateData();
        PluginRegistry plugReg = PluginRegistry.getInstance();
        String deletePid = plugReg.getPluginId(StepPluginType.class, (Object)this.umi);
        this.stepMeta = new StepMeta(deletePid, "delete", (StepMetaInterface)this.umi);
        Trans trans = new Trans(transMeta);
        transMeta.addStep(this.stepMeta);
        this.mockHelper = new StepMockHelper<UpdateMeta, UpdateData>("Update", UpdateMeta.class, UpdateData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Mockito.any(), (LoggingObjectInterface)Mockito.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        this.upd = new Update(this.stepMeta, (StepDataInterface)this.ud, 1, transMeta, trans);
        this.upd.copyVariablesFrom((VariableSpace)transMeta);
        List<String> attributes = Arrays.asList("schemaName", "tableName", "commitSize", "errorIgnored", "ignoreFlagField", "skipLookup", "useBatchUpdate", "keyStream", "keyLookup", "keyCondition", "keyStream2", "updateLookup", "updateStream", "databaseMeta");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("schemaName", "getSchemaName");
                this.put("tableName", "getTableName");
                this.put("commitSize", "getCommitSizeVar");
                this.put("errorIgnored", "isErrorIgnored");
                this.put("ignoreFlagField", "getIgnoreFlagField");
                this.put("skipLookup", "isSkipLookup");
                this.put("useBatchUpdate", "useBatchUpdate");
                this.put("keyStream", "getKeyStream");
                this.put("keyLookup", "getKeyLookup");
                this.put("keyCondition", "getKeyCondition");
                this.put("keyStream2", "getKeyStream2");
                this.put("updateLookup", "getUpdateLookup");
                this.put("updateStream", "getUpdateStream");
                this.put("databaseMeta", "getDatabaseMeta");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("schemaName", "setSchemaName");
                this.put("tableName", "setTableName");
                this.put("commitSize", "setCommitSize");
                this.put("errorIgnored", "setErrorIgnored");
                this.put("ignoreFlagField", "setIgnoreFlagField");
                this.put("skipLookup", "setSkipLookup");
                this.put("useBatchUpdate", "setUseBatchUpdate");
                this.put("keyStream", "setKeyStream");
                this.put("keyLookup", "setKeyLookup");
                this.put("keyCondition", "setKeyCondition");
                this.put("keyStream2", "setKeyStream2");
                this.put("updateLookup", "setUpdateLookup");
                this.put("updateStream", "setUpdateStream");
                this.put("databaseMeta", "setDatabaseMeta");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("keyStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyLookup", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyCondition", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keyStream2", stringArrayLoadSaveValidator);
        attrValidatorMap.put("updateLookup", stringArrayLoadSaveValidator);
        attrValidatorMap.put("updateStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("databaseMeta", new DatabaseMetaLoadSaveValidator());
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @After
    public void cleanUp() {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testCommitCountFixed() {
        this.umi.setCommitSize("100");
        Assert.assertTrue((this.umi.getCommitSize((VariableSpace)this.upd) == 100 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitCountVar() {
        this.umi.setCommitSize("${max.sz}");
        Assert.assertTrue((this.umi.getCommitSize((VariableSpace)this.upd) == 10 ? 1 : 0) != 0);
    }

    @Test
    public void testCommitCountMissedVar() {
        this.umi.setCommitSize("missed-var");
        try {
            this.umi.getCommitSize((VariableSpace)this.upd);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testUseDefaultSchemaName() throws Exception {
        String schemaName = "";
        String tableName = "tableName";
        String schemaTable = "default.tableName";
        DatabaseMeta databaseMeta = (DatabaseMeta)Mockito.spy((Object)new DatabaseMeta(databaseXML));
        ((DatabaseMeta)Mockito.doReturn((Object)"someValue").when((Object)databaseMeta)).getFieldDefinition((ValueMetaInterface)Matchers.any(ValueMetaInterface.class), Matchers.anyString(), Matchers.anyString(), Matchers.anyBoolean());
        ((DatabaseMeta)Mockito.doReturn((Object)schemaTable).when((Object)databaseMeta)).getQuotedSchemaTableCombination(schemaName, tableName);
        ValueMetaInterface valueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        Mockito.when((Object)valueMeta.clone()).thenReturn(Mockito.mock(ValueMetaInterface.class));
        RowMetaInterface rowMetaInterface = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)rowMetaInterface.size()).thenReturn((Object)1);
        Mockito.when((Object)rowMetaInterface.searchValueMeta(Matchers.anyString())).thenReturn((Object)valueMeta);
        UpdateMeta updateMeta = new UpdateMeta();
        updateMeta.setDatabaseMeta(databaseMeta);
        updateMeta.setTableName(tableName);
        updateMeta.setSchemaName(schemaName);
        updateMeta.setKeyLookup(new String[]{"KeyLookup1", "KeyLookup2"});
        updateMeta.setKeyStream(new String[]{"KeyStream1", "KeyStream2"});
        updateMeta.setUpdateLookup(new String[]{"updateLookup1", "updateLookup2"});
        updateMeta.setUpdateStream(new String[]{"UpdateStream1", "UpdateStream2"});
        SQLStatement sqlStatement = updateMeta.getSQLStatements(new TransMeta(), (StepMeta)Mockito.mock(StepMeta.class), rowMetaInterface, (Repository)Mockito.mock(Repository.class), (IMetaStore)Mockito.mock(IMetaStore.class));
        String sql = sqlStatement.getSQL();
        Assert.assertTrue((StringUtils.countMatches((String)sql, (String)schemaTable) == 2 ? 1 : 0) != 0);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof UpdateMeta) {
            ((UpdateMeta)someMeta).allocate(5, 5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testPDI16559() throws Exception {
        UpdateMeta update = new UpdateMeta();
        update.setKeyStream(new String[]{"field1", "field2", "field3", "field4", "field5"});
        update.setKeyLookup(new String[]{"lkup1", "lkup2"});
        update.setKeyCondition(new String[]{"cond1", "cond2", "cond3"});
        update.setKeyStream2(new String[]{"str21", "str22", "str23", "str24"});
        update.setUpdateLookup(new String[]{"updlkup1", "updlkup2", "updlkup3", "updlkup4"});
        update.setUpdateStream(new String[]{"updlkup1", "updlkup2"});
        try {
            String badXml = update.getXML();
            Assert.fail((String)"Before calling afterInjectionSynchronization, should have thrown an ArrayIndexOOB");
        }
        catch (Exception badXml) {
            // empty catch block
        }
        update.afterInjectionSynchronization();
        String ktrXml = update.getXML();
        int targetSz = update.getKeyStream().length;
        Assert.assertEquals((long)targetSz, (long)update.getKeyLookup().length);
        Assert.assertEquals((long)targetSz, (long)update.getKeyCondition().length);
        Assert.assertEquals((long)targetSz, (long)update.getKeyStream2().length);
        targetSz = update.getUpdateLookup().length;
        Assert.assertEquals((long)targetSz, (long)update.getUpdateStream().length);
    }

    @Test
    public void testReadRepAllocatesSizeProperly() throws Exception {
        Repository rep = (Repository)Mockito.mock(Repository.class);
        ObjectId objectId = new ObjectId(){

            public String getId() {
                return "testId";
            }
        };
        Mockito.when((Object)rep.countNrStepAttributes(objectId, "key_name")).thenReturn((Object)2);
        Mockito.when((Object)rep.countNrStepAttributes(objectId, "key_field")).thenReturn((Object)2);
        Mockito.when((Object)rep.countNrStepAttributes(objectId, "key_condition")).thenReturn((Object)0);
        Mockito.when((Object)rep.countNrStepAttributes(objectId, "key_name2")).thenReturn((Object)0);
        Mockito.when((Object)rep.countNrStepAttributes(objectId, "value_name")).thenReturn((Object)3);
        Mockito.when((Object)rep.countNrStepAttributes(objectId, "value_rename")).thenReturn((Object)2);
        UpdateMeta updateMeta = (UpdateMeta)Mockito.spy(UpdateMeta.class);
        updateMeta.readRep(rep, null, objectId, null);
        ((Repository)Mockito.verify((Object)rep)).countNrStepAttributes(objectId, "key_name");
        ((Repository)Mockito.verify((Object)rep)).countNrStepAttributes(objectId, "key_field");
        ((Repository)Mockito.verify((Object)rep)).countNrStepAttributes(objectId, "key_condition");
        ((Repository)Mockito.verify((Object)rep)).countNrStepAttributes(objectId, "key_name2");
        ((Repository)Mockito.verify((Object)rep)).countNrStepAttributes(objectId, "value_name");
        ((Repository)Mockito.verify((Object)rep)).countNrStepAttributes(objectId, "value_rename");
        ((UpdateMeta)Mockito.verify((Object)updateMeta)).allocate(2, 3);
    }
}

