/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.univariatestats;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.trans.steps.univariatestats.FieldIndex;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMetaFunction;

public class FieldIndexTest {
    @Test
    public void testCalculateDerived0Count() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_sum = 250.0;
        fieldIndex.m_count = 0.0;
        fieldIndex.m_sumSq = 35000.3;
        fieldIndex.calculateDerived();
        Assert.assertEquals((double)Double.NaN, (double)fieldIndex.m_mean, (double)0.0);
        Assert.assertEquals((double)Double.NaN, (double)fieldIndex.m_stdDev, (double)0.0);
    }

    @Test
    public void testCalculateDerived1Count() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_sum = 250.0;
        fieldIndex.m_count = 1.0;
        fieldIndex.m_sumSq = 35000.3;
        fieldIndex.calculateDerived();
        Assert.assertEquals((double)(fieldIndex.m_sum / fieldIndex.m_count), (double)fieldIndex.m_mean, (double)0.0);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)fieldIndex.m_stdDev, (double)0.0);
    }

    @Test
    public void testCalculateDerived3CountPositiveStdDev() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_sum = 250.0;
        fieldIndex.m_count = 3.0;
        fieldIndex.m_sumSq = 35000.3;
        fieldIndex.calculateDerived();
        Assert.assertEquals((double)(fieldIndex.m_sum / fieldIndex.m_count), (double)fieldIndex.m_mean, (double)0.0);
        Assert.assertEquals((double)Math.sqrt((fieldIndex.m_sumSq - fieldIndex.m_sum * fieldIndex.m_sum / fieldIndex.m_count) / (fieldIndex.m_count - 1.0)), (double)fieldIndex.m_stdDev, (double)0.0);
    }

    @Test
    public void testCalculateDerived3CountNegativeStdDev() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_sum = 250.0;
        fieldIndex.m_count = 3.0;
        fieldIndex.m_sumSq = 350.3;
        fieldIndex.calculateDerived();
        Assert.assertEquals((double)(fieldIndex.m_sum / fieldIndex.m_count), (double)fieldIndex.m_mean, (double)0.0);
        Assert.assertEquals((double)0.0, (double)fieldIndex.m_stdDev, (double)0.0);
    }

    @Test
    public void testGenerateOutputValuesNoCacheNoCalc() {
        FieldIndex fieldIndex = new FieldIndex();
        Object[] outputValues = fieldIndex.generateOutputValues(new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, -1.0, false), null);
        Assert.assertEquals((long)0L, (long)outputValues.length);
    }

    @Test
    public void testGenerateOutputValuesNoCacheAllCalc() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_count = 1.0;
        fieldIndex.m_mean = 2.0;
        fieldIndex.m_stdDev = 3.0;
        fieldIndex.m_min = 4.0;
        fieldIndex.m_max = 5.0;
        fieldIndex.m_median = 6.0;
        fieldIndex.m_arbitraryPercentile = 7.0;
        Object[] outputValues = fieldIndex.generateOutputValues(new UnivariateStatsMetaFunction(null, true, true, true, true, true, true, 0.55, false), null);
        int index = 0;
        Assert.assertEquals((double)((Double)outputValues[index++]), (double)fieldIndex.m_count, (double)0.0);
        Assert.assertEquals((double)((Double)outputValues[index++]), (double)fieldIndex.m_mean, (double)0.0);
        Assert.assertEquals((double)((Double)outputValues[index++]), (double)fieldIndex.m_stdDev, (double)0.0);
        Assert.assertEquals((double)((Double)outputValues[index++]), (double)fieldIndex.m_min, (double)0.0);
        Assert.assertEquals((double)((Double)outputValues[index++]), (double)fieldIndex.m_max, (double)0.0);
        Assert.assertEquals((double)((Double)outputValues[index++]), (double)fieldIndex.m_median, (double)0.0);
        Assert.assertEquals((double)((Double)outputValues[index++]), (double)fieldIndex.m_arbitraryPercentile, (double)0.0);
    }

    @Test
    public void testGenerateOutputValuesCacheInterpolateSpecialCasesMin() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_count = 10.0;
        fieldIndex.m_min = -350.0;
        fieldIndex.m_max = 350.0;
        ArrayList<Integer> cache = new ArrayList<Integer>();
        cache.add(3);
        cache.add(4);
        cache.add(5);
        Object[] outputValues = fieldIndex.generateOutputValues(new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, 0.0, true), cache);
        Assert.assertEquals((long)1L, (long)outputValues.length);
        Assert.assertEquals((Object)fieldIndex.m_min, (Object)outputValues[0]);
    }

    @Test
    public void testGenerateOutputValuesCacheInterpolateSpecialCasesMax() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_count = 10.0;
        fieldIndex.m_min = -350.0;
        fieldIndex.m_max = 350.0;
        ArrayList<Integer> cache = new ArrayList<Integer>();
        cache.add(3);
        cache.add(4);
        cache.add(5);
        Object[] outputValues = fieldIndex.generateOutputValues(new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, 1.0, true), cache);
        Assert.assertEquals((long)1L, (long)outputValues.length);
        Assert.assertEquals((Object)fieldIndex.m_max, (Object)outputValues[0]);
    }

    @Test
    public void testGenerateOutputValuesCacheInterpolate() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_count = 5.0;
        fieldIndex.m_min = -350.0;
        fieldIndex.m_max = 350.0;
        ArrayList<Integer> cache = new ArrayList<Integer>();
        cache.add(3);
        cache.add(4);
        cache.add(5);
        cache.add(6);
        cache.add(7);
        Object[] outputValues = fieldIndex.generateOutputValues(new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, 0.55, true), cache);
        Assert.assertEquals((long)1L, (long)outputValues.length);
        Assert.assertEquals((double)5.3, (double)((Double)outputValues[0]), (double)5.0E-4);
    }

    @Test
    public void testGenerateOutputValuesCacheSimpleSpecialCasesMin() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_count = 10.0;
        fieldIndex.m_min = -350.0;
        fieldIndex.m_max = 350.0;
        ArrayList<Integer> cache = new ArrayList<Integer>();
        cache.add(3);
        cache.add(4);
        cache.add(5);
        Object[] outputValues = fieldIndex.generateOutputValues(new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, 0.0, false), cache);
        Assert.assertEquals((long)1L, (long)outputValues.length);
        Assert.assertEquals((Object)fieldIndex.m_min, (Object)outputValues[0]);
    }

    @Test
    public void testGenerateOutputValuesCacheSimpleSpecialCasesMax() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_count = 10.0;
        fieldIndex.m_min = -350.0;
        fieldIndex.m_max = 350.0;
        ArrayList<Integer> cache = new ArrayList<Integer>();
        cache.add(3);
        cache.add(4);
        cache.add(5);
        Object[] outputValues = fieldIndex.generateOutputValues(new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, 1.0, false), cache);
        Assert.assertEquals((long)1L, (long)outputValues.length);
        Assert.assertEquals((Object)fieldIndex.m_max, (Object)outputValues[0]);
    }

    @Test
    public void testGenerateOutputValuesCacheSimpleOdd() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_count = 5.0;
        fieldIndex.m_min = -350.0;
        fieldIndex.m_max = 350.0;
        ArrayList<Integer> cache = new ArrayList<Integer>();
        cache.add(3);
        cache.add(4);
        cache.add(5);
        cache.add(6);
        cache.add(7);
        Object[] outputValues = fieldIndex.generateOutputValues(new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, 0.5, false), cache);
        Assert.assertEquals((long)1L, (long)outputValues.length);
        Assert.assertEquals((double)5.0, (double)((Double)outputValues[0]), (double)5.0E-4);
    }

    @Test
    public void testGenerateOutputValuesCacheSimpleEven() {
        FieldIndex fieldIndex = new FieldIndex();
        fieldIndex.m_count = 6.0;
        fieldIndex.m_min = -350.0;
        fieldIndex.m_max = 350.0;
        ArrayList<Integer> cache = new ArrayList<Integer>();
        cache.add(3);
        cache.add(4);
        cache.add(5);
        cache.add(6);
        cache.add(7);
        cache.add(8);
        Object[] outputValues = fieldIndex.generateOutputValues(new UnivariateStatsMetaFunction(null, false, false, false, false, false, false, 0.5, false), cache);
        Assert.assertEquals((long)1L, (long)outputValues.length);
        Assert.assertEquals((double)5.5, (double)((Double)outputValues[0]), (double)5.0E-4);
    }
}

