/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.transexecutor;

import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.StepMockUtil;
import org.pentaho.di.trans.steps.transexecutor.TransExecutor;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorData;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;

public class TransExecutorUnitTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private TransExecutor executor;
    private TransExecutorMeta meta;
    private TransExecutorData data;
    private Trans internalTrans;
    private Result internalResult;

    @BeforeClass
    public static void initKettle() throws Exception {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() throws Exception {
        this.executor = StepMockUtil.getStep(TransExecutor.class, TransExecutorMeta.class, "TransExecutorUnitTest");
        this.executor = (TransExecutor)Mockito.spy((Object)this.executor);
        TransMeta internalTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransExecutor)Mockito.doReturn((Object)internalTransMeta).when((Object)this.executor)).loadExecutorTransMeta();
        this.internalTrans = (Trans)Mockito.spy((Object)new Trans());
        this.internalTrans.setLog((LogChannelInterface)Mockito.mock(LogChannelInterface.class));
        ((Trans)Mockito.doNothing().when((Object)this.internalTrans)).prepareExecution((String[])Mockito.any(String[].class));
        ((Trans)Mockito.doNothing().when((Object)this.internalTrans)).startThreads();
        ((Trans)Mockito.doNothing().when((Object)this.internalTrans)).waitUntilFinished();
        ((TransExecutor)Mockito.doNothing().when((Object)this.executor)).discardLogLines((TransExecutorData)Mockito.any(TransExecutorData.class));
        ((TransExecutor)Mockito.doReturn((Object)this.internalTrans).when((Object)this.executor)).createInternalTrans();
        this.internalResult = new Result();
        ((Trans)Mockito.doReturn((Object)this.internalResult).when((Object)this.internalTrans)).getResult();
        this.meta = new TransExecutorMeta();
        this.data = new TransExecutorData();
    }

    @After
    public void cleanUp() {
        this.executor = null;
        this.meta = null;
        this.data = null;
        this.internalTrans = null;
        this.internalResult = null;
    }

    @Test
    public void testCreateInternalTransSetsRepository() throws KettleException {
        Trans transParentMock = (Trans)Mockito.mock(Trans.class);
        Repository repositoryMock = (Repository)Mockito.mock(Repository.class);
        TransExecutorData transExecutorDataMock = (TransExecutorData)Mockito.mock(TransExecutorData.class);
        TransMeta transMetaMock = (TransMeta)Mockito.mock(TransMeta.class);
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Mockito.when((Object)transParentMock.getRepository()).thenReturn((Object)repositoryMock);
        Mockito.when((Object)transParentMock.getLogLevel()).thenReturn((Object)LogLevel.DEBUG);
        ((Trans)Mockito.doNothing().when((Object)transParentMock)).initializeVariablesFrom((VariableSpace)Mockito.any(VariableSpace.class));
        Mockito.when((Object)this.executor.getLogLevel()).thenReturn((Object)LogLevel.DEBUG);
        Mockito.when((Object)this.executor.createInternalTrans()).thenCallRealMethod();
        Mockito.when((Object)this.executor.getTrans()).thenReturn((Object)transParentMock);
        Mockito.when((Object)this.executor.getData()).thenReturn((Object)transExecutorDataMock);
        Mockito.when((Object)transMetaMock.listVariables()).thenReturn((Object)new String[0]);
        Mockito.when((Object)transMetaMock.listParameters()).thenReturn((Object)new String[0]);
        Mockito.when((Object)transExecutorDataMock.getExecutorTransMeta()).thenReturn((Object)transMetaMock);
        Trans internalTrans = this.executor.createInternalTrans();
        Assert.assertNotNull((Object)internalTrans);
        Trans parentTrans = internalTrans.getParentTrans();
        Assert.assertEquals((Object)parentTrans, (Object)transParentMock);
        Assert.assertEquals((Object)parentTrans.getRepository(), (Object)repositoryMock);
        Assert.assertEquals((Object)internalTrans.getRepository(), (Object)repositoryMock);
    }

    @Test
    public void collectsResultsFromInternalTransformation() throws Exception {
        this.prepareOneRowForExecutor();
        RowMetaAndData expectedResult = new RowMetaAndData((RowMetaInterface)new RowMeta(), new Object[]{"fake result"});
        this.internalResult.getRows().add(expectedResult);
        QueueRowSet rowSet = new QueueRowSet();
        StepMeta stepMeta = this.mockStepAndMapItToRowSet("stepMetaMock", (RowSet)rowSet);
        this.meta.setOutputRowsSourceStepMeta(stepMeta);
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.setInputRowMeta((RowMetaInterface)new RowMeta());
        Assert.assertTrue((String)"Passing one line at first time", (boolean)this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        Assert.assertFalse((String)"Executing the internal trans during the second round", (boolean)this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        Object[] resultsRow = rowSet.getRowImmediate();
        Assert.assertNotNull((Object)resultsRow);
        Assert.assertArrayEquals((Object[])expectedResult.getData(), (Object[])resultsRow);
        Assert.assertNull((String)"Only one row is expected", (Object)rowSet.getRowImmediate());
    }

    @Test
    public void collectsExecutionResults() throws Exception {
        this.prepareOneRowForExecutor();
        StepMeta parentStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)parentStepMeta.getName()).thenReturn((Object)"parentStepMeta");
        this.meta.setParentStepMeta(parentStepMeta);
        this.internalResult.setResult(true);
        this.meta.setExecutionResultField("executionResultField");
        this.internalResult.setNrErrors(1L);
        this.meta.setExecutionNrErrorsField("executionNrErrorsField");
        this.internalResult.setNrLinesRead(2L);
        this.meta.setExecutionLinesReadField("executionLinesReadField");
        this.internalResult.setNrLinesWritten(3L);
        this.meta.setExecutionLinesWrittenField("executionLinesWrittenField");
        this.internalResult.setNrLinesInput(4L);
        this.meta.setExecutionLinesInputField("executionLinesInputField");
        this.internalResult.setNrLinesOutput(5L);
        this.meta.setExecutionLinesOutputField("executionLinesOutputField");
        this.internalResult.setNrLinesRejected(6L);
        this.meta.setExecutionLinesRejectedField("executionLinesRejectedField");
        this.internalResult.setNrLinesUpdated(7L);
        this.meta.setExecutionLinesUpdatedField("executionLinesUpdatedField");
        this.internalResult.setNrLinesDeleted(8L);
        this.meta.setExecutionLinesDeletedField("executionLinesDeletedField");
        this.internalResult.setNrFilesRetrieved(9L);
        this.meta.setExecutionFilesRetrievedField("executionFilesRetrievedField");
        this.internalResult.setExitStatus(10);
        this.meta.setExecutionExitStatusField("executionExitStatusField");
        QueueRowSet rowSet = new QueueRowSet();
        StepMeta stepMeta = this.mockStepAndMapItToRowSet("stepMetaMock", (RowSet)rowSet);
        this.meta.setExecutionResultTargetStepMeta(stepMeta);
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.setInputRowMeta((RowMetaInterface)new RowMeta());
        Assert.assertTrue((String)"Passing one line at first time", (boolean)this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        Assert.assertFalse((String)"Executing the internal trans during the second round", (boolean)this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        Object[] resultsRow = rowSet.getRowImmediate();
        Assert.assertNotNull((Object)resultsRow);
        Assert.assertNull((String)"Only one row is expected", (Object)rowSet.getRowImmediate());
        Assert.assertEquals((Object)this.internalResult.getResult(), (Object)resultsRow[0]);
        Assert.assertEquals((Object)this.internalResult.getNrErrors(), (Object)resultsRow[1]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesRead(), (Object)resultsRow[2]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesWritten(), (Object)resultsRow[3]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesInput(), (Object)resultsRow[4]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesOutput(), (Object)resultsRow[5]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesRejected(), (Object)resultsRow[6]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesUpdated(), (Object)resultsRow[7]);
        Assert.assertEquals((Object)this.internalResult.getNrLinesDeleted(), (Object)resultsRow[8]);
        Assert.assertEquals((Object)this.internalResult.getNrFilesRetrieved(), (Object)resultsRow[9]);
        Assert.assertEquals((long)this.internalResult.getExitStatus(), (long)((Number)resultsRow[10]).intValue());
    }

    @Test
    public void shouldAccumulateRowsWhenGroupFieldIsSpecified() throws KettleException {
        this.prepareMultipleRowsForExecutor();
        this.meta.setGroupField("groupField");
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("groupField"));
        this.executor.setInputRowMeta((RowMetaInterface)rowMeta);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)4L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)3L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)0L, (long)this.data.groupBuffer.size());
    }

    @Test
    public void shouldAccumulateRowsByCount() throws KettleException {
        this.prepareMultipleRowsForExecutor();
        this.meta.setGroupSize("5");
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)4L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)0L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)1L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)2L, (long)this.data.groupBuffer.size());
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Assert.assertEquals((long)0L, (long)this.data.groupBuffer.size());
    }

    @Test
    public void testCollectTransResultsDisabledHop() throws KettleException {
        StepMeta outputRowsSourceStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        this.meta.setOutputRowsSourceStepMeta(outputRowsSourceStepMeta);
        Result result = (Result)Mockito.mock(Result.class);
        RowMetaAndData rowMetaAndData = (RowMetaAndData)Mockito.mock(RowMetaAndData.class);
        Mockito.when((Object)result.getRows()).thenReturn(Arrays.asList(rowMetaAndData));
        ((TransExecutor)Mockito.doNothing().when((Object)this.executor)).putRowTo((RowMetaInterface)Mockito.any(), (Object[])Mockito.any(), (RowSet)Mockito.any());
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.collectTransResults(result);
        ((TransExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.never())).putRowTo((RowMetaInterface)Mockito.any(), (Object[])Mockito.any(), (RowSet)Mockito.any());
    }

    @Test
    public void testCollectExecutionResultsDisabledHop() throws KettleException {
        StepMeta executionResultTargetStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        this.meta.setExecutionResultTargetStepMeta(executionResultTargetStepMeta);
        RowMetaInterface executionResultsOutputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        this.data.setExecutionResultsOutputRowMeta(executionResultsOutputRowMeta);
        ((TransExecutor)Mockito.doNothing().when((Object)this.executor)).putRowTo((RowMetaInterface)Mockito.any(), (Object[])Mockito.any(), (RowSet)Mockito.any());
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        Result result = (Result)Mockito.mock(Result.class);
        this.executor.collectExecutionResults(result);
        ((TransExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.never())).putRowTo((RowMetaInterface)Mockito.any(), (Object[])Mockito.any(), (RowSet)Mockito.any());
    }

    @Test
    public void testCollectExecutionResultFilesDisabledHop() throws KettleException {
        Result result = (Result)Mockito.mock(Result.class);
        ResultFile resultFile = (ResultFile)Mockito.mock(ResultFile.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)result.getResultFilesList()).thenReturn(Arrays.asList(resultFile));
        StepMeta resultFilesTargetStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        this.meta.setResultFilesTargetStepMeta(resultFilesTargetStepMeta);
        RowMetaInterface resultFilesOutputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        this.data.setResultFilesOutputRowMeta(resultFilesOutputRowMeta);
        ((TransExecutor)Mockito.doNothing().when((Object)this.executor)).putRowTo((RowMetaInterface)Mockito.any(), (Object[])Mockito.any(), (RowSet)Mockito.any());
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.collectExecutionResultFiles(result);
        ((TransExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.never())).putRowTo((RowMetaInterface)Mockito.any(), (Object[])Mockito.any(), (RowSet)Mockito.any());
    }

    private void prepareMultipleRowsForExecutor() throws KettleException {
        ((TransExecutor)Mockito.doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value1"}).doReturn((Object)new Object[]{"value12"}).doReturn((Object)new Object[]{"value12"}).doReturn((Object)new Object[]{"value12"}).doReturn(null).when((Object)this.executor)).getRow();
    }

    private void prepareOneRowForExecutor() throws Exception {
        ((TransExecutor)Mockito.doReturn((Object)new Object[]{"row"}).doReturn(null).when((Object)this.executor)).getRow();
    }

    private StepMeta mockStepAndMapItToRowSet(String stepName, RowSet rowSet) throws KettleStepException {
        StepMeta stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)stepMeta.getName()).thenReturn((Object)stepName);
        ((TransExecutor)Mockito.doReturn((Object)rowSet).when((Object)this.executor)).findOutputRowSet(stepName);
        return stepMeta;
    }

    @Test
    public void testExecuteTrans() throws KettleException {
        String childParam = "childParam";
        String childValue = "childValue";
        String paramOverwrite = "paramOverwrite";
        String parentValue = "parentValue";
        this.meta.getParameters().setVariable(new String[]{childParam, paramOverwrite});
        this.meta.getParameters().setInput(new String[]{null, null});
        this.meta.getParameters().setField(new String[]{null, null});
        Trans parent = new Trans();
        Mockito.when((Object)this.executor.getTrans()).thenReturn((Object)parent);
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.setVariable(paramOverwrite, parentValue);
        this.executor.setVariable(childParam, childValue);
        Mockito.when((Object)this.executor.getLogLevel()).thenReturn((Object)LogLevel.NOTHING);
        parent.setLog((LogChannelInterface)new LogChannel((Object)this));
        ((TransExecutor)Mockito.doCallRealMethod().when((Object)this.executor)).createInternalTrans();
        Mockito.when((Object)this.executor.getData().getExecutorTransMeta().listVariables()).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.executor.getData().getExecutorTransMeta().listParameters()).thenReturn((Object)new String[0]);
        Trans internalTrans = this.executor.createInternalTrans();
        this.executor.getData().setExecutorTrans(internalTrans);
        this.executor.passParametersToTrans(Arrays.asList(this.meta.getParameters().getInput()));
        Assert.assertEquals((Object)parentValue, (Object)internalTrans.getVariable(paramOverwrite));
        Assert.assertEquals((Object)childValue, (Object)internalTrans.getVariable(childParam));
    }

    @Test
    public void testExecuteTransWithFieldsAndNoInput() throws KettleException {
        String childParam = "childParam";
        String childValue = "childValue";
        String fieldValue1 = "fieldValue1";
        String fieldValue2 = "fieldValue2";
        String paramOverwrite = "paramOverwrite";
        String parentValue = "parentValue";
        this.meta.getParameters().setVariable(new String[]{childParam, paramOverwrite});
        this.meta.getParameters().setInput(new String[]{null, null});
        this.meta.getParameters().setField(new String[]{childParam, paramOverwrite});
        Trans parent = new Trans();
        Mockito.when((Object)this.executor.getTrans()).thenReturn((Object)parent);
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.setVariable(paramOverwrite, parentValue);
        this.executor.setVariable(childParam, childValue);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)this.executor.getLogLevel()).thenReturn((Object)LogLevel.NOTHING);
        parent.setLog((LogChannelInterface)new LogChannel((Object)this));
        ((TransExecutor)Mockito.doCallRealMethod().when((Object)this.executor)).createInternalTrans();
        Mockito.when((Object)this.executor.getData().getExecutorTransMeta().listVariables()).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.executor.getData().getExecutorTransMeta().listParameters()).thenReturn((Object)new String[0]);
        this.executor.getData().setInputRowMeta(inputRowMeta);
        Mockito.when((Object)this.executor.getData().getInputRowMeta().getFieldNames()).thenReturn((Object)new String[]{"childParam", "paramOverwrite"});
        Trans internalTrans = this.executor.createInternalTrans();
        this.executor.getData().setExecutorTrans(internalTrans);
        this.executor.passParametersToTrans(Arrays.asList(fieldValue1, fieldValue2));
        Assert.assertEquals((Object)fieldValue2, (Object)internalTrans.getVariable(paramOverwrite));
        Assert.assertEquals((Object)fieldValue1, (Object)internalTrans.getVariable(childParam));
    }

    @Test
    public void testExecuteTransWithInputsAndNoFields() throws KettleException {
        String childParam = "childParam";
        String childValue = "childValue";
        String inputValue1 = "inputValue1";
        String inputValue2 = "inputValue2";
        String paramOverwrite = "paramOverwrite";
        String parentValue = "parentValue";
        this.meta.getParameters().setVariable(new String[]{childParam, paramOverwrite});
        this.meta.getParameters().setInput(new String[]{inputValue1, inputValue2});
        this.meta.getParameters().setField(new String[]{null, null});
        Trans parent = new Trans();
        Mockito.when((Object)this.executor.getTrans()).thenReturn((Object)parent);
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.setVariable(paramOverwrite, parentValue);
        this.executor.setVariable(childParam, childValue);
        Mockito.when((Object)this.executor.getLogLevel()).thenReturn((Object)LogLevel.NOTHING);
        parent.setLog((LogChannelInterface)new LogChannel((Object)this));
        ((TransExecutor)Mockito.doCallRealMethod().when((Object)this.executor)).createInternalTrans();
        Mockito.when((Object)this.executor.getData().getExecutorTransMeta().listVariables()).thenReturn((Object)new String[0]);
        Mockito.when((Object)this.executor.getData().getExecutorTransMeta().listParameters()).thenReturn((Object)new String[0]);
        Trans internalTrans = this.executor.createInternalTrans();
        this.executor.getData().setExecutorTrans(internalTrans);
        this.executor.passParametersToTrans(Arrays.asList(this.meta.getParameters().getField()));
        Assert.assertEquals((Object)inputValue2, (Object)internalTrans.getVariable(paramOverwrite));
        Assert.assertEquals((Object)inputValue1, (Object)internalTrans.getVariable(childParam));
    }

    @Test
    public void testSafeStop() throws Exception {
        this.prepareOneRowForExecutor();
        this.meta.setGroupSize("1");
        this.data.groupSize = 1;
        this.internalResult.setSafeStop(true);
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.setInputRowMeta((RowMetaInterface)new RowMeta());
        Assert.assertTrue((boolean)this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        ((Trans)Mockito.verify((Object)this.executor.getTrans())).safeStop();
        ((Trans)Mockito.verify((Object)this.executor.getTrans(), (VerificationMode)Mockito.never())).stopAll();
    }

    @Test
    public void testAbortWithError() throws Exception {
        this.prepareOneRowForExecutor();
        this.meta.setGroupSize("1");
        this.data.groupSize = 1;
        this.internalResult.setSafeStop(false);
        this.internalResult.setNrErrors(1L);
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.setInputRowMeta((RowMetaInterface)new RowMeta());
        Assert.assertTrue((boolean)this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data));
        ((Trans)Mockito.verify((Object)this.executor.getTrans(), (VerificationMode)Mockito.never())).safeStop();
        ((Trans)Mockito.verify((Object)this.executor.getTrans(), (VerificationMode)Mockito.never())).stopAll();
    }

    private void prepareNoRowForExecutor() throws Exception {
        ((TransExecutor)Mockito.doReturn(null).when((Object)this.executor)).getRow();
    }

    @Test
    public void testGetLastIncomingFieldValuesWithEmptyData() throws Exception {
        this.prepareNoRowForExecutor();
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        ((TransExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)0))).getLastIncomingFieldValues();
    }

    @Test
    public void testGetLastIncomingFieldValuesWithData() throws KettleException {
        this.prepareMultipleRowsForExecutor();
        this.meta.setGroupField("groupField");
        this.executor.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("groupField"));
        this.executor.setInputRowMeta((RowMetaInterface)rowMeta);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        ((TransExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)0))).getLastIncomingFieldValues();
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        ((TransExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).getLastIncomingFieldValues();
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        this.executor.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data);
        ((TransExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)2))).getLastIncomingFieldValues();
    }
}

