/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileoutput;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.compress.CompressionOutputStream;
import org.pentaho.di.core.compress.CompressionPluginType;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import org.pentaho.di.utils.TestUtils;

public class TextFileOutputTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private static final String EMPTY_FILE_NAME = "Empty File";
    private static final String EMPTY_STRING = "";
    private static final Boolean[] BOOL_VALUE_LIST = new Boolean[]{false, true};
    private static final String TEXT_FILE_OUTPUT_PREFIX = "textFileOutput";
    private static final String TEXT_FILE_OUTPUT_EXTENSION = ".txt";
    private static final String END_LINE = " endLine ";
    private static final String RESULT_ROWS = "\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n";
    private static final String TEST_PREVIOUS_DATA = "testPreviousData\n";
    private StepMockHelper<TextFileOutputMeta, TextFileOutputData> stepMockHelper;
    private TextFileField textFileField = new TextFileField("Name", 2, "", 10, 20, "", "", "", "");
    private TextFileField textFileField2 = new TextFileField("Surname", 2, "", 10, 20, "", "", "", "");
    private TextFileField[] textFileFields = new TextFileField[]{this.textFileField, this.textFileField2};
    private Object[] row = new Object[]{"some data", "another data"};
    private Object[] row2 = new Object[]{"some data2", "another data2"};
    private List<Object[]> emptyRows = new ArrayList<Object[]>();
    private List<Object[]> rows = new ArrayList<Object[]>();
    private List<String> contents = new ArrayList<String>();
    private TextFileOutput textFileOutput;

    public TextFileOutputTest() {
        this.rows.add(this.row);
        this.rows.add(this.row2);
        this.contents.add(EMPTY_STRING);
        this.contents.add(EMPTY_STRING);
        this.contents.add(END_LINE);
        this.contents.add(END_LINE);
        this.contents.add(null);
        this.contents.add(null);
        this.contents.add(END_LINE);
        this.contents.add(END_LINE);
        this.contents.add(RESULT_ROWS);
        this.contents.add(RESULT_ROWS);
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add(RESULT_ROWS);
        this.contents.add(RESULT_ROWS);
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add(EMPTY_STRING);
        this.contents.add(TEST_PREVIOUS_DATA);
        this.contents.add(END_LINE);
        this.contents.add("testPreviousData\n endLine ");
        this.contents.add(TEST_PREVIOUS_DATA);
        this.contents.add(TEST_PREVIOUS_DATA);
        this.contents.add(END_LINE);
        this.contents.add("testPreviousData\n endLine ");
        this.contents.add(RESULT_ROWS);
        this.contents.add("testPreviousData\n\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n");
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add("testPreviousData\n\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add(RESULT_ROWS);
        this.contents.add("testPreviousData\n\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n");
        this.contents.add("\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
        this.contents.add("testPreviousData\n\"some data\" \"another data\"\n\"some data2\" \"another data2\"\n endLine ");
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        PluginRegistry.addPluginType((PluginTypeInterface)CompressionPluginType.getInstance());
        PluginRegistry.init((boolean)false);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        FileUtils.deleteQuietly((File)Paths.get("textFileOutput.txt", new String[0]).toFile());
    }

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<TextFileOutputMeta, TextFileOutputData>("TEXT FILE OUTPUT TEST", TextFileOutputMeta.class, TextFileOutputData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Mockito.any(), (LoggingObjectInterface)Mockito.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Mockito.anyString());
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Mockito.anyString(), (Object[])Mockito.any(Object[].class));
        ((LogChannelInterface)Mockito.verify((Object)this.stepMockHelper.logChannelInterface, (VerificationMode)Mockito.never())).logError(Mockito.anyString(), (Throwable)Mockito.any(Throwable.class));
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.never())).stopAll();
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getSeparator()).thenReturn((Object)" ");
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getEnclosure()).thenReturn((Object)"\"");
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getNewline()).thenReturn((Object)"\n");
        Mockito.when((Object)this.stepMockHelper.transMeta.listVariables()).thenReturn((Object)new String[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testCloseFileDataOutIsNullCase() {
        this.textFileOutput = new TextFileOutput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        this.textFileOutput.data = (TextFileOutputData)Mockito.mock(TextFileOutputData.class);
        Assert.assertNull((Object)this.textFileOutput.data.out);
        this.textFileOutput.closeFile();
    }

    @Test
    public void testCloseFileDataOutIsNotNullCase() {
        this.textFileOutput = new TextFileOutput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        this.textFileOutput.data = (TextFileOutputData)Mockito.mock(TextFileOutputData.class);
        this.textFileOutput.data.out = (CompressionOutputStream)Mockito.mock(CompressionOutputStream.class);
        this.textFileOutput.closeFile();
        Assert.assertNull((Object)this.textFileOutput.data.out);
    }

    private FileObject createTemplateFile() {
        String path = TestUtils.createRamFile(this.getClass().getSimpleName() + "/" + TEXT_FILE_OUTPUT_PREFIX + new Random().nextLong() + TEXT_FILE_OUTPUT_EXTENSION, (VariableSpace)this.stepMockHelper.transMeta);
        return TestUtils.getFileObject(path, (VariableSpace)this.stepMockHelper.transMeta);
    }

    private FileObject createTemplateFile(String content) throws IOException {
        FileObject f2 = this.createTemplateFile();
        if (content == null) {
            f2.delete();
        } else {
            try (OutputStreamWriter fw = new OutputStreamWriter(f2.getContent().getOutputStream());){
                fw.write(content);
            }
        }
        return f2;
    }

    @Test
    public void testsIterate() {
        FileObject resultFile = null;
        String content = null;
        int i = 0;
        for (Boolean fileExists : BOOL_VALUE_LIST) {
            for (Boolean dataReceived : BOOL_VALUE_LIST) {
                for (Boolean isDoNotOpenNewFileInit : BOOL_VALUE_LIST) {
                    for (Boolean endLineExists : BOOL_VALUE_LIST) {
                        for (Boolean append : BOOL_VALUE_LIST) {
                            try {
                                resultFile = this.helpTestInit(fileExists, dataReceived, isDoNotOpenNewFileInit, endLineExists, append);
                                content = (String)this.contents.toArray()[i++];
                                FileObject contentFile = this.createTemplateFile(content);
                                if (resultFile.exists()) {
                                    Assert.assertTrue((boolean)IOUtils.contentEquals((InputStream)resultFile.getContent().getInputStream(), (InputStream)contentFile.getContent().getInputStream()));
                                    continue;
                                }
                                Assert.assertFalse((boolean)contentFile.exists());
                            }
                            catch (Exception e) {
                                Assert.fail((String)(e.getMessage() + "\n FileExists = " + fileExists + "\n DataReceived = " + dataReceived + "\n isDoNotOpenNewFileInit = " + isDoNotOpenNewFileInit + "\n EndLineExists = " + endLineExists + "\n Append = " + append + "\n Content = " + content + "\n resultFile = " + resultFile));
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testNoOpenFileCall_IfRule_1() throws Exception {
        TextFileField tfFieldMock = (TextFileField)Mockito.mock(TextFileField.class);
        TextFileField[] textFileFields = new TextFileField[]{tfFieldMock};
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).getEndedLine()).thenReturn((Object)EMPTY_STRING);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).getOutputFields()).thenReturn((Object)textFileFields);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).isDoNotOpenNewFileInit()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getEndedLine()).thenReturn((Object)EMPTY_STRING);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getFileName()).thenReturn((Object)EMPTY_FILE_NAME);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isDoNotOpenNewFileInit()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getOutputFields()).thenReturn((Object)textFileFields);
        this.textFileOutput = new TextFileOutput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        TextFileOutput textFileOutputSpy = (TextFileOutput)Mockito.spy((Object)this.textFileOutput);
        ((TextFileOutput)Mockito.doReturn((Object)false).when((Object)textFileOutputSpy)).isWriteHeader("textFileOutput.txt");
        ((TextFileOutput)Mockito.doCallRealMethod().when((Object)textFileOutputSpy)).initFileStreamWriter(EMPTY_FILE_NAME);
        ((TextFileOutput)Mockito.doNothing().when((Object)textFileOutputSpy)).flushOpenFiles(true);
        textFileOutputSpy.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).buildFilename(Mockito.anyString(), Mockito.anyString(), (VariableSpace)Mockito.any(VariableSpace.class), Mockito.anyInt(), Mockito.anyString(), Mockito.anyInt(), Mockito.anyBoolean(), (TextFileOutputMeta)Mockito.any(TextFileOutputMeta.class))).thenReturn((Object)"textFileOutput.txt");
        textFileOutputSpy.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        ((TextFileOutput)Mockito.verify((Object)textFileOutputSpy, (VerificationMode)Mockito.never())).initFileStreamWriter(EMPTY_FILE_NAME);
        ((TextFileOutput)Mockito.verify((Object)textFileOutputSpy, (VerificationMode)Mockito.never())).writeEndedLine();
        ((TextFileOutput)Mockito.verify((Object)textFileOutputSpy)).setOutputDone();
    }

    private FileObject helpTestInit(Boolean fileExists, Boolean dataReceived, Boolean isDoNotOpenNewFileInit, Boolean endLineExists, Boolean append) throws Exception {
        List<Throwable> errors;
        String endLine = null;
        FileObject f = fileExists != false ? this.createTemplateFile(TEST_PREVIOUS_DATA) : this.createTemplateFile(null);
        List<Object[]> rows = dataReceived != false ? this.rows : this.emptyRows;
        if (endLineExists.booleanValue()) {
            endLine = END_LINE;
        }
        if (!(errors = this.doOutput(this.textFileFields, rows, f.getName().getURI(), endLine, false, isDoNotOpenNewFileInit, append)).isEmpty()) {
            StringBuilder str = new StringBuilder();
            for (Throwable thr : errors) {
                str.append(thr);
            }
            Assert.fail((String)str.toString());
        }
        return f;
    }

    private List<Throwable> doOutput(TextFileField[] textFileField, List<Object[]> rows, String pathToFile, String endedLine, Boolean isHeaderEnabled, Boolean isDoNotOpenNewFileInit, Boolean append) throws KettleException {
        int i;
        TextFileOutputData textFileOutputData = new TextFileOutputData();
        TextFileOutputTestHandler textFileOutput = new TextFileOutputTestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)textFileOutputData, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isDoNotOpenNewFileInit()).thenReturn((Object)isDoNotOpenNewFileInit);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isFileAppended()).thenReturn((Object)append);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isHeaderEnabled()).thenReturn((Object)isHeaderEnabled);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getFileName()).thenReturn((Object)pathToFile);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).buildFilename(Mockito.anyString(), Mockito.anyString(), (VariableSpace)Mockito.any(VariableSpace.class), Mockito.anyInt(), Mockito.anyString(), Mockito.anyInt(), Mockito.anyBoolean(), (TextFileOutputMeta)Mockito.any(TextFileOutputMeta.class))).thenReturn((Object)pathToFile);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getOutputFields()).thenReturn((Object)textFileField);
        textFileOutput.init((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)textFileOutputData);
        RowSet rowSet = this.stepMockHelper.getMockInputRowSet(rows);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        textFileOutput.setInputRowMeta(inputRowMeta);
        Mockito.when((Object)rowSet.getRowWait((long)Mockito.anyInt(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)))).thenReturn(rows.isEmpty() ? null : rows.iterator().next());
        Mockito.when((Object)rowSet.getRowMeta()).thenReturn((Object)inputRowMeta);
        Mockito.when((Object)inputRowMeta.clone()).thenReturn((Object)inputRowMeta);
        for (i = 0; i < textFileField.length; ++i) {
            String name = textFileField[i].getName();
            ValueMetaString valueMetaString = new ValueMetaString(name);
            Mockito.when((Object)inputRowMeta.getValueMeta(i)).thenReturn((Object)valueMetaString);
            Mockito.when((Object)inputRowMeta.indexOfValue(name)).thenReturn((Object)i);
        }
        textFileOutput.addRowSetToInputRowSets(rowSet);
        textFileOutput.addRowSetToOutputRowSets(rowSet);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getEndedLine()).thenReturn((Object)endedLine);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isFastDump()).thenReturn((Object)true);
        for (i = 0; i < rows.size(); ++i) {
            textFileOutput.setRow(rows.get(i));
            textFileOutput.processRow((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)textFileOutputData);
        }
        textFileOutput.setRow(null);
        textFileOutput.processRow((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)textFileOutputData);
        textFileOutput.dispose((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)textFileOutputData);
        return textFileOutput.errors;
    }

    @Test
    public void containsSeparatorOrEnclosureIsNotUnnecessaryInvoked_SomeFieldsFromMeta() {
        TextFileField field = new TextFileField();
        field.setName("name");
        this.assertNotInvokedTwice(field);
    }

    @Test
    public void containsSeparatorOrEnclosureIsNotUnnecessaryInvoked_AllFieldsFromMeta() {
        this.assertNotInvokedTwice(null);
    }

    @Test
    public void testEndedLineVar() throws Exception {
        TextFileOutputData data = new TextFileOutputData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        data.writer = baos;
        TextFileOutputMeta meta = new TextFileOutputMeta();
        meta.setEndedLine("${endvar}");
        meta.setDefault();
        meta.setEncoding("UTF-8");
        this.stepMockHelper.stepMeta.setStepMetaInterface((StepMetaInterface)meta);
        TextFileOutputTestHandler textFileOutput = new TextFileOutputTestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)data, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        textFileOutput.meta = meta;
        textFileOutput.data = data;
        textFileOutput.setVariable("endvar", "this is the end");
        textFileOutput.writeEndedLine();
        Assert.assertEquals((Object)"this is the end", (Object)baos.toString("UTF-8"));
    }

    private void assertNotInvokedTwice(TextFileField field) {
        TextFileOutput step = new TextFileOutput(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 1, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        TextFileOutputMeta meta = new TextFileOutputMeta();
        meta.setEnclosureForced(false);
        meta.setEnclosureFixDisabled(false);
        step.meta = meta;
        TextFileOutputData data = new TextFileOutputData();
        data.binarySeparator = " ".getBytes();
        data.binaryEnclosure = "\"".getBytes();
        data.binaryNewline = "\n".getBytes();
        step.data = data;
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("name"));
        data.outputRowMeta = rowMeta;
        data.writer = new ByteArrayOutputStream();
        if (field != null) {
            meta.setOutputFields(new TextFileField[]{field});
        }
        step = (TextFileOutput)Mockito.spy((Object)step);
        step.writeHeader();
        ((TextFileOutput)Mockito.verify((Object)step)).containsSeparatorOrEnclosure((byte[])Mockito.any(byte[].class), (byte[])Mockito.any(byte[].class), (byte[])Mockito.any(byte[].class));
    }

    @Test
    public void testProcessRule_2() throws Exception {
        TextFileField tfFieldMock = (TextFileField)Mockito.mock(TextFileField.class);
        TextFileField[] textFileFields = new TextFileField[]{tfFieldMock};
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).getEndedLine()).thenReturn((Object)EMPTY_STRING);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).getOutputFields()).thenReturn((Object)textFileFields);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).isDoNotOpenNewFileInit()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputData)this.stepMockHelper.initStepDataInterface).getFileStreamsCollection()).thenCallRealMethod();
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getEndedLine()).thenReturn((Object)EMPTY_STRING);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getFileName()).thenReturn((Object)"textFileOutput.txt");
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isFileAppended()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isHeaderEnabled()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getOutputFields()).thenReturn((Object)textFileFields);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isDoNotOpenNewFileInit()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isFileNameInField()).thenReturn((Object)false);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isAddToResultFiles()).thenReturn((Object)true);
        Object[] rowData = new Object[]{"data text"};
        this.textFileOutput = new TextFileOutputTestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        ((TextFileOutputTestHandler)this.textFileOutput).setRow(rowData);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ValueMetaInterface valueMetaInterface = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        Mockito.when((Object)valueMetaInterface.getString(Mockito.anyObject())).thenReturn((Object)"textFileOutput.txt");
        Mockito.when((Object)inputRowMeta.getValueMeta(Mockito.anyInt())).thenReturn((Object)valueMetaInterface);
        Mockito.when((Object)inputRowMeta.clone()).thenReturn((Object)inputRowMeta);
        this.textFileOutput.setInputRowMeta(inputRowMeta);
        TextFileOutput textFileOutputSpy = (TextFileOutput)Mockito.spy((Object)this.textFileOutput);
        ((TextFileOutput)Mockito.doCallRealMethod().when((Object)textFileOutputSpy)).initFileStreamWriter("textFileOutput.txt");
        ((TextFileOutput)Mockito.doNothing().when((Object)textFileOutputSpy)).writeRow(inputRowMeta, rowData);
        ((TextFileOutput)Mockito.doReturn((Object)false).when((Object)textFileOutputSpy)).isFileExists("textFileOutput.txt");
        ((TextFileOutput)Mockito.doReturn((Object)true).when((Object)textFileOutputSpy)).isWriteHeader("textFileOutput.txt");
        textFileOutputSpy.init(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).buildFilename("textFileOutput.txt", null, (VariableSpace)textFileOutputSpy, 0, null, 0, true, (TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface)).thenReturn((Object)"textFileOutput.txt");
        textFileOutputSpy.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        ((TextFileOutput)Mockito.verify((Object)textFileOutputSpy, (VerificationMode)Mockito.times((int)1))).writeHeader();
        Assert.assertNotNull((Object)textFileOutputSpy.getResultFiles());
        Assert.assertEquals((long)1L, (long)textFileOutputSpy.getResultFiles().size());
    }

    @Test
    public void testProcessRule_2FileNameInField() throws Exception {
        TextFileField tfFieldMock = (TextFileField)Mockito.mock(TextFileField.class);
        TextFileField[] textFileFields = new TextFileField[]{tfFieldMock};
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).getEndedLine()).thenReturn((Object)EMPTY_STRING);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).getOutputFields()).thenReturn((Object)textFileFields);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.initStepMetaInterface).isDoNotOpenNewFileInit()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputData)this.stepMockHelper.initStepDataInterface).getFileStreamsCollection()).thenCallRealMethod();
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getEndedLine()).thenReturn((Object)EMPTY_STRING);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getFileName()).thenReturn((Object)"textFileOutput.txt");
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isFileAppended()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isHeaderEnabled()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).getOutputFields()).thenReturn((Object)textFileFields);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isDoNotOpenNewFileInit()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isAddToResultFiles()).thenReturn((Object)true);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).isFileNameInField()).thenReturn((Object)true);
        Object[] rowData = new Object[]{"data text"};
        this.textFileOutput = new TextFileOutputTestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        ((TextFileOutputTestHandler)this.textFileOutput).setRow(rowData);
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        ValueMetaInterface valueMetaInterface = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
        Mockito.when((Object)valueMetaInterface.getString(Mockito.anyObject())).thenReturn((Object)"textFileOutput.txt");
        Mockito.when((Object)inputRowMeta.getValueMeta(Mockito.anyInt())).thenReturn((Object)valueMetaInterface);
        Mockito.when((Object)inputRowMeta.clone()).thenReturn((Object)inputRowMeta);
        this.textFileOutput.setInputRowMeta(inputRowMeta);
        TextFileOutput textFileOutputSpy = (TextFileOutput)Mockito.spy((Object)this.textFileOutput);
        ((TextFileOutput)Mockito.doCallRealMethod().when((Object)textFileOutputSpy)).initFileStreamWriter("textFileOutput.txt");
        ((TextFileOutput)Mockito.doReturn((Object)false).when((Object)textFileOutputSpy)).isFileExists("textFileOutput.txt");
        ((TextFileOutput)Mockito.doReturn((Object)true).when((Object)textFileOutputSpy)).isWriteHeader("textFileOutput.txt");
        ((TextFileOutput)Mockito.doNothing().when((Object)textFileOutputSpy)).writeRow(inputRowMeta, rowData);
        textFileOutputSpy.init(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        Mockito.when((Object)((TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface).buildFilename("textFileOutput.txt", null, (VariableSpace)textFileOutputSpy, 0, null, 0, true, (TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface)).thenReturn((Object)"textFileOutput.txt");
        textFileOutputSpy.processRow(this.stepMockHelper.processRowsStepMetaInterface, this.stepMockHelper.initStepDataInterface);
        ((TextFileOutput)Mockito.verify((Object)textFileOutputSpy, (VerificationMode)Mockito.times((int)1))).writeHeader();
        Assert.assertNotNull((Object)textFileOutputSpy.getResultFiles());
        Assert.assertEquals((long)1L, (long)textFileOutputSpy.getResultFiles().size());
    }

    @Test
    public void testFastDumpDisableStreamEncodeTest() throws Exception {
        this.textFileOutput = new TextFileOutputTestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        this.textFileOutput.meta = (TextFileOutputMeta)this.stepMockHelper.processRowsStepMetaInterface;
        String testString = "\u00d6\u00dc\u00e4";
        String inputEncode = "UTF-8";
        String outputEncode = "Windows-1252";
        Object[] rows = new Object[]{testString.getBytes(inputEncode)};
        ValueMetaBase valueMetaInterface = new ValueMetaBase("test", 2);
        valueMetaInterface.setStringEncoding(inputEncode);
        valueMetaInterface.setStorageType(1);
        valueMetaInterface.setStorageMetadata((ValueMetaInterface)new ValueMetaString());
        TextFileOutputData data = new TextFileOutputData();
        data.binarySeparator = " ".getBytes();
        data.binaryEnclosure = "\"".getBytes();
        data.binaryNewline = "\n".getBytes();
        this.textFileOutput.data = data;
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)valueMetaInterface);
        ((TextFileOutputMeta)Mockito.doReturn((Object)outputEncode).when(this.stepMockHelper.processRowsStepMetaInterface)).getEncoding();
        this.textFileOutput.data.writer = (OutputStream)Mockito.mock(BufferedOutputStream.class);
        this.textFileOutput.writeRow((RowMetaInterface)rowMeta, rows);
        ((OutputStream)Mockito.verify((Object)this.textFileOutput.data.writer)).write(testString.getBytes(outputEncode));
    }

    @Test
    public void testWriteRowToFile_NoinitFileStreamWriter() throws Exception {
        OutputStream originalWriter;
        this.textFileOutput = new TextFileOutputTestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        TextFileOutputMeta mockTFOMeta = (TextFileOutputMeta)Mockito.mock(TextFileOutputMeta.class);
        Mockito.when((Object)mockTFOMeta.isServletOutput()).thenReturn((Object)false);
        Path tempDirWithPrefix = Files.createTempDirectory("pdi-textFileOutputTest", new FileAttribute[0]);
        Mockito.when((Object)mockTFOMeta.getFileName()).thenReturn((Object)(tempDirWithPrefix.toString() + "/wtf.txt"));
        this.textFileOutput.meta = mockTFOMeta;
        TextFileOutputData data = new TextFileOutputData();
        data.binarySeparator = " ".getBytes();
        data.binaryEnclosure = "\"".getBytes();
        data.binaryNewline = "\n".getBytes();
        this.textFileOutput.data = data;
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("name"));
        data.outputRowMeta = rowMeta;
        this.textFileOutput.data.writer = originalWriter = (OutputStream)Mockito.mock(BufferedOutputStream.class);
        this.textFileOutput.writeRowTo(this.row2);
        Assert.assertEquals((Object)originalWriter, (Object)this.textFileOutput.data.writer);
    }

    @Test
    public void testWriteRowToFile_initFileStreamWriter() throws Exception {
        this.textFileOutput = new TextFileOutputTestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        TextFileOutputMeta mockTFOMeta = (TextFileOutputMeta)Mockito.mock(TextFileOutputMeta.class);
        Mockito.when((Object)mockTFOMeta.isServletOutput()).thenReturn((Object)false);
        Path tempDirWithPrefix = Files.createTempDirectory("pdi-textFileOutputTest", new FileAttribute[0]);
        Mockito.when((Object)mockTFOMeta.getFileName()).thenReturn((Object)(tempDirWithPrefix.toString() + "/wtf.txt"));
        this.textFileOutput.meta = mockTFOMeta;
        TextFileOutputData data = new TextFileOutputData();
        data.binarySeparator = " ".getBytes();
        data.binaryEnclosure = "\"".getBytes();
        data.binaryNewline = "\n".getBytes();
        this.textFileOutput.data = data;
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("name"));
        data.outputRowMeta = rowMeta;
        this.textFileOutput.data.writer = null;
        this.textFileOutput.writeRowTo(this.row2);
        Assert.assertNotNull((Object)this.textFileOutput.data.writer);
    }

    @Test
    public void testWriteRowToFile_NoinitServletStreamWriter() throws Exception {
        OutputStream originalWriter;
        this.textFileOutput = new TextFileOutputTestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        TextFileOutputMeta mockTFOMeta = (TextFileOutputMeta)Mockito.mock(TextFileOutputMeta.class);
        Mockito.when((Object)mockTFOMeta.isServletOutput()).thenReturn((Object)true);
        this.textFileOutput.meta = mockTFOMeta;
        TextFileOutputData data = new TextFileOutputData();
        data.binarySeparator = " ".getBytes();
        data.binaryEnclosure = "\"".getBytes();
        data.binaryNewline = "\n".getBytes();
        this.textFileOutput.data = data;
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("name"));
        data.outputRowMeta = rowMeta;
        this.textFileOutput.data.writer = originalWriter = (OutputStream)Mockito.mock(BufferedOutputStream.class);
        this.textFileOutput.writeRowTo(this.row2);
        Assert.assertEquals((Object)originalWriter, (Object)this.textFileOutput.data.writer);
    }

    @Test
    public void testWriteRowToFile_initServletStreamWriter() throws Exception {
        this.textFileOutput = new TextFileOutputTestHandler(this.stepMockHelper.stepMeta, (StepDataInterface)this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        TextFileOutputMeta mockTFOMeta = (TextFileOutputMeta)Mockito.mock(TextFileOutputMeta.class);
        Mockito.when((Object)mockTFOMeta.isServletOutput()).thenReturn((Object)true);
        this.textFileOutput.meta = mockTFOMeta;
        TextFileOutputData data = new TextFileOutputData();
        data.binarySeparator = " ".getBytes();
        data.binaryEnclosure = "\"".getBytes();
        data.binaryNewline = "\n".getBytes();
        this.textFileOutput.data = data;
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("name"));
        data.outputRowMeta = rowMeta;
        data.binaryEnclosure = "enclosure".getBytes();
        Mockito.when((Object)this.textFileOutput.getTrans().getServletPrintWriter()).thenReturn(Mockito.mock(PrintWriter.class));
        this.textFileOutput.data.writer = null;
        this.textFileOutput.writeRowTo(this.row2);
        Assert.assertNotNull((Object)this.textFileOutput.data.writer);
    }

    public class TextFileOutputTestHandler
    extends TextFileOutput {
        public List<Throwable> errors;
        private Object[] row;

        TextFileOutputTestHandler(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
            this.errors = new ArrayList<Throwable>();
        }

        public void setRow(Object[] row) {
            this.row = row;
        }

        public String buildFilename(String filename, boolean ziparchive) {
            return filename;
        }

        public Object[] getRow() throws KettleException {
            return this.row;
        }

        public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        }

        public void logError(String message) {
            this.errors.add(new KettleException(message));
        }

        public void logError(String message, Throwable thr) {
            this.errors.add(thr);
        }

        public void logError(String message, Object ... arguments) {
            this.errors.add(new KettleException(message));
        }
    }
}

