/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileinput;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInjectionUtil;
import org.pentaho.di.trans.step.StepMetaInjectionEntryInterface;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputMetaInjection;

public class TextFileInputMetaInjectionTest {
    @Test
    public void extractingAll() throws Exception {
        TextFileInputMetaInjection injection = new TextFileInputMetaInjection(new TextFileInputMeta());
        List metadata = injection.getStepInjectionMetadataEntries();
        List extracted = injection.extractStepMetadataEntries();
        Assert.assertEquals((long)metadata.size(), (long)extracted.size());
        for (StepInjectionMetaEntry metaEntry : metadata) {
            Assert.assertNotNull((String)metaEntry.getKey(), (Object)StepInjectionUtil.findEntry((List)extracted, (String)metaEntry.getKey()));
        }
    }

    @Test
    public void topEntriesAreInjected() throws Exception {
        TextFileInputMetaInjection.Entry[] topEntries = TextFileInputMetaInjection.Entry.getTopEntries();
        List<StepInjectionMetaEntry> injectionValues = TextFileInputMetaInjectionTest.createInjectionValues(topEntries);
        TextFileInputMetaInjection injection = new TextFileInputMetaInjection(new TextFileInputMeta());
        injection.injectStepMetadataEntries(injectionValues);
        TextFileInputMetaInjectionTest.assertInjected(injection.extractStepMetadataEntries(), injectionValues);
    }

    private static List<StepInjectionMetaEntry> createInjectionValues(TextFileInputMetaInjection.Entry[] entries) {
        Map<TextFileInputMetaInjection.Entry, Generator<?>> generators = TextFileInputMetaInjectionTest.createGeneratorsMapping();
        ArrayList<StepInjectionMetaEntry> result = new ArrayList<StepInjectionMetaEntry>(entries.length);
        for (TextFileInputMetaInjection.Entry entry : entries) {
            StepInjectionMetaEntry injectionEntry = StepInjectionUtil.getEntry((StepMetaInjectionEntryInterface)entry);
            if (entry.getValueType() != 0) {
                injectionEntry.setValue(generators.get(entry).generateValue());
            }
            result.add(injectionEntry);
        }
        return result;
    }

    private static Map<TextFileInputMetaInjection.Entry, Generator<?>> createGeneratorsMapping() {
        EnumMap generators = new EnumMap(TextFileInputMetaInjection.Entry.class);
        ValidatorAdapter<String> stringGenerator = new ValidatorAdapter<String>(new StringLoadSaveValidator());
        List<TextFileInputMetaInjection.Entry> stringEntries = Arrays.asList(TextFileInputMetaInjection.Entry.FILE_TYPE, TextFileInputMetaInjection.Entry.SEPARATOR, TextFileInputMetaInjection.Entry.ENCLOSURE, TextFileInputMetaInjection.Entry.ESCAPE_CHAR, TextFileInputMetaInjection.Entry.COMPRESSION_TYPE, TextFileInputMetaInjection.Entry.FILENAME_FIELD, TextFileInputMetaInjection.Entry.ROW_NUMBER_FIELD, TextFileInputMetaInjection.Entry.FILE_FORMAT, TextFileInputMetaInjection.Entry.ENCODING, TextFileInputMetaInjection.Entry.ACCEPT_FILE_STEP, TextFileInputMetaInjection.Entry.ACCEPT_FILE_FIELD, TextFileInputMetaInjection.Entry.FILE_SHORT_FILE_FIELDNAME, TextFileInputMetaInjection.Entry.FILE_PATH_FIELDNAME, TextFileInputMetaInjection.Entry.FILE_LAST_MODIFICATION_FIELDNAME, TextFileInputMetaInjection.Entry.FILE_URI_FIELDNAME, TextFileInputMetaInjection.Entry.FILE_EXTENSION_FIELDNAME, TextFileInputMetaInjection.Entry.FILE_SIZE_FIELDNAME, TextFileInputMetaInjection.Entry.FILE_ERROR_FIELD, TextFileInputMetaInjection.Entry.FILE_ERROR_MESSAGE_FIELD, TextFileInputMetaInjection.Entry.ERROR_COUNT_FIELD, TextFileInputMetaInjection.Entry.ERROR_FIELDS_FIELD, TextFileInputMetaInjection.Entry.ERROR_TEXT_FIELD, TextFileInputMetaInjection.Entry.WARNING_FILES_TARGET_DIR, TextFileInputMetaInjection.Entry.WARNING_FILES_EXTENTION, TextFileInputMetaInjection.Entry.ERROR_FILES_TARGET_DIR, TextFileInputMetaInjection.Entry.ERROR_FILES_EXTENTION, TextFileInputMetaInjection.Entry.LINE_NR_FILES_TARGET_DIR, TextFileInputMetaInjection.Entry.LINE_NR_FILES_EXTENTION);
        for (TextFileInputMetaInjection.Entry entry : stringEntries) {
            generators.put(entry, stringGenerator);
        }
        ValidatorAdapter<Integer> intGenerator = new ValidatorAdapter<Integer>(new IntLoadSaveValidator());
        List<TextFileInputMetaInjection.Entry> intEntries = Arrays.asList(TextFileInputMetaInjection.Entry.NR_HEADER_LINES, TextFileInputMetaInjection.Entry.NR_FOOTER_LINES, TextFileInputMetaInjection.Entry.NR_WRAPS, TextFileInputMetaInjection.Entry.NR_DOC_HEADER_LINES, TextFileInputMetaInjection.Entry.NR_LINES_PER_PAGE, TextFileInputMetaInjection.Entry.ROW_LIMIT);
        for (TextFileInputMetaInjection.Entry entry : intEntries) {
            generators.put(entry, intGenerator);
        }
        YesNoGenerator yesNoGenerator = new YesNoGenerator();
        List<TextFileInputMetaInjection.Entry> yesNoEntries = Arrays.asList(TextFileInputMetaInjection.Entry.BREAK_IN_ENCLOSURE, TextFileInputMetaInjection.Entry.HEADER_PRESENT, TextFileInputMetaInjection.Entry.HAS_FOOTER, TextFileInputMetaInjection.Entry.HAS_WRAPPED_LINES, TextFileInputMetaInjection.Entry.HAS_PAGED_LAYOUT, TextFileInputMetaInjection.Entry.NO_EMPTY_LINES, TextFileInputMetaInjection.Entry.INCLUDE_FILENAME, TextFileInputMetaInjection.Entry.INCLUDE_ROW_NUMBER, TextFileInputMetaInjection.Entry.ROW_NUMBER_BY_FILE, TextFileInputMetaInjection.Entry.DATE_FORMAT_LENIENT, TextFileInputMetaInjection.Entry.ACCEPT_FILE_NAMES, TextFileInputMetaInjection.Entry.PASS_THROUGH_FIELDS, TextFileInputMetaInjection.Entry.ADD_FILES_TO_RESULT, TextFileInputMetaInjection.Entry.FILE_HIDDEN_FIELDNAME, TextFileInputMetaInjection.Entry.SKIP_BAD_FILES, TextFileInputMetaInjection.Entry.IGNORE_ERRORS, TextFileInputMetaInjection.Entry.ERROR_LINES_SKIPPED);
        for (TextFileInputMetaInjection.Entry entry : yesNoEntries) {
            generators.put(entry, yesNoGenerator);
        }
        generators.put(TextFileInputMetaInjection.Entry.DATE_FORMAT_LOCALE, new Constant<String>("en"));
        return generators;
    }

    private static void assertInjected(List<StepInjectionMetaEntry> fields, List<StepInjectionMetaEntry> toBeInjected) {
        HashMap<String, StepInjectionMetaEntry> map = new HashMap<String, StepInjectionMetaEntry>(fields.size());
        for (StepInjectionMetaEntry field : fields) {
            map.put(field.getKey(), field);
        }
        for (StepInjectionMetaEntry entry : toBeInjected) {
            StepInjectionMetaEntry field = (StepInjectionMetaEntry)map.get(entry.getKey());
            Assert.assertNotNull((String)entry.getKey(), (Object)field);
            Object value = field.getValue();
            if (value == null) {
                Assert.assertNull((String)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            Assert.assertEquals((String)entry.getKey(), (Object)entry.getValue(), (Object)value);
        }
    }

    private static class Constant<T>
    implements Generator<T> {
        private final T value;

        public Constant(T value) {
            this.value = value;
        }

        @Override
        public T generateValue() {
            return this.value;
        }
    }

    private static class ValidatorAdapter<T>
    implements Generator<String> {
        private final FieldLoadSaveValidator<T> validator;

        public ValidatorAdapter(FieldLoadSaveValidator<T> validator) {
            this.validator = validator;
        }

        @Override
        public String generateValue() {
            return this.validator.getTestObject().toString();
        }
    }

    private static class YesNoGenerator
    implements Generator<String> {
        private final Random random = new Random();

        private YesNoGenerator() {
        }

        @Override
        public String generateValue() {
            if (this.random.nextBoolean()) {
                return "Y";
            }
            return "N";
        }
    }

    private static interface Generator<T> {
        public T generateValue();
    }
}

