/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.terafast;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.util.GenericStepData;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.terafast.TeraFast;
import org.pentaho.di.trans.steps.terafast.TeraFastMeta;

public class TeraFastTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    private StepMockHelper<TeraFastMeta, GenericStepData> stepMockHelper;
    private TeraFast teraFast;

    @BeforeClass
    public static void initEnvironment() throws KettleException {
        KettleEnvironment.init();
    }

    @Before
    public void setUp() {
        this.stepMockHelper = new StepMockHelper<TeraFastMeta, GenericStepData>("TeraFast", TeraFastMeta.class, GenericStepData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        this.teraFast = new TeraFast(this.stepMockHelper.stepMeta, this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
    }

    @After
    public void tearDown() throws Exception {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testNullDataFilePrintStream() throws KettleException {
        TeraFast teraFastDataFilePrintStreamIsNull = (TeraFast)Mockito.mock(TeraFast.class);
        ((TeraFast)Mockito.doReturn(null).when((Object)teraFastDataFilePrintStreamIsNull)).getRow();
        TeraFastMeta meta = (TeraFastMeta)Mockito.mock(TeraFastMeta.class);
        GenericStepData data = (GenericStepData)Mockito.mock(GenericStepData.class);
        Assert.assertFalse((boolean)teraFastDataFilePrintStreamIsNull.processRow((StepMetaInterface)meta, (StepDataInterface)data));
    }

    @Test
    public void testNoDatabaseConnection() {
        try {
            ((TeraFastMeta)Mockito.doReturn(null).when(this.stepMockHelper.initStepMetaInterface)).getDbMeta();
            Assert.assertFalse((boolean)this.teraFast.init(this.stepMockHelper.initStepMetaInterface, this.stepMockHelper.initStepDataInterface));
            this.teraFast.verifyDatabaseConnection();
            Assert.fail((String)"Database Connection is not null, this fails the test.");
        }
        catch (KettleException aKettleException) {
            MatcherAssert.assertThat((Object)aKettleException.getMessage(), (Matcher)CoreMatchers.containsString((String)"There is no connection defined in this step."));
        }
    }
}

