/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableoutput;

import java.sql.Connection;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutput;
import org.pentaho.di.trans.steps.tableoutput.TableOutputData;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;

public class TableOutputTest {
    private DatabaseMeta databaseMeta;
    private StepMeta stepMeta;
    private TableOutput tableOutput;
    private TableOutput tableOutputSpy;
    private TableOutputMeta tableOutputMeta;
    private TableOutputMeta tableOutputMetaSpy;
    private TableOutputData tableOutputData;
    private TableOutputData tableOutputDataSpy;
    private Database db;

    @Before
    public void setUp() throws Exception {
        this.databaseMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        ((DatabaseMeta)Mockito.doReturn((Object)"").when((Object)this.databaseMeta)).quoteField(Matchers.anyString());
        this.tableOutputMeta = (TableOutputMeta)Mockito.mock(TableOutputMeta.class);
        ((TableOutputMeta)Mockito.doReturn((Object)this.databaseMeta).when((Object)this.tableOutputMeta)).getDatabaseMeta();
        this.stepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        ((StepMeta)Mockito.doReturn((Object)"step").when((Object)this.stepMeta)).getName();
        ((StepMeta)Mockito.doReturn((Object)Mockito.mock(StepPartitioningMeta.class)).when((Object)this.stepMeta)).getTargetStepPartitioningMeta();
        ((StepMeta)Mockito.doReturn((Object)this.tableOutputMeta).when((Object)this.stepMeta)).getStepMetaInterface();
        this.db = (Database)Mockito.mock(Database.class);
        ((Database)Mockito.doReturn((Object)Mockito.mock(Connection.class)).when((Object)this.db)).getConnection();
        this.tableOutputData = (TableOutputData)Mockito.mock(TableOutputData.class);
        this.tableOutputData.db = this.db;
        this.tableOutputData.tableName = "sas";
        this.tableOutputData.preparedStatements = (Map)Mockito.mock(Map.class);
        this.tableOutputData.commitCounterMap = (Map)Mockito.mock(Map.class);
        TransMeta transMeta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn((Object)this.stepMeta).when((Object)transMeta)).findStep(Matchers.anyString());
        this.tableOutput = new TableOutput(this.stepMeta, (StepDataInterface)this.tableOutputData, 1, transMeta, (Trans)Mockito.mock(Trans.class));
        this.tableOutput.setData(this.tableOutputData);
        this.tableOutput.setMeta(this.tableOutputMeta);
        this.tableOutputSpy = (TableOutput)Mockito.spy((Object)this.tableOutput);
        ((TableOutput)Mockito.doReturn((Object)this.stepMeta).when((Object)this.tableOutputSpy)).getStepMeta();
        ((TableOutput)Mockito.doReturn((Object)false).when((Object)this.tableOutputSpy)).isRowLevel();
        ((TableOutput)Mockito.doReturn((Object)false).when((Object)this.tableOutputSpy)).isDebug();
        ((TableOutput)Mockito.doNothing().when((Object)this.tableOutputSpy)).logDetailed(Matchers.anyString());
    }

    @Test
    public void testWriteToTable() throws Exception {
        this.tableOutputSpy.writeToTable((RowMetaInterface)Mockito.mock(RowMetaInterface.class), new Object[0]);
    }

    @Test
    public void testTruncateTable_off() throws Exception {
        this.tableOutputSpy.truncateTable();
        ((Database)Mockito.verify((Object)this.db, (VerificationMode)Mockito.never())).truncateTable(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testTruncateTable_on() throws Exception {
        Mockito.when((Object)this.tableOutputMeta.truncateTable()).thenReturn((Object)true);
        Mockito.when((Object)this.tableOutputSpy.getCopy()).thenReturn((Object)0);
        Mockito.when((Object)this.tableOutputSpy.getUniqueStepNrAcrossSlaves()).thenReturn((Object)0);
        this.tableOutputSpy.truncateTable();
        ((Database)Mockito.verify((Object)this.db)).truncateTable(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testTruncateTable_on_PartitionId() throws Exception {
        Mockito.when((Object)this.tableOutputMeta.truncateTable()).thenReturn((Object)true);
        Mockito.when((Object)this.tableOutputSpy.getCopy()).thenReturn((Object)1);
        Mockito.when((Object)this.tableOutputSpy.getUniqueStepNrAcrossSlaves()).thenReturn((Object)0);
        Mockito.when((Object)this.tableOutputSpy.getPartitionID()).thenReturn((Object)"partition id");
        this.tableOutputSpy.truncateTable();
        ((Database)Mockito.verify((Object)this.db)).truncateTable(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testProcessRow_truncatesIfNoRowsAvailable() throws Exception {
        Mockito.when((Object)this.tableOutputMeta.truncateTable()).thenReturn((Object)true);
        ((TableOutput)Mockito.doReturn(null).when((Object)this.tableOutputSpy)).getRow();
        boolean result = this.tableOutputSpy.processRow((StepMetaInterface)this.tableOutputMeta, (StepDataInterface)this.tableOutputData);
        Assert.assertFalse((boolean)result);
        ((TableOutput)Mockito.verify((Object)this.tableOutputSpy)).truncateTable();
    }

    @Test
    public void testProcessRow_doesNotTruncateIfNoRowsAvailableAndTruncateIsOff() throws Exception {
        Mockito.when((Object)this.tableOutputMeta.truncateTable()).thenReturn((Object)false);
        ((TableOutput)Mockito.doReturn(null).when((Object)this.tableOutputSpy)).getRow();
        boolean result = this.tableOutputSpy.processRow((StepMetaInterface)this.tableOutputMeta, (StepDataInterface)this.tableOutputData);
        Assert.assertFalse((boolean)result);
        ((TableOutput)Mockito.verify((Object)this.tableOutputSpy, (VerificationMode)Mockito.never())).truncateTable();
    }

    @Test
    public void testProcessRow_truncatesOnFirstRow() throws Exception {
        Mockito.when((Object)this.tableOutputMeta.truncateTable()).thenReturn((Object)true);
        Object[] row = new Object[]{};
        ((TableOutput)Mockito.doReturn((Object)row).when((Object)this.tableOutputSpy)).getRow();
        try {
            boolean bl = this.tableOutputSpy.processRow((StepMetaInterface)this.tableOutputMeta, (StepDataInterface)this.tableOutputData);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ((TableOutput)Mockito.verify((Object)this.tableOutputSpy, (VerificationMode)Mockito.times((int)1))).truncateTable();
    }

    @Test
    public void testProcessRow_doesNotTruncateOnOtherRows() throws Exception {
        Mockito.when((Object)this.tableOutputMeta.truncateTable()).thenReturn((Object)true);
        Object[] row = new Object[]{};
        ((TableOutput)Mockito.doReturn((Object)row).when((Object)this.tableOutputSpy)).getRow();
        this.tableOutputSpy.first = false;
        ((TableOutput)Mockito.doReturn(null).when((Object)this.tableOutputSpy)).writeToTable((RowMetaInterface)Mockito.any(RowMetaInterface.class), (Object[])Mockito.any(row.getClass()));
        boolean result = this.tableOutputSpy.processRow((StepMetaInterface)this.tableOutputMeta, (StepDataInterface)this.tableOutputData);
        Assert.assertTrue((boolean)result);
        ((TableOutput)Mockito.verify((Object)this.tableOutputSpy, (VerificationMode)Mockito.never())).truncateTable();
    }

    @Test
    public void testInit_unsupportedConnection() {
        TableOutputMeta meta = (TableOutputMeta)Mockito.mock(TableOutputMeta.class);
        TableOutputData data = (TableOutputData)Mockito.mock(TableOutputData.class);
        DatabaseInterface dbInterface = (DatabaseInterface)Mockito.mock(DatabaseInterface.class);
        ((TableOutput)Mockito.doNothing().when((Object)this.tableOutputSpy)).logError(Matchers.anyString());
        Mockito.when((Object)meta.getCommitSize()).thenReturn((Object)"1");
        Mockito.when((Object)meta.getDatabaseMeta()).thenReturn((Object)this.databaseMeta);
        Mockito.when((Object)this.databaseMeta.getDatabaseInterface()).thenReturn((Object)dbInterface);
        String unsupportedTableOutputMessage = "unsupported exception";
        Mockito.when((Object)dbInterface.getUnsupportedTableOutputMessage()).thenReturn((Object)unsupportedTableOutputMessage);
        Mockito.when((Object)dbInterface.supportsStandardTableOutput()).thenReturn((Object)false);
        this.tableOutputSpy.init((StepMetaInterface)meta, (StepDataInterface)data);
        KettleException ke = new KettleException(unsupportedTableOutputMessage);
        ((TableOutput)Mockito.verify((Object)this.tableOutputSpy, (VerificationMode)Mockito.times((int)1))).logError("An error occurred intialising this step: " + ke.getMessage());
    }
}

