/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableoutput;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.loadsave.MemoryRepository;
import org.pentaho.di.trans.steps.tableoutput.TableOutputData;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;
import org.pentaho.di.utils.TestUtils;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class TableOutputMetaTest {
    private List<DatabaseMeta> databases;
    private IMetaStore metaStore;

    @Before
    public void setUp() {
        this.databases = (List)Mockito.mock(List.class);
        this.metaStore = (IMetaStore)Mockito.mock(IMetaStore.class);
    }

    @Test
    public void testReadRep() throws KettleException {
        String commitSize = "${test}";
        MemoryRepository rep = new MemoryRepository();
        rep.saveStepAttribute(null, null, "commit", commitSize);
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.readRep((Repository)rep, this.metaStore, null, this.databases);
        Assert.assertEquals((Object)commitSize, (Object)tableOutputMeta.getCommitSize());
        int commitSizeInt = 1;
        MemoryRepository rep2 = new MemoryRepository();
        rep2.saveStepAttribute(null, null, "commit", commitSizeInt);
        TableOutputMeta tableOutputMeta2 = new TableOutputMeta();
        tableOutputMeta2.readRep((Repository)rep2, this.metaStore, null, this.databases);
        Assert.assertEquals((Object)String.valueOf(commitSizeInt), (Object)tableOutputMeta2.getCommitSize());
    }

    @Test
    public void testIsReturningGeneratedKeys() throws Exception {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        TableOutputMeta tableOutputMetaSpy = (TableOutputMeta)Mockito.spy((Object)tableOutputMeta);
        DatabaseMeta databaseMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        ((DatabaseMeta)Mockito.doReturn((Object)true).when((Object)databaseMeta)).supportsAutoGeneratedKeys();
        ((TableOutputMeta)Mockito.doReturn((Object)databaseMeta).when((Object)tableOutputMetaSpy)).getDatabaseMeta();
        tableOutputMetaSpy.setReturningGeneratedKeys(true);
        Assert.assertTrue((boolean)tableOutputMetaSpy.isReturningGeneratedKeys());
        ((DatabaseMeta)Mockito.doReturn((Object)false).when((Object)databaseMeta)).supportsAutoGeneratedKeys();
        Assert.assertFalse((boolean)tableOutputMetaSpy.isReturningGeneratedKeys());
        tableOutputMetaSpy.setReturningGeneratedKeys(true);
        Assert.assertFalse((boolean)tableOutputMetaSpy.isReturningGeneratedKeys());
        tableOutputMetaSpy.setReturningGeneratedKeys(false);
        Assert.assertFalse((boolean)tableOutputMetaSpy.isReturningGeneratedKeys());
    }

    @Test
    public void testProvidesModeler() throws Exception {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.setFieldDatabase(new String[]{"f1", "f2", "f3"});
        tableOutputMeta.setFieldStream(new String[]{"s4", "s5", "s6"});
        TableOutputData tableOutputData = new TableOutputData();
        tableOutputData.insertRowMeta = (RowMetaInterface)Mockito.mock(RowMeta.class);
        Assert.assertEquals((Object)tableOutputData.insertRowMeta, (Object)tableOutputMeta.getRowMeta((StepDataInterface)tableOutputData));
        tableOutputMeta.setSpecifyFields(false);
        Assert.assertEquals((long)0L, (long)tableOutputMeta.getDatabaseFields().size());
        Assert.assertEquals((long)0L, (long)tableOutputMeta.getStreamFields().size());
        tableOutputMeta.setSpecifyFields(true);
        Assert.assertEquals((long)3L, (long)tableOutputMeta.getDatabaseFields().size());
        Assert.assertEquals((Object)"f1", tableOutputMeta.getDatabaseFields().get(0));
        Assert.assertEquals((Object)"f2", tableOutputMeta.getDatabaseFields().get(1));
        Assert.assertEquals((Object)"f3", tableOutputMeta.getDatabaseFields().get(2));
        Assert.assertEquals((long)3L, (long)tableOutputMeta.getStreamFields().size());
        Assert.assertEquals((Object)"s4", tableOutputMeta.getStreamFields().get(0));
        Assert.assertEquals((Object)"s5", tableOutputMeta.getStreamFields().get(1));
        Assert.assertEquals((Object)"s6", tableOutputMeta.getStreamFields().get(2));
    }

    @Test
    public void testLoadXml() throws Exception {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.loadXML(this.getTestNode(), this.databases, this.metaStore);
        Assert.assertEquals((Object)"1000", (Object)tableOutputMeta.getCommitSize());
        Assert.assertEquals(null, (Object)tableOutputMeta.getGeneratedKeyField());
        Assert.assertEquals((Object)"public", (Object)tableOutputMeta.getSchemaName());
        Assert.assertEquals((Object)"sales_csv", (Object)tableOutputMeta.getTableName());
        Assert.assertEquals(null, (Object)tableOutputMeta.getPartitioningField());
        Assert.assertTrue((boolean)tableOutputMeta.truncateTable());
        Assert.assertTrue((boolean)tableOutputMeta.specifyFields());
        Assert.assertFalse((boolean)tableOutputMeta.ignoreErrors());
        Assert.assertFalse((boolean)tableOutputMeta.isPartitioningEnabled());
        Assert.assertTrue((boolean)tableOutputMeta.useBatchUpdate());
        Assert.assertFalse((boolean)tableOutputMeta.isTableNameInField());
        Assert.assertTrue((boolean)tableOutputMeta.isTableNameInTable());
        Assert.assertFalse((boolean)tableOutputMeta.isReturningGeneratedKeys());
        String expectedXml = "    <connection/>\n    <schema>public</schema>\n    <table>sales_csv</table>\n    <commit>1000</commit>\n    <truncate>Y</truncate>\n    <ignore_errors>N</ignore_errors>\n    <use_batch>Y</use_batch>\n    <specify_fields>Y</specify_fields>\n    <partitioning_enabled>N</partitioning_enabled>\n    <partitioning_field/>\n    <partitioning_daily>N</partitioning_daily>\n    <partitioning_monthly>Y</partitioning_monthly>\n    <tablename_in_field>N</tablename_in_field>\n    <tablename_field/>\n    <tablename_in_table>Y</tablename_in_table>\n    <return_keys>N</return_keys>\n    <return_field/>\n    <fields>\n        <field>\n          <column_name>ORDERNUMBER</column_name>\n          <stream_name>ORDERNUMBER</stream_name>\n        </field>\n        <field>\n          <column_name>QUANTITYORDERED</column_name>\n          <stream_name>QUANTITYORDERED</stream_name>\n        </field>\n        <field>\n          <column_name>PRICEEACH</column_name>\n          <stream_name>PRICEEACH</stream_name>\n        </field>\n    </fields>\n";
        String actualXml = TestUtils.toUnixLineSeparators(tableOutputMeta.getXML());
        Assert.assertEquals((Object)expectedXml, (Object)actualXml);
    }

    @Test
    public void testSaveRep() throws Exception {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.loadXML(this.getTestNode(), this.databases, this.metaStore);
        StringObjectId id_step = new StringObjectId("stepid");
        StringObjectId id_transformation = new StringObjectId("transid");
        Repository rep = (Repository)Mockito.mock(Repository.class);
        tableOutputMeta.saveRep(rep, this.metaStore, (ObjectId)id_transformation, (ObjectId)id_step);
        ((Repository)Mockito.verify((Object)rep)).saveDatabaseMetaStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "id_connection", null);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "schema", "public");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "table", "sales_csv");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "commit", "1000");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "truncate", true);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "ignore_errors", false);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "use_batch", true);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "specify_fields", true);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "partitioning_enabled", false);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "partitioning_field", null);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "partitioning_daily", false);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "partitioning_monthly", true);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "tablename_in_field", false);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "tablename_field", null);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "tablename_in_table", true);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "return_keys", false);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, "return_field", null);
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, 0, "column_name", "ORDERNUMBER");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, 0, "stream_name", "ORDERNUMBER");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, 1, "column_name", "QUANTITYORDERED");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, 1, "stream_name", "QUANTITYORDERED");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, 2, "column_name", "PRICEEACH");
        ((Repository)Mockito.verify((Object)rep)).saveStepAttribute((ObjectId)id_transformation, (ObjectId)id_step, 2, "stream_name", "PRICEEACH");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{rep});
    }

    @Test
    public void testSetupDefault() throws Exception {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.setDefault();
        Assert.assertEquals((Object)"", (Object)tableOutputMeta.getTableName());
        Assert.assertEquals((Object)"1000", (Object)tableOutputMeta.getCommitSize());
        Assert.assertFalse((boolean)tableOutputMeta.isPartitioningEnabled());
        Assert.assertTrue((boolean)tableOutputMeta.isPartitioningMonthly());
        Assert.assertEquals((Object)"", (Object)tableOutputMeta.getPartitioningField());
        Assert.assertTrue((boolean)tableOutputMeta.isTableNameInTable());
        Assert.assertEquals((Object)"", (Object)tableOutputMeta.getTableNameField());
        Assert.assertFalse((boolean)tableOutputMeta.specifyFields());
    }

    @Test
    public void testClone() throws Exception {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.setDefault();
        tableOutputMeta.setFieldStream(new String[]{"1", "2", "3"});
        tableOutputMeta.setFieldDatabase(new String[]{"d1", "d2", "d3"});
        TableOutputMeta clone = (TableOutputMeta)tableOutputMeta.clone();
        Assert.assertNotSame((Object)clone, (Object)tableOutputMeta);
        Assert.assertEquals((Object)clone.getXML(), (Object)tableOutputMeta.getXML());
    }

    @Test
    public void testSupportsErrorHandling() throws Exception {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        tableOutputMeta.setDatabaseMeta(dbMeta);
        DatabaseInterface databaseInterface = (DatabaseInterface)Mockito.mock(DatabaseInterface.class);
        Mockito.when((Object)dbMeta.getDatabaseInterface()).thenReturn((Object)databaseInterface);
        Mockito.when((Object)databaseInterface.supportsErrorHandling()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Assert.assertTrue((boolean)tableOutputMeta.supportsErrorHandling());
        Assert.assertFalse((boolean)tableOutputMeta.supportsErrorHandling());
        tableOutputMeta.setDatabaseMeta(null);
        Assert.assertTrue((boolean)tableOutputMeta.supportsErrorHandling());
    }

    private Node getTestNode() throws KettleXMLException {
        String xml = "  <step>\n    <name>Table output</name>\n    <type>TableOutput</type>\n    <description/>\n    <distribute>Y</distribute>\n    <custom_distribution/>\n    <copies>1</copies>\n         <partitioning>\n           <method>none</method>\n           <schema_name/>\n           </partitioning>\n    <connection>local postgres</connection>\n    <schema>public</schema>\n    <table>sales_csv</table>\n    <commit>1000</commit>\n    <truncate>Y</truncate>\n    <ignore_errors>N</ignore_errors>\n    <use_batch>Y</use_batch>\n    <specify_fields>Y</specify_fields>\n    <partitioning_enabled>N</partitioning_enabled>\n    <partitioning_field/>\n    <partitioning_daily>N</partitioning_daily>\n    <partitioning_monthly>Y</partitioning_monthly>\n    <tablename_in_field>N</tablename_in_field>\n    <tablename_field/>\n    <tablename_in_table>Y</tablename_in_table>\n    <return_keys>N</return_keys>\n    <return_field/>\n    <fields>\n        <field>\n          <column_name>ORDERNUMBER</column_name>\n          <stream_name>ORDERNUMBER</stream_name>\n        </field>\n        <field>\n          <column_name>QUANTITYORDERED</column_name>\n          <stream_name>QUANTITYORDERED</stream_name>\n        </field>\n        <field>\n          <column_name>PRICEEACH</column_name>\n          <stream_name>PRICEEACH</stream_name>\n        </field>\n    </fields>\n     <cluster_schema/>\n <remotesteps>   <input>   </input>   <output>   </output> </remotesteps>    <GUI>\n      <xloc>368</xloc>\n      <yloc>64</yloc>\n      <draw>Y</draw>\n      </GUI>\n    </step>\n";
        return XMLHandler.loadXMLString((String)xml, (String)"step");
    }

    @Test
    public void metaSetTruncateTable() {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.metaSetTableNameDefinedInField("Y");
        Assert.assertTrue((boolean)tableOutputMeta.isTableNameInField());
        tableOutputMeta.metaSetTableNameDefinedInField("N");
        Assert.assertFalse((boolean)tableOutputMeta.isTableNameInField());
        tableOutputMeta.metaSetTableNameDefinedInField("Ynot");
        Assert.assertFalse((boolean)tableOutputMeta.isTableNameInField());
    }

    @Test
    public void metaSetSpecifyDatabaseFields() {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.metaSetSpecifyDatabaseFields("Y");
        Assert.assertTrue((boolean)tableOutputMeta.specifyFields());
        tableOutputMeta.metaSetSpecifyDatabaseFields("N");
        Assert.assertFalse((boolean)tableOutputMeta.specifyFields());
        tableOutputMeta.metaSetSpecifyDatabaseFields("Ynot");
        Assert.assertFalse((boolean)tableOutputMeta.specifyFields());
    }

    @Test
    public void metaSetIgnoreInsertErrors() {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.metaSetIgnoreInsertErrors("Y");
        Assert.assertTrue((boolean)tableOutputMeta.ignoreErrors());
        tableOutputMeta.metaSetIgnoreInsertErrors("N");
        Assert.assertFalse((boolean)tableOutputMeta.ignoreErrors());
        tableOutputMeta.metaSetIgnoreInsertErrors("Ynot");
        Assert.assertFalse((boolean)tableOutputMeta.ignoreErrors());
    }

    @Test
    public void metaSetUseBatchUpdate() {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.metaSetUseBatchUpdate("Y");
        Assert.assertTrue((boolean)tableOutputMeta.useBatchUpdate());
        tableOutputMeta.metaSetUseBatchUpdate("N");
        Assert.assertFalse((boolean)tableOutputMeta.useBatchUpdate());
        tableOutputMeta.metaSetUseBatchUpdate("Ynot");
        Assert.assertFalse((boolean)tableOutputMeta.useBatchUpdate());
    }

    @Test
    public void metaSetPartitionOverTables() {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.metaSetPartitionOverTables("Y");
        Assert.assertTrue((boolean)tableOutputMeta.isPartitioningEnabled());
        tableOutputMeta.metaSetPartitionOverTables("N");
        Assert.assertFalse((boolean)tableOutputMeta.isPartitioningEnabled());
        tableOutputMeta.metaSetPartitionOverTables("Ynot");
        Assert.assertFalse((boolean)tableOutputMeta.isPartitioningEnabled());
    }

    @Test
    public void metaSetTableNameDefinedInField() {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.metaSetTableNameDefinedInField("Y");
        Assert.assertTrue((boolean)tableOutputMeta.isTableNameInField());
        tableOutputMeta.metaSetTableNameDefinedInField("N");
        Assert.assertFalse((boolean)tableOutputMeta.isTableNameInField());
        tableOutputMeta.metaSetTableNameDefinedInField("Ynot");
        Assert.assertFalse((boolean)tableOutputMeta.isTableNameInField());
    }

    @Test
    public void metaSetReturningGeneratedKeys() {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        DatabaseMeta databaseMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        ((DatabaseMeta)Mockito.doReturn((Object)true).when((Object)databaseMeta)).supportsAutoGeneratedKeys();
        tableOutputMeta.setDatabaseMeta(databaseMeta);
        tableOutputMeta.metaSetReturningGeneratedKeys("Y");
        Assert.assertTrue((boolean)tableOutputMeta.isReturningGeneratedKeys());
        tableOutputMeta.metaSetReturningGeneratedKeys("N");
        Assert.assertFalse((boolean)tableOutputMeta.isReturningGeneratedKeys());
        tableOutputMeta.metaSetReturningGeneratedKeys("Ynot");
        Assert.assertFalse((boolean)tableOutputMeta.isReturningGeneratedKeys());
    }
}

