/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableinput;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.tableinput.TableInput;
import org.pentaho.di.trans.steps.tableinput.TableInputData;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.powermock.api.mockito.PowerMockito;

public class TableInputTest {
    TableInputMeta mockStepMetaInterface;
    TableInputData mockStepDataInterface;
    TableInput mockTableInput;

    @Before
    public void setUp() {
        StepMeta mockStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        TransMeta mockTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        Trans mockTrans = (Trans)Mockito.mock(Trans.class);
        StepPartitioningMeta mockStepPartitioningMeta = (StepPartitioningMeta)Mockito.mock(StepPartitioningMeta.class);
        Mockito.when((Object)mockStepMeta.getName()).thenReturn((Object)"MockStep");
        Mockito.when((Object)mockTransMeta.findStep(Matchers.anyString())).thenReturn((Object)mockStepMeta);
        Mockito.when((Object)mockStepMeta.getTargetStepPartitioningMeta()).thenReturn((Object)mockStepPartitioningMeta);
        this.mockStepMetaInterface = (TableInputMeta)Mockito.mock(TableInputMeta.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{StepMetaInterface.class}));
        this.mockStepDataInterface = (TableInputData)Mockito.mock(TableInputData.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{StepMetaInterface.class}));
        this.mockStepDataInterface.db = (Database)Mockito.mock(Database.class);
        this.mockTableInput = (TableInput)PowerMockito.spy((Object)new TableInput(mockStepMeta, (StepDataInterface)this.mockStepDataInterface, 1, mockTransMeta, mockTrans));
    }

    @Test
    public void testStopRunningWhenStepIsStopped() throws KettleException {
        ((TableInput)Mockito.doReturn((Object)true).when((Object)this.mockTableInput)).isStopped();
        this.mockTableInput.stopRunning((StepMetaInterface)this.mockStepMetaInterface, (StepDataInterface)this.mockStepDataInterface);
        ((TableInput)Mockito.verify((Object)this.mockTableInput, (VerificationMode)Mockito.times((int)1))).isStopped();
        ((TableInputData)Mockito.verify((Object)this.mockStepDataInterface, (VerificationMode)Mockito.times((int)0))).isDisposed();
    }

    @Test
    public void testStopRunningWhenStepDataInterfaceIsDisposed() throws KettleException {
        ((TableInput)Mockito.doReturn((Object)false).when((Object)this.mockTableInput)).isStopped();
        ((TableInputData)Mockito.doReturn((Object)true).when((Object)this.mockStepDataInterface)).isDisposed();
        this.mockTableInput.stopRunning((StepMetaInterface)this.mockStepMetaInterface, (StepDataInterface)this.mockStepDataInterface);
        ((TableInput)Mockito.verify((Object)this.mockTableInput, (VerificationMode)Mockito.times((int)1))).isStopped();
        ((TableInputData)Mockito.verify((Object)this.mockStepDataInterface, (VerificationMode)Mockito.times((int)1))).isDisposed();
    }

    @Test
    public void testStopRunningWhenStepIsNotStoppedNorStepDataInterfaceIsDisposedAndDatabaseConnectionIsValid() throws KettleException {
        ((TableInput)Mockito.doReturn((Object)false).when((Object)this.mockTableInput)).isStopped();
        ((TableInputData)Mockito.doReturn((Object)false).when((Object)this.mockStepDataInterface)).isDisposed();
        Mockito.when((Object)this.mockStepDataInterface.db.getConnection()).thenReturn(Mockito.mock(Connection.class));
        this.mockTableInput.stopRunning((StepMetaInterface)this.mockStepMetaInterface, (StepDataInterface)this.mockStepDataInterface);
        ((TableInput)Mockito.verify((Object)this.mockTableInput, (VerificationMode)Mockito.times((int)1))).isStopped();
        ((TableInputData)Mockito.verify((Object)this.mockStepDataInterface, (VerificationMode)Mockito.times((int)1))).isDisposed();
        ((Database)Mockito.verify((Object)this.mockStepDataInterface.db, (VerificationMode)Mockito.times((int)1))).getConnection();
        ((Database)Mockito.verify((Object)this.mockStepDataInterface.db, (VerificationMode)Mockito.times((int)1))).cancelQuery();
        TestCase.assertTrue((boolean)this.mockStepDataInterface.isCanceled);
    }

    @Test
    public void testStopRunningWhenStepIsNotStoppedNorStepDataInterfaceIsDisposedAndDatabaseConnectionIsNotValid() throws KettleException {
        ((TableInput)Mockito.doReturn((Object)false).when((Object)this.mockTableInput)).isStopped();
        ((TableInputData)Mockito.doReturn((Object)false).when((Object)this.mockStepDataInterface)).isDisposed();
        Mockito.when((Object)this.mockStepDataInterface.db.getConnection()).thenReturn(null);
        this.mockTableInput.stopRunning((StepMetaInterface)this.mockStepMetaInterface, (StepDataInterface)this.mockStepDataInterface);
        ((TableInput)Mockito.verify((Object)this.mockTableInput, (VerificationMode)Mockito.times((int)1))).isStopped();
        ((TableInputData)Mockito.verify((Object)this.mockStepDataInterface, (VerificationMode)Mockito.times((int)1))).isDisposed();
        ((Database)Mockito.verify((Object)this.mockStepDataInterface.db, (VerificationMode)Mockito.times((int)1))).getConnection();
        ((Database)Mockito.verify((Object)this.mockStepDataInterface.db, (VerificationMode)Mockito.times((int)0))).cancelStatement((Statement)Matchers.any(PreparedStatement.class));
        TestCase.assertFalse((boolean)this.mockStepDataInterface.isCanceled);
    }
}

