/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableinput;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;

public class TableInputMetaTest {
    LoadSaveTester loadSaveTester;
    Class<TableInputMeta> testMetaClass = TableInputMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("databaseMeta", "sQL", "rowLimit", "executeEachInputRow", "variableReplacementActive", "lazyConversionActive");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        HashMap<String, String> setterMap = new HashMap<String, String>();
        HashMap attrValidatorMap = new HashMap();
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<TableInputMeta>(this.testMetaClass, attributes, getterMap, setterMap, attrValidatorMap, typeValidatorMap);
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testGetFields() throws Exception {
        TableInputMetaHandler meta = new TableInputMetaHandler();
        meta.setLazyConversionActive(true);
        DatabaseMeta dbMeta = (DatabaseMeta)Mockito.mock(DatabaseMeta.class);
        meta.setDatabaseMeta(dbMeta);
        Database mockDB = meta.getDatabase();
        Mockito.when((Object)mockDB.getQueryFields(Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)this.createMockFields());
        RowMeta expectedRowMeta = new RowMeta();
        ValueMetaString valueMeta = new ValueMetaString("field1");
        valueMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString("field1"));
        valueMeta.setStorageType(1);
        expectedRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        VariableSpace space = (VariableSpace)Mockito.mock(VariableSpace.class);
        RowMeta rowMetaInterface = new RowMeta();
        meta.getFields((RowMetaInterface)rowMetaInterface, "TABLE_INPUT_META", null, null, space, null, null);
        Assert.assertEquals((Object)expectedRowMeta.toString(), (Object)rowMetaInterface.toString());
    }

    private RowMetaInterface createMockFields() {
        RowMeta rowMetaInterface = new RowMeta();
        ValueMetaString valueMeta = new ValueMetaString("field1");
        rowMetaInterface.addValueMeta((ValueMetaInterface)valueMeta);
        return rowMetaInterface;
    }

    public class TableInputMetaHandler
    extends TableInputMeta {
        public Database database = (Database)Mockito.mock(Database.class);

        protected Database getDatabase() {
            return this.database;
        }
    }
}

