/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.systemdata;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.systemdata.SystemData;
import org.pentaho.di.trans.steps.systemdata.SystemDataData;
import org.pentaho.di.trans.steps.systemdata.SystemDataMeta;
import org.pentaho.di.trans.steps.systemdata.SystemDataTypes;

public class SystemDataTest {
    private StepMockHelper<SystemDataMeta, SystemDataData> stepMockHelper;

    @Before
    public void setUp() throws Exception {
        this.stepMockHelper = new StepMockHelper<SystemDataMeta, SystemDataData>("SYSTEM_DATA TEST", SystemDataMeta.class, SystemDataData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)this.stepMockHelper.trans.isRunning()).thenReturn((Object)true);
        ((Trans)Mockito.verify((Object)this.stepMockHelper.trans, (VerificationMode)Mockito.never())).stopAll();
    }

    @After
    public void tearDown() throws Exception {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void testProcessRow() throws Exception {
        SystemDataData systemDataData = new SystemDataData();
        SystemDataMeta systemDataMeta = new SystemDataMeta();
        systemDataMeta.allocate(2);
        String[] names = systemDataMeta.getFieldName();
        SystemDataTypes[] types = systemDataMeta.getFieldType();
        names[0] = "hostname";
        names[1] = "hostname_real";
        types[0] = SystemDataTypes.getTypeFromString((String)SystemDataTypes.TYPE_SYSTEM_INFO_HOSTNAME.getDescription());
        types[1] = SystemDataTypes.getTypeFromString((String)SystemDataTypes.TYPE_SYSTEM_INFO_HOSTNAME_REAL.getDescription());
        SystemDataHandler systemData = new SystemDataHandler(this.stepMockHelper.stepMeta, (StepDataInterface)this.stepMockHelper.stepDataInterface, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans);
        Object[] expectedRow = new Object[]{Const.getHostname(), Const.getHostnameReal()};
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)inputRowMeta.clone()).thenReturn((Object)inputRowMeta);
        Mockito.when((Object)inputRowMeta.size()).thenReturn((Object)2);
        systemDataData.outputRowMeta = inputRowMeta;
        systemData.init((StepMetaInterface)systemDataMeta, (StepDataInterface)systemDataData);
        Assert.assertFalse((boolean)systemData.processRow((StepMetaInterface)systemDataMeta, (StepDataInterface)systemDataData));
        Object[] out = systemData.getOutputRow();
        Assert.assertArrayEquals((Object[])expectedRow, (Object[])out);
    }

    private class SystemDataHandler
    extends SystemData {
        Object[] row;
        Object[] outputRow;

        public SystemDataHandler(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
            this.row = new Object[]{"anyData"};
        }

        public void setRow(Object[] row) {
            this.row = row;
        }

        public Object[] getRow() throws KettleException {
            return this.row;
        }

        public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            this.outputRow = row;
        }

        public Object[] getOutputRow() {
            return this.outputRow;
        }
    }
}

