/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.systemdata;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.systemdata.SystemDataMeta;
import org.pentaho.di.trans.steps.systemdata.SystemDataTypes;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SystemDataMetaTest
implements InitializerInterface<StepMetaInterface> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester loadSaveTester;
    Class<SystemDataMeta> testMetaClass = SystemDataMeta.class;
    SystemDataMeta expectedSystemDataMeta;
    String expectedXML = "    <fields>\n      <field>\n        <name>hostname_real</name>\n        <type>Hostname real</type>\n        </field>\n      <field>\n        <name>hostname</name>\n        <type>Hostname</type>\n        </field>\n      </fields>\n";

    @Before
    public void setUp() throws Exception {
        this.expectedSystemDataMeta = new SystemDataMeta();
        this.expectedSystemDataMeta.allocate(2);
        String[] names = this.expectedSystemDataMeta.getFieldName();
        SystemDataTypes[] types = this.expectedSystemDataMeta.getFieldType();
        names[0] = "hostname_real";
        names[1] = "hostname";
        types[0] = SystemDataTypes.getTypeFromString((String)SystemDataTypes.TYPE_SYSTEM_INFO_HOSTNAME_REAL.getDescription());
        types[1] = SystemDataTypes.getTypeFromString((String)SystemDataTypes.TYPE_SYSTEM_INFO_HOSTNAME.getDescription());
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLoadXML() throws Exception {
        Document document;
        SystemDataMeta systemDataMeta = new SystemDataMeta();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document node = document = documentBuilder.parse(new InputSource(new StringReader(this.expectedXML)));
        IMetaStore store = null;
        systemDataMeta.loadXML((Node)node, null, store);
        Assert.assertEquals((Object)this.expectedSystemDataMeta, (Object)systemDataMeta);
    }

    @Test
    public void testGetXML() throws Exception {
        String generatedXML = this.expectedSystemDataMeta.getXML();
        Assert.assertEquals((Object)this.expectedXML.replaceAll("\n", "").replaceAll("\r", ""), (Object)generatedXML.replaceAll("\n", "").replaceAll("\r", ""));
    }

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("fieldName", "fieldType");
        HashMap<String, String> getterMap = new HashMap<String, String>(){
            {
                this.put("fieldName", "getFieldName");
                this.put("fieldType", "getFieldType");
            }
        };
        HashMap<String, String> setterMap = new HashMap<String, String>(){
            {
                this.put("fieldName", "setFieldName");
                this.put("fieldType", "setFieldType");
            }
        };
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        ArrayLoadSaveValidator<SystemDataTypes> sdtArrayLoadSaveValidator = new ArrayLoadSaveValidator<SystemDataTypes>(new SystemDataTypesLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("fieldName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldType", sdtArrayLoadSaveValidator);
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), (Map<String, String>)getterMap, (Map<String, String>)setterMap, attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof SystemDataMeta) {
            ((SystemDataMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    public class SystemDataTypesLoadSaveValidator
    implements FieldLoadSaveValidator<SystemDataTypes> {
        final Random rand = new Random();

        @Override
        public SystemDataTypes getTestObject() {
            SystemDataTypes[] allTypes = SystemDataTypes.values();
            return allTypes[this.rand.nextInt(allTypes.length)];
        }

        @Override
        public boolean validateTestObject(SystemDataTypes testObject, Object actual) {
            if (!(actual instanceof SystemDataTypes)) {
                return false;
            }
            SystemDataTypes actualInput = (SystemDataTypes)actual;
            return testObject.toString().equals(actualInput.toString());
        }
    }
}

