/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.syslog;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.syslog.SyslogMessage;
import org.pentaho.di.trans.steps.syslog.SyslogMessageData;
import org.pentaho.di.trans.steps.syslog.SyslogMessageMeta;

public class SyslogMessageConcurrentTest {
    AtomicInteger numOfErrors = null;
    CountDownLatch countDownLatch = null;
    private String testMessage = "message value";
    int numOfTasks = 5;
    private StepMockHelper<SyslogMessageMeta, SyslogMessageData> stepMockHelper;

    @Before
    public void setUp() throws Exception {
        this.numOfErrors = new AtomicInteger(0);
        this.countDownLatch = new CountDownLatch(1);
        this.stepMockHelper = new StepMockHelper<SyslogMessageMeta, SyslogMessageData>("SYSLOG_MESSAGE TEST", SyslogMessageMeta.class, SyslogMessageData.class);
        Mockito.when((Object)this.stepMockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.stepMockHelper.logChannelInterface);
        Mockito.when((Object)((SyslogMessageMeta)this.stepMockHelper.processRowsStepMetaInterface).getServerName()).thenReturn((Object)"localhost");
        Mockito.when((Object)((SyslogMessageMeta)this.stepMockHelper.processRowsStepMetaInterface).getMessageFieldName()).thenReturn((Object)"message field");
        Mockito.when((Object)((SyslogMessageMeta)this.stepMockHelper.processRowsStepMetaInterface).getPort()).thenReturn((Object)"9988");
        Mockito.when((Object)((SyslogMessageMeta)this.stepMockHelper.processRowsStepMetaInterface).getPriority()).thenReturn((Object)"ERROR");
    }

    @After
    public void cleanUp() {
        this.stepMockHelper.cleanUp();
    }

    @Test
    public void concurrentSyslogMessageTest() throws Exception {
        SyslogMessageTask syslogMessage = null;
        ExecutorService service = Executors.newFixedThreadPool(this.numOfTasks);
        for (int i = 0; i < this.numOfTasks; ++i) {
            syslogMessage = this.createSyslogMessageTask();
            service.execute(syslogMessage);
        }
        service.shutdown();
        this.countDownLatch.countDown();
        service.awaitTermination(10000L, TimeUnit.NANOSECONDS);
        Assert.assertTrue((this.numOfErrors.get() == 0 ? 1 : 0) != 0);
    }

    private SyslogMessageTask createSyslogMessageTask() throws Exception {
        SyslogMessageData data = new SyslogMessageData();
        RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
        Mockito.when((Object)inputRowMeta.indexOfValue((String)Matchers.any())).thenReturn((Object)0);
        Mockito.when((Object)inputRowMeta.getString((Object[])Matchers.any(), Matchers.eq((int)0))).thenReturn((Object)this.testMessage);
        SyslogMessageTask syslogMessage = new SyslogMessageTask(this.stepMockHelper.stepMeta, (StepDataInterface)data, 0, this.stepMockHelper.transMeta, this.stepMockHelper.trans, (SyslogMessageMeta)this.stepMockHelper.processRowsStepMetaInterface);
        syslogMessage.init((StepMetaInterface)this.stepMockHelper.processRowsStepMetaInterface, (StepDataInterface)data);
        syslogMessage.setInputRowMeta(inputRowMeta);
        return syslogMessage;
    }

    private class SyslogMessageTask
    extends SyslogMessage
    implements Runnable {
        SyslogMessageMeta syslogMessageMeta;

        public SyslogMessageTask(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans, SyslogMessageMeta processRowsStepMetaInterface) {
            super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
            this.syslogMessageMeta = null;
            this.syslogMessageMeta = processRowsStepMetaInterface;
        }

        @Override
        public void run() {
            try {
                SyslogMessageConcurrentTest.this.countDownLatch.await();
                this.processRow((StepMetaInterface)this.syslogMessageMeta, this.getStepDataInterface());
            }
            catch (Exception e) {
                e.printStackTrace();
                SyslogMessageConcurrentTest.this.numOfErrors.getAndIncrement();
            }
            finally {
                try {
                    this.dispose((StepMetaInterface)this.syslogMessageMeta, this.getStepDataInterface());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    SyslogMessageConcurrentTest.this.numOfErrors.getAndIncrement();
                }
            }
        }

        public void putRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            Assert.assertNotNull((Object)row);
            Assert.assertTrue((row.length == 1 ? 1 : 0) != 0);
            Assert.assertEquals((Object)SyslogMessageConcurrentTest.this.testMessage, (Object)row[0]);
        }

        public Object[] getRow() throws KettleException {
            return new Object[]{SyslogMessageConcurrentTest.this.testMessage};
        }
    }
}

