/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.switchcase;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.switchcase.KeyToRowSetMap;
import org.pentaho.di.trans.steps.switchcase.SwitchCase;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseData;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseMeta;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseTarget;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SwitchCaseTest {
    private StepMockHelper<SwitchCaseMeta, SwitchCaseData> mockHelper;
    private static Boolean EMPTY_STRING_AND_NULL_ARE_DIFFERENT = false;

    @Before
    public void setUp() throws Exception {
        this.mockHelper = new StepMockHelper<SwitchCaseMeta, SwitchCaseData>("Switch Case", SwitchCaseMeta.class, SwitchCaseData.class);
        Mockito.when((Object)this.mockHelper.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.mockHelper.logChannelInterface);
        Mockito.when((Object)this.mockHelper.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void tearDown() throws Exception {
        this.mockHelper.cleanUp();
    }

    @Test
    public void testProcessRow() throws KettleException {
        SwitchCaseCustom krasavez = new SwitchCaseCustom(this.mockHelper);
        krasavez.first = false;
        QueueRowSet rowSetOne = new QueueRowSet();
        QueueRowSet rowSetTwo = new QueueRowSet();
        krasavez.data.outputMap.put((Object)3, (RowSet)rowSetOne);
        krasavez.data.outputMap.put((Object)3, (RowSet)rowSetTwo);
        QueueRowSet rowSetNullOne = new QueueRowSet();
        QueueRowSet rowSetNullTwo = new QueueRowSet();
        krasavez.data.nullRowSetSet.add(rowSetNullOne);
        krasavez.data.nullRowSetSet.add(rowSetNullTwo);
        QueueRowSet def = new QueueRowSet();
        krasavez.data.defaultRowSetSet.add(def);
        krasavez.generateData(1, 5, 2);
        krasavez.processRow();
        Assert.assertEquals((String)"First row set collects 2 rows", (long)2L, (long)rowSetOne.size());
        Assert.assertEquals((String)"Second row set collects 2 rows", (long)2L, (long)rowSetTwo.size());
        Assert.assertEquals((String)"First null row set collects 5 rows", (long)6L, (long)rowSetNullOne.size());
        Assert.assertEquals((String)"Second null row set collects 5 rows", (long)6L, (long)rowSetNullTwo.size());
        Assert.assertEquals((String)"Default row set collects the rest of rows", (long)8L, (long)def.size());
        Assert.assertEquals((String)"First row set contains only 3: ", (Object)true, (Object)this.isRowSetContainsValue((RowSet)rowSetOne, new Object[]{3}, new Object[0]));
        Assert.assertEquals((String)"Second row set contains only 3: ", (Object)true, (Object)this.isRowSetContainsValue((RowSet)rowSetTwo, new Object[]{3}, new Object[0]));
        Assert.assertEquals((String)"First null row set contains only null: ", (Object)true, (Object)this.isRowSetContainsValue((RowSet)rowSetNullOne, new Object[]{null}, new Object[0]));
        Assert.assertEquals((String)"Second null row set contains only null: ", (Object)true, (Object)this.isRowSetContainsValue((RowSet)rowSetNullTwo, new Object[]{null}, new Object[0]));
        Assert.assertEquals((String)"Default row set do not contains null or 3, but other", (Object)true, (Object)this.isRowSetContainsValue((RowSet)def, new Object[]{1, 2, 4, 5}, new Object[]{3, null}));
    }

    private boolean isRowSetContainsValue(RowSet rowSet, Object[] allowed, Object[] illegal) {
        boolean ok = true;
        HashSet<Object> yes = new HashSet<Object>();
        yes.addAll(Arrays.asList(allowed));
        HashSet<Object> no = new HashSet<Object>();
        no.addAll(Arrays.asList(illegal));
        for (int i = 0; i < rowSet.size(); ++i) {
            Object[] row = rowSet.getRow();
            Object val = row[0];
            boolean bl = ok = yes.contains(val) && !no.contains(val);
            if (ok) continue;
            return false;
        }
        return ok;
    }

    @Test
    public void testCreateOutputValueMapping() throws KettleException, URISyntaxException, ParserConfigurationException, SAXException, IOException {
        SwitchCaseCustom krasavez = new SwitchCaseCustom(this.mockHelper);
        ArrayList emptyList = new ArrayList();
        krasavez.meta.loadXML(SwitchCaseTest.loadStepXmlMetadata("SwitchCaseTest.xml"), emptyList, (IMetaStore)Mockito.mock(IMetaStore.class));
        KeyToRowSetMap expectedNN = new KeyToRowSetMap();
        HashSet<QueueRowSet> nulls = new HashSet<QueueRowSet>();
        List list = krasavez.meta.getCaseTargets();
        for (SwitchCaseTarget item : list) {
            StepMeta stepMeta;
            DummyTransMeta smInt = new DummyTransMeta();
            item.caseTargetStep = stepMeta = new StepMeta(item.caseTargetStepname, (StepMetaInterface)smInt);
            QueueRowSet rw = new QueueRowSet();
            krasavez.map.put(item.caseTargetStepname, (RowSet)rw);
            if (item.caseValue != null) {
                expectedNN.put((Object)item.caseValue, (RowSet)rw);
                continue;
            }
            nulls.add(rw);
        }
        DummyTransMeta smInt = new DummyTransMeta();
        StepMeta stepMeta = new StepMeta(krasavez.meta.getDefaultTargetStepname(), (StepMetaInterface)smInt);
        krasavez.meta.setDefaultTargetStep(stepMeta);
        QueueRowSet rw = new QueueRowSet();
        krasavez.map.put(krasavez.meta.getDefaultTargetStepname(), (RowSet)rw);
        krasavez.createOutputValueMapping();
        Set ones = krasavez.data.outputMap.get((Object)"1");
        Assert.assertEquals((String)"Output map for 1 values contains 2 row sets", (long)2L, (long)ones.size());
        Set twos = krasavez.data.outputMap.get((Object)"2");
        Assert.assertEquals((String)"Output map for 2 values contains 1 row sets", (long)1L, (long)twos.size());
        Assert.assertEquals((String)"Null row set contains 2 items: ", (long)2L, (long)krasavez.data.nullRowSetSet.size());
        Assert.assertEquals((String)"We have at least one default rowset", (long)1L, (long)krasavez.data.defaultRowSetSet.size());
        Set rowsets = expectedNN.get((Object)"1");
        for (RowSet rowset : rowsets) {
            Assert.assertTrue((String)"Output map for 1 values contains expected row set", (boolean)ones.contains(rowset));
        }
        rowsets = expectedNN.get((Object)"2");
        for (RowSet rowset : rowsets) {
            Assert.assertTrue((String)"Output map for 2 values contains expected row set", (boolean)twos.contains(rowset));
        }
        for (RowSet rowset : krasavez.data.nullRowSetSet) {
            Assert.assertTrue((String)"Output map for null values contains expected row set", (boolean)nulls.contains(rowset));
        }
        for (RowSet rowset : krasavez.data.defaultRowSetSet) {
            Assert.assertTrue((String)"Output map for default case contains expected row set", (boolean)rowset.equals(rw));
        }
    }

    @Test
    public void testCreateOutputValueMappingWithBinaryType() throws KettleException, URISyntaxException, ParserConfigurationException, SAXException, IOException {
        SwitchCaseCustom krasavez = new SwitchCaseCustom(this.mockHelper);
        ArrayList emptyList = new ArrayList();
        krasavez.meta.loadXML(SwitchCaseTest.loadStepXmlMetadata("SwitchCaseBinaryTest.xml"), emptyList, (IMetaStore)Mockito.mock(IMetaStore.class));
        KeyToRowSetMap expectedNN = new KeyToRowSetMap();
        HashSet<QueueRowSet> nulls = new HashSet<QueueRowSet>();
        List list = krasavez.meta.getCaseTargets();
        for (SwitchCaseTarget item : list) {
            StepMeta stepMeta;
            DummyTransMeta smInt = new DummyTransMeta();
            item.caseTargetStep = stepMeta = new StepMeta(item.caseTargetStepname, (StepMetaInterface)smInt);
            QueueRowSet rw = new QueueRowSet();
            krasavez.map.put(item.caseTargetStepname, (RowSet)rw);
            if (item.caseValue != null) {
                expectedNN.put((Object)item.caseValue, (RowSet)rw);
                continue;
            }
            nulls.add(rw);
        }
        DummyTransMeta smInt = new DummyTransMeta();
        StepMeta stepMeta = new StepMeta(krasavez.meta.getDefaultTargetStepname(), (StepMetaInterface)smInt);
        krasavez.meta.setDefaultTargetStep(stepMeta);
        QueueRowSet rw = new QueueRowSet();
        krasavez.map.put(krasavez.meta.getDefaultTargetStepname(), (RowSet)rw);
        krasavez.createOutputValueMapping();
        Set ones = krasavez.data.outputMap.get((Object)"1");
        Assert.assertEquals((String)"Output map for 1 values contains 2 row sets", (long)2L, (long)ones.size());
        Set zeros = krasavez.data.outputMap.get((Object)"0");
        Assert.assertEquals((String)"Output map for 0 values contains 1 row sets", (long)1L, (long)zeros.size());
        Assert.assertEquals((String)"Null row set contains 0 items: ", (long)2L, (long)krasavez.data.nullRowSetSet.size());
        Assert.assertEquals((String)"We have at least one default rowset", (long)1L, (long)krasavez.data.defaultRowSetSet.size());
        Set rowsets = expectedNN.get((Object)"1");
        for (RowSet rowset : rowsets) {
            Assert.assertTrue((String)"Output map for 1 values contains expected row set", (boolean)ones.contains(rowset));
        }
        rowsets = expectedNN.get((Object)"0");
        for (RowSet rowset : rowsets) {
            Assert.assertTrue((String)"Output map for 0 values contains expected row set", (boolean)zeros.contains(rowset));
        }
        for (RowSet rowset : krasavez.data.nullRowSetSet) {
            Assert.assertTrue((String)"Output map for null values contains expected row set", (boolean)nulls.contains(rowset));
        }
        for (RowSet rowset : krasavez.data.defaultRowSetSet) {
            Assert.assertTrue((String)"Output map for default case contains expected row set", (boolean)rowset.equals(rw));
        }
    }

    private static Node loadStepXmlMetadata(String fileName) throws URISyntaxException, ParserConfigurationException, SAXException, IOException {
        String PKG = SwitchCaseTest.class.getPackage().getName().replace(".", "/");
        PKG = PKG + "/";
        URL url = SwitchCaseTest.class.getClassLoader().getResource(PKG + fileName);
        File file = new File(url.toURI());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(file);
        NodeList nList = doc.getElementsByTagName("step");
        return nList.item(0);
    }

    @Test
    public void processRow_NullsArePutIntoDefaultWhenNotSpecified() throws Exception {
        SwitchCaseCustom step = new SwitchCaseCustom(this.mockHelper);
        step.meta.loadXML(SwitchCaseTest.loadStepXmlMetadata("SwitchCaseTest_PDI-12671.xml"), Collections.emptyList(), (IMetaStore)Mockito.mock(IMetaStore.class));
        LinkedList<QueueRowSet> outputRowSets = new LinkedList<QueueRowSet>();
        for (SwitchCaseTarget item : step.meta.getCaseTargets()) {
            DummyTransMeta smInt = new DummyTransMeta();
            item.caseTargetStep = new StepMeta(item.caseTargetStepname, (StepMetaInterface)smInt);
            QueueRowSet rw = new QueueRowSet();
            step.map.put(item.caseTargetStepname, (RowSet)rw);
            outputRowSets.add(rw);
        }
        DummyTransMeta smInt = new DummyTransMeta();
        StepMeta stepMeta = new StepMeta(step.meta.getDefaultTargetStepname(), (StepMetaInterface)smInt);
        step.meta.setDefaultTargetStep(stepMeta);
        QueueRowSet defaultRowSet = new QueueRowSet();
        step.map.put(step.meta.getDefaultTargetStepname(), (RowSet)defaultRowSet);
        step.input.add(new Object[]{null});
        step.processRow();
        Assert.assertEquals((long)1L, (long)defaultRowSet.size());
        for (RowSet rowSet : outputRowSets) {
            Assert.assertEquals((long)0L, (long)rowSet.size());
        }
        Assert.assertNull((Object)defaultRowSet.getRow()[0]);
    }

    @Test
    public void prepareObjectTypeBinaryTest_Equals() throws Exception {
        Assert.assertEquals((Object)Arrays.hashCode(new byte[]{1, 2, 3}), (Object)SwitchCase.prepareObjectType((Object)new byte[]{1, 2, 3}));
    }

    @Test
    public void prepareObjectTypeBinaryTest_NotEquals() throws Exception {
        Assert.assertNotEquals((Object)Arrays.hashCode(new byte[]{1, 2, 4}), (Object)SwitchCase.prepareObjectType((Object)new byte[]{1, 2, 3}));
    }

    @Test
    public void prepareObjectTypeBinaryTest_Null() throws Exception {
        Object given = null;
        Object expected = null;
        Assert.assertEquals(expected, (Object)SwitchCase.prepareObjectType(given));
    }

    @Test
    public void prepareObjectTypeTest_Equals() throws Exception {
        Assert.assertEquals((Object)"2", (Object)SwitchCase.prepareObjectType((Object)"2"));
    }

    @Test
    public void prepareObjectTypeTest_NotEquals() throws Exception {
        Assert.assertNotEquals((Object)"2", (Object)SwitchCase.prepareObjectType((Object)"1"));
    }

    @Test
    public void prepareObjectTypeTest_Null() throws Exception {
        Assert.assertEquals(null, (Object)SwitchCase.prepareObjectType(null));
    }

    private static class SwitchCaseCustom
    extends SwitchCase {
        Queue<Object[]> input = new LinkedList<Object[]>();
        RowMetaInterface rowMetaInterface;
        SwitchCaseData data = new SwitchCaseData();
        SwitchCaseMeta meta = new SwitchCaseMeta();
        Map<String, RowSet> map = new HashMap<String, RowSet>();

        SwitchCaseCustom(StepMockHelper<SwitchCaseMeta, SwitchCaseData> mockHelper) throws KettleValueException {
            super(mockHelper.stepMeta, mockHelper.stepDataInterface, 0, mockHelper.transMeta, mockHelper.trans);
            this.init((StepMetaInterface)this.meta, (StepDataInterface)this.data);
            this.data.valueMeta = (ValueMetaInterface)Mockito.mock(ValueMetaInterface.class);
            Mockito.when((Object)this.data.valueMeta.convertData((ValueMetaInterface)Matchers.any(ValueMetaInterface.class), Matchers.any())).thenAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    Object[] objArr = invocation.getArguments();
                    return objArr != null && objArr.length > 1 ? objArr[1] : null;
                }
            });
            Mockito.when((Object)this.data.valueMeta.convertDataFromString(Mockito.anyString(), (ValueMetaInterface)Matchers.any(ValueMetaInterface.class), Mockito.anyString(), Mockito.anyString(), Mockito.anyInt())).thenAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    Object[] objArr = invocation.getArguments();
                    return objArr != null && objArr.length > 1 ? objArr[0] : null;
                }
            });
            Mockito.when((Object)this.data.valueMeta.isNull(Matchers.any())).thenAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    Object[] objArr = invocation.getArguments();
                    Object obj = objArr[0];
                    if (obj == null) {
                        return true;
                    }
                    if (EMPTY_STRING_AND_NULL_ARE_DIFFERENT.booleanValue()) {
                        return false;
                    }
                    if (obj instanceof String && ((String)obj).length() == 0) {
                        return true;
                    }
                    return false;
                }
            });
        }

        void generateData(int start, int finish, int copy) {
            this.input.clear();
            for (int i = start; i <= finish; ++i) {
                for (int j = 0; j < copy; ++j) {
                    this.input.add(new Object[]{i});
                }
                this.input.add(new Object[]{null});
            }
            this.input.add(new Object[]{""});
        }

        public String getInputDataOverview() {
            StringBuilder sb = new StringBuilder();
            for (Object[] row : this.input) {
                sb.append(row[0] + ", ");
            }
            return sb.toString();
        }

        public Object[] getRow() throws KettleException {
            return this.input.poll();
        }

        public void processRow() throws KettleException {
            boolean run = false;
            while (run = this.processRow((StepMetaInterface)this.meta, (StepDataInterface)this.data)) {
            }
        }

        public RowSet findOutputRowSet(String targetStep) throws KettleStepException {
            return this.map.get(targetStep);
        }

        public RowMetaInterface getInputRowMeta() {
            if (this.rowMetaInterface == null) {
                this.rowMetaInterface = this.getDynamicRowMetaInterface();
            }
            return this.rowMetaInterface;
        }

        private RowMetaInterface getDynamicRowMetaInterface() {
            RowMetaInterface inputRowMeta = (RowMetaInterface)Mockito.mock(RowMetaInterface.class);
            return inputRowMeta;
        }
    }
}

