/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.switchcase;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.ClassRule;
import org.junit.Test;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.FieldLoadSaveValidatorFactory;
import org.pentaho.di.trans.steps.loadsave.validator.ListLoadSaveValidator;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseMeta;
import org.pentaho.di.trans.steps.switchcase.SwitchCaseTarget;

public class SwitchCaseMetaTest {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();
    LoadSaveTester<SwitchCaseMeta> loadSaveTester;

    public SwitchCaseMetaTest() {
        List<String> attributes = Arrays.asList("fieldname", "isContains", "caseValueFormat", "caseValueDecimal", "caseValueGroup", "defaultTargetStepname", "caseTargets");
        HashMap<String, String> getterMap = new HashMap<String, String>();
        getterMap.put("isContains", "isContains");
        HashMap<String, String> setterMap = new HashMap<String, String>();
        setterMap.put("isContains", "setContains");
        HashMap attrValidatorMap = new HashMap();
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<SwitchCaseMeta>(SwitchCaseMeta.class, attributes, getterMap, setterMap, attrValidatorMap, typeValidatorMap);
        FieldLoadSaveValidatorFactory validatorFactory = this.loadSaveTester.getFieldLoadSaveValidatorFactory();
        FieldLoadSaveValidator<SwitchCaseTarget> targetValidator = new FieldLoadSaveValidator<SwitchCaseTarget>(){
            private final StepMetaInterface targetStepInterface = new DummyTransMeta();

            @Override
            public SwitchCaseTarget getTestObject() {
                return new SwitchCaseTarget(){
                    {
                        this.caseValue = UUID.randomUUID().toString();
                        this.caseTargetStepname = UUID.randomUUID().toString();
                        this.caseTargetStep = new StepMeta(this.caseTargetStepname, targetStepInterface);
                    }
                };
            }

            @Override
            public boolean validateTestObject(SwitchCaseTarget testObject, Object actual) {
                return testObject.caseValue.equals(((SwitchCaseTarget)actual).caseValue) && testObject.caseTargetStepname.equals(((SwitchCaseTarget)actual).caseTargetStepname);
            }
        };
        validatorFactory.registerValidator(validatorFactory.getName((Type)((Object)SwitchCaseTarget.class)), targetValidator);
        validatorFactory.registerValidator(validatorFactory.getName(List.class, SwitchCaseTarget.class), new ListLoadSaveValidator<SwitchCaseTarget>(targetValidator));
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testsearchInfoAndTargetStepsTwice() {
        DummyTransMeta defStep = new DummyTransMeta();
        StepMeta stepMeta = new StepMeta("id", "default", (StepMetaInterface)defStep);
        SwitchCaseMeta meta = new SwitchCaseMeta();
        meta.allocate();
        meta.setDefaultTargetStepname(stepMeta.getName());
        meta.searchInfoAndTargetSteps(Collections.singletonList(stepMeta));
        meta.searchInfoAndTargetSteps(Collections.singletonList(stepMeta));
    }
}

