/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stringoperations;

import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.stringoperations.StringOperations;
import org.pentaho.di.trans.steps.stringoperations.StringOperationsData;
import org.pentaho.di.trans.steps.stringoperations.StringOperationsMeta;

public class StringOperationsTest {
    private static StepMockHelper<StringOperationsMeta, StringOperationsData> smh;

    @Before
    public void setup() {
        smh = new StepMockHelper<StringOperationsMeta, StringOperationsData>("StringOperations", StringOperationsMeta.class, StringOperationsData.class);
        Mockito.when((Object)StringOperationsTest.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)StringOperationsTest.smh.logChannelInterface);
        Mockito.when((Object)StringOperationsTest.smh.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void cleanUp() {
        smh.cleanUp();
    }

    private RowSet mockInputRowSet() {
        ValueMetaString valueMeta = new ValueMetaString("Value");
        valueMeta.setStorageType(1);
        valueMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString("Value"));
        RowMeta inputRowMeta = new RowMeta();
        inputRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        RowSet inputRowSet = smh.getMockInputRowSet(new Object[][]{{" Value ".getBytes()}});
        ((RowSet)Mockito.doReturn((Object)inputRowMeta).when((Object)inputRowSet)).getRowMeta();
        return inputRowSet;
    }

    private StringOperationsMeta mockStepMeta() {
        StringOperationsMeta meta = (StringOperationsMeta)Mockito.mock(StringOperationsMeta.class);
        ((StringOperationsMeta)Mockito.doReturn((Object)new String[]{"Value"}).when((Object)meta)).getFieldInStream();
        ((StringOperationsMeta)Mockito.doReturn((Object)new String[]{""}).when((Object)meta)).getFieldOutStream();
        ((StringOperationsMeta)Mockito.doReturn((Object)new int[]{3}).when((Object)meta)).getTrimType();
        ((StringOperationsMeta)Mockito.doReturn((Object)new int[]{0}).when((Object)meta)).getLowerUpper();
        ((StringOperationsMeta)Mockito.doReturn((Object)new int[]{0}).when((Object)meta)).getPaddingType();
        ((StringOperationsMeta)Mockito.doReturn((Object)new String[]{""}).when((Object)meta)).getPadChar();
        ((StringOperationsMeta)Mockito.doReturn((Object)new String[]{""}).when((Object)meta)).getPadLen();
        ((StringOperationsMeta)Mockito.doReturn((Object)new int[]{0}).when((Object)meta)).getInitCap();
        ((StringOperationsMeta)Mockito.doReturn((Object)new int[]{0}).when((Object)meta)).getMaskXML();
        ((StringOperationsMeta)Mockito.doReturn((Object)new int[]{0}).when((Object)meta)).getDigits();
        ((StringOperationsMeta)Mockito.doReturn((Object)new int[]{0}).when((Object)meta)).getRemoveSpecialCharacters();
        return meta;
    }

    private StringOperationsData mockStepData() {
        return (StringOperationsData)Mockito.mock(StringOperationsData.class);
    }

    private boolean verifyOutput(Object[][] expectedRows, RowSet outputRowSet) throws KettleValueException {
        if (expectedRows.length == outputRowSet.size()) {
            for (Object[] expectedRow : expectedRows) {
                Object[] row = outputRowSet.getRow();
                if (expectedRow.length != outputRowSet.getRowMeta().size()) continue;
                for (int j = 0; j < expectedRow.length; ++j) {
                    if (expectedRow[j].equals(outputRowSet.getRowMeta().getString(row, j))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Test
    public void testProcessBinaryInput() throws KettleException {
        boolean processResult;
        StringOperations step = new StringOperations(StringOperationsTest.smh.stepMeta, StringOperationsTest.smh.stepDataInterface, 0, StringOperationsTest.smh.transMeta, StringOperationsTest.smh.trans);
        step.addRowSetToInputRowSets(this.mockInputRowSet());
        QueueRowSet outputRowSet = new QueueRowSet();
        step.addRowSetToOutputRowSets((RowSet)outputRowSet);
        StringOperationsMeta meta = this.mockStepMeta();
        StringOperationsData data = this.mockStepData();
        step.init((StepMetaInterface)meta, (StepDataInterface)data);
        while (processResult = step.processRow((StepMetaInterface)meta, (StepDataInterface)data)) {
        }
        Assert.assertTrue((boolean)outputRowSet.isDone());
        Assert.assertTrue((String)"Unexpected output", (boolean)this.verifyOutput(new Object[][]{{"Value"}}, (RowSet)outputRowSet));
    }
}

