/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stringoperations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.stringoperations.StringOperationsMeta;

public class StringOperationsMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<StringOperationsMeta> testMetaClass = StringOperationsMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("padLen", "padChar", "fieldInStream", "fieldOutStream", "trimType", "lowerUpper", "initCap", "maskXML", "digits", "removeSpecialCharacters", "paddingType");
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("padLen", stringArrayLoadSaveValidator);
        attrValidatorMap.put("padChar", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldInStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("fieldOutStream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("trimType", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(4), 5));
        attrValidatorMap.put("lowerUpper", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(StringOperationsMeta.lowerUpperCode.length), 5));
        attrValidatorMap.put("initCap", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(StringOperationsMeta.initCapCode.length), 5));
        attrValidatorMap.put("maskXML", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(StringOperationsMeta.maskXMLCode.length), 5));
        attrValidatorMap.put("digits", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(StringOperationsMeta.digitsCode.length), 5));
        attrValidatorMap.put("removeSpecialCharacters", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(StringOperationsMeta.removeSpecialCharactersCode.length), 5));
        attrValidatorMap.put("paddingType", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(StringOperationsMeta.paddingCode.length), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, String>(), new HashMap<String, String>(), attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof StringOperationsMeta) {
            ((StringOperationsMeta)someMeta).allocate(5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testGetFields() throws Exception {
        StringOperationsMeta meta = new StringOperationsMeta();
        meta.allocate(1);
        meta.setFieldInStream(new String[]{"field1"});
        RowMeta rowMetaInterface = new RowMeta();
        ValueMetaString valueMeta = new ValueMetaString("field1");
        valueMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString("field1"));
        valueMeta.setStorageType(1);
        rowMetaInterface.addValueMeta((ValueMetaInterface)valueMeta);
        VariableSpace space = (VariableSpace)Mockito.mock(VariableSpace.class);
        meta.getFields((RowMetaInterface)rowMetaInterface, "STRING_OPERATIONS", null, null, space, null, null);
        RowMeta expectedRowMeta = new RowMeta();
        expectedRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("field1"));
        Assert.assertEquals((Object)expectedRowMeta.toString(), (Object)rowMetaInterface.toString());
    }
}

