/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.streamlookup;

import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.pentaho.di.core.QueueRowSet;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.mock.StepMockHelper;
import org.pentaho.di.trans.steps.streamlookup.StreamLookup;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupData;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupMeta;
import org.pentaho.metastore.api.IMetaStore;

public class StreamLookupTest {
    private StepMockHelper<StreamLookupMeta, StreamLookupData> smh;

    @Before
    public void setUp() {
        this.smh = new StepMockHelper<StreamLookupMeta, StreamLookupData>("StreamLookup", StreamLookupMeta.class, StreamLookupData.class);
        Mockito.when((Object)this.smh.logChannelInterfaceFactory.create(Matchers.any(), (LoggingObjectInterface)Matchers.any(LoggingObjectInterface.class))).thenReturn((Object)this.smh.logChannelInterface);
        Mockito.when((Object)this.smh.trans.isRunning()).thenReturn((Object)true);
    }

    @After
    public void cleanUp() {
        this.smh.cleanUp();
    }

    private void convertDataToBinary(Object[][] data) {
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                data[i][j] = ((String)data[i][j]).getBytes();
            }
        }
    }

    private RowSet mockLookupRowSet(boolean binary) {
        int storageType = binary ? 1 : 0;
        Object[][] data = new Object[][]{{"Value1", "1"}, {"Value2", "2"}};
        if (binary) {
            this.convertDataToBinary(data);
        }
        RowSet lookupRowSet = this.smh.getMockInputRowSet(data);
        ((RowSet)Mockito.doReturn((Object)"Lookup").when((Object)lookupRowSet)).getOriginStepName();
        ((RowSet)Mockito.doReturn((Object)"StreamLookup").when((Object)lookupRowSet)).getDestinationStepName();
        RowMeta lookupRowMeta = new RowMeta();
        ValueMetaString valueMeta = new ValueMetaString("Value");
        valueMeta.setStorageType(storageType);
        valueMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString());
        lookupRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        ValueMetaString idMeta = new ValueMetaString("Id");
        idMeta.setStorageType(storageType);
        idMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString());
        lookupRowMeta.addValueMeta((ValueMetaInterface)idMeta);
        ((RowSet)Mockito.doReturn((Object)lookupRowMeta).when((Object)lookupRowSet)).getRowMeta();
        return lookupRowSet;
    }

    private RowSet mockDataRowSet(boolean binary) {
        int storageType = binary ? 1 : 0;
        Object[][] data = new Object[][]{{"Name1", "1"}, {"Name2", "2"}};
        if (binary) {
            this.convertDataToBinary(data);
        }
        RowSet dataRowSet = this.smh.getMockInputRowSet(data);
        RowMeta dataRowMeta = new RowMeta();
        ValueMetaString valueMeta = new ValueMetaString("Name");
        valueMeta.setStorageType(storageType);
        valueMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString());
        dataRowMeta.addValueMeta((ValueMetaInterface)valueMeta);
        ValueMetaString idMeta = new ValueMetaString("Id");
        idMeta.setStorageType(storageType);
        idMeta.setStorageMetadata((ValueMetaInterface)new ValueMetaString());
        dataRowMeta.addValueMeta((ValueMetaInterface)idMeta);
        ((RowSet)Mockito.doReturn((Object)dataRowMeta).when((Object)dataRowSet)).getRowMeta();
        return dataRowSet;
    }

    private StreamLookupMeta mockProcessRowMeta(boolean memoryPreservationActive) throws KettleStepException {
        StreamLookupMeta meta = (StreamLookupMeta)this.smh.processRowsStepMetaInterface;
        StepMeta lookupStepMeta = (StepMeta)Mockito.when((Object)((StepMeta)Mockito.mock(StepMeta.class)).getName()).thenReturn((Object)"Lookup").getMock();
        ((TransMeta)Mockito.doReturn((Object)lookupStepMeta).when((Object)this.smh.transMeta)).findStep("Lookup");
        StepIOMeta stepIOMeta = new StepIOMeta(true, true, false, false, false, false);
        stepIOMeta.addStream((StreamInterface)new Stream(StreamInterface.StreamType.INFO, lookupStepMeta, null, StreamIcon.INFO, null));
        ((StreamLookupMeta)Mockito.doReturn((Object)stepIOMeta).when((Object)meta)).getStepIOMeta();
        ((StreamLookupMeta)Mockito.doReturn((Object)new String[]{"Id"}).when((Object)meta)).getKeylookup();
        ((StreamLookupMeta)Mockito.doReturn((Object)new String[]{"Id"}).when((Object)meta)).getKeystream();
        ((StreamLookupMeta)Mockito.doReturn((Object)new String[]{"Value"}).when((Object)meta)).getValue();
        ((StreamLookupMeta)Mockito.doReturn((Object)memoryPreservationActive).when((Object)meta)).isMemoryPreservationActive();
        ((StreamLookupMeta)Mockito.doReturn((Object)false).when((Object)meta)).isUsingSortedList();
        ((StreamLookupMeta)Mockito.doReturn((Object)false).when((Object)meta)).isUsingIntegerPair();
        ((StreamLookupMeta)Mockito.doReturn((Object)new int[]{-1}).when((Object)meta)).getValueDefaultType();
        ((StreamLookupMeta)Mockito.doReturn((Object)new String[]{""}).when((Object)meta)).getValueDefault();
        ((StreamLookupMeta)Mockito.doReturn((Object)new String[]{"Value"}).when((Object)meta)).getValueName();
        ((StreamLookupMeta)Mockito.doReturn((Object)new String[]{"Value"}).when((Object)meta)).getValue();
        ((StreamLookupMeta)Mockito.doCallRealMethod().when((Object)meta)).getFields((RowMetaInterface)Matchers.any(RowMetaInterface.class), Matchers.anyString(), (RowMetaInterface[])Matchers.any(RowMetaInterface[].class), (StepMeta)Matchers.any(StepMeta.class), (VariableSpace)Matchers.any(VariableSpace.class), (Repository)Matchers.any(Repository.class), (IMetaStore)Matchers.any(IMetaStore.class));
        return meta;
    }

    private void doTest(boolean memoryPreservationActive, boolean binaryLookupStream, boolean binaryDataStream) throws KettleException {
        StreamLookup step = new StreamLookup(this.smh.stepMeta, this.smh.stepDataInterface, 0, this.smh.transMeta, this.smh.trans);
        step.init(this.smh.initStepMetaInterface, this.smh.initStepDataInterface);
        step.addRowSetToInputRowSets(this.mockLookupRowSet(binaryLookupStream));
        step.addRowSetToInputRowSets(this.mockDataRowSet(binaryDataStream));
        step.addRowSetToOutputRowSets((RowSet)new QueueRowSet());
        StreamLookupMeta meta = this.mockProcessRowMeta(memoryPreservationActive);
        StreamLookupData data = new StreamLookupData();
        data.readLookupValues = true;
        RowSet outputRowSet = (RowSet)step.getOutputRowSets().get(0);
        int rowNumber = 0;
        String[] expectedOutput = new String[]{"Name", "", "Value"};
        while (step.processRow((StepMetaInterface)meta, (StepDataInterface)data)) {
            Object[] rowData = outputRowSet.getRow();
            if (rowData == null) continue;
            RowMetaInterface rowMeta = outputRowSet.getRowMeta();
            Assert.assertEquals((String)"Output row is of wrong size", (int)3, (int)rowMeta.size());
            ++rowNumber;
            for (int valueIndex = 0; valueIndex < rowMeta.size(); ++valueIndex) {
                String expectedValue = expectedOutput[valueIndex] + rowNumber;
                Object actualValue = rowMeta.getValueMeta(valueIndex).convertToNormalStorageType(rowData[valueIndex]);
                Assert.assertEquals((String)("Unexpected value at row " + rowNumber + " position " + valueIndex), (Object)expectedValue, (Object)actualValue);
            }
        }
        Assert.assertEquals((String)"Incorrect output row number", (int)2, (int)rowNumber);
    }

    @Test
    public void testWithNormalStreams() throws KettleException {
        this.doTest(false, false, false);
    }

    @Test
    public void testWithBinaryLookupStream() throws KettleException {
        this.doTest(false, true, false);
    }

    @Test
    public void testWithBinaryDateStream() throws KettleException {
        this.doTest(false, false, true);
    }

    @Test
    public void testWithBinaryStreams() throws KettleException {
        this.doTest(false, false, true);
    }

    @Test
    public void testMemoryPreservationWithNormalStreams() throws KettleException {
        this.doTest(true, false, false);
    }

    @Test
    public void testMemoryPreservationWithBinaryLookupStream() throws KettleException {
        this.doTest(true, true, false);
    }

    @Test
    public void testMemoryPreservationWithBinaryDateStream() throws KettleException {
        this.doTest(true, false, true);
    }

    @Test
    public void testMemoryPreservationWithBinaryStreams() throws KettleException {
        this.doTest(true, false, true);
    }
}

