/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.streamlookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.loadsave.LoadSaveTester;
import org.pentaho.di.trans.steps.loadsave.initializer.InitializerInterface;
import org.pentaho.di.trans.steps.loadsave.validator.ArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.IntLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.PrimitiveIntArrayLoadSaveValidator;
import org.pentaho.di.trans.steps.loadsave.validator.StringLoadSaveValidator;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupMeta;

public class StreamLookupMetaTest
implements InitializerInterface<StepMetaInterface> {
    LoadSaveTester loadSaveTester;
    Class<StreamLookupMeta> testMetaClass = StreamLookupMeta.class;
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setUpLoadSave() throws Exception {
        KettleEnvironment.init();
        PluginRegistry.init((boolean)false);
        List<String> attributes = Arrays.asList("inputSorted", "memoryPreservationActive", "usingSortedList", "usingIntegerPair", "keystream", "keylookup", "value", "valueName", "valueDefault", "valueDefaultType");
        ArrayLoadSaveValidator<String> stringArrayLoadSaveValidator = new ArrayLoadSaveValidator<String>(new StringLoadSaveValidator(), 5);
        HashMap attrValidatorMap = new HashMap();
        attrValidatorMap.put("keystream", stringArrayLoadSaveValidator);
        attrValidatorMap.put("keylookup", stringArrayLoadSaveValidator);
        attrValidatorMap.put("value", stringArrayLoadSaveValidator);
        attrValidatorMap.put("valueName", stringArrayLoadSaveValidator);
        attrValidatorMap.put("valueDefault", stringArrayLoadSaveValidator);
        attrValidatorMap.put("valueDefaultType", new PrimitiveIntArrayLoadSaveValidator(new IntLoadSaveValidator(7), 5));
        HashMap typeValidatorMap = new HashMap();
        this.loadSaveTester = new LoadSaveTester<StepMetaInterface>(this.testMetaClass, attributes, new ArrayList<String>(), new ArrayList<String>(), new HashMap<String, String>(), new HashMap<String, String>(), attrValidatorMap, typeValidatorMap, this);
    }

    @Override
    public void modify(StepMetaInterface someMeta) {
        if (someMeta instanceof StreamLookupMeta) {
            ((StreamLookupMeta)someMeta).allocate(5, 5);
        }
    }

    @Test
    public void testSerialization() throws KettleException {
        this.loadSaveTester.testSerialization();
    }

    @Test
    public void testCloneInfoSteps() {
        StreamLookupMeta meta = new StreamLookupMeta();
        meta.setDefault();
        String stepName = UUID.randomUUID().toString();
        StepMeta infoStep = (StepMeta)Mockito.mock(StepMeta.class);
        Mockito.when((Object)infoStep.getName()).thenReturn((Object)stepName);
        ((StreamInterface)meta.getStepIOMeta().getInfoStreams().get(0)).setStepMeta(infoStep);
        StreamLookupMeta cloned = (StreamLookupMeta)meta.clone();
        Assert.assertEquals((Object)stepName, (Object)((StreamInterface)cloned.getStepIOMeta().getInfoStreams().get(0)).getStepname());
        Assert.assertNotSame(meta.getStepIOMeta().getInfoStreams().get(0), cloned.getStepIOMeta().getInfoStreams().get(0));
    }

    @Test
    public void testGetXML() {
        StreamLookupMeta streamLookupMeta = new StreamLookupMeta();
        streamLookupMeta.setKeystream(new String[]{"testKeyStreamValue"});
        streamLookupMeta.setKeylookup(new String[]{"testKeyLookupValue"});
        streamLookupMeta.setValue(new String[]{"testValue"});
        streamLookupMeta.setValueName(new String[0]);
        streamLookupMeta.setValueDefault(new String[0]);
        streamLookupMeta.setValueDefaultType(new int[0]);
        streamLookupMeta.afterInjectionSynchronization();
        streamLookupMeta.getXML();
        Assert.assertEquals((long)streamLookupMeta.getKeystream().length, (long)streamLookupMeta.getValueName().length);
        Assert.assertEquals((long)streamLookupMeta.getKeystream().length, (long)streamLookupMeta.getValueDefault().length);
        Assert.assertEquals((long)streamLookupMeta.getKeystream().length, (long)streamLookupMeta.getValueDefaultType().length);
    }
}

