/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ssh;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.ServerHostKeyVerifier;
import java.io.ByteArrayInputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.steps.ssh.SSHData;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SSHData.class, KettleVFS.class})
public class SSHDataTest {
    @Mock
    Connection connection;
    @Mock
    FileObject fileObject;
    @Mock
    FileContent fileContent;
    @Mock
    VariableSpace variableSpace;
    String server = "testServerUrl";
    String keyFilePath = "keyFilePath";
    String passPhrase = "passPhrase";
    String username = "username";
    String password = "password";
    String proxyUsername = "proxyUsername";
    String proxyPassword = "proxyPassword";
    String proxyHost = "proxyHost";
    int port = 22;
    int proxyPort = 23;

    @Before
    public void setup() throws Exception {
        PowerMockito.mockStatic(SSHData.class, (Class[])new Class[0]);
        PowerMockito.mockStatic(KettleVFS.class, (Class[])new Class[0]);
        Mockito.when((Object)SSHData.createConnection((String)this.server, (int)this.port)).thenReturn((Object)this.connection);
        Mockito.when((Object)SSHData.OpenConnection((String)((String)Matchers.any()), (int)Matchers.anyInt(), (String)((String)Matchers.any()), (String)((String)Matchers.any()), (boolean)Matchers.anyBoolean(), (String)((String)Matchers.any()), (String)((String)Matchers.any()), (int)Matchers.anyInt(), (VariableSpace)((VariableSpace)Matchers.anyObject()), (String)((String)Matchers.any()), (int)Matchers.anyInt(), (String)((String)Matchers.any()), (String)((String)Matchers.any()))).thenCallRealMethod();
        Mockito.when((Object)KettleVFS.getFileObject((String)this.keyFilePath)).thenReturn((Object)this.fileObject);
    }

    @Test
    public void testOpenConnection_1() throws Exception {
        Mockito.when((Object)this.connection.authenticateWithPassword(this.username, this.password)).thenReturn((Object)true);
        Assert.assertNotNull((Object)SSHData.OpenConnection((String)this.server, (int)this.port, (String)this.username, (String)this.password, (boolean)false, null, null, (int)0, null, null, (int)0, null, null));
        ((Connection)Mockito.verify((Object)this.connection)).connect();
        ((Connection)Mockito.verify((Object)this.connection)).authenticateWithPassword(this.username, this.password);
    }

    @Test(expected=KettleException.class)
    public void testOpenConnection_2() throws Exception {
        Mockito.when((Object)this.connection.authenticateWithPassword(this.username, this.password)).thenReturn((Object)false);
        SSHData.OpenConnection((String)this.server, (int)this.port, (String)this.username, (String)this.password, (boolean)false, null, null, (int)0, null, null, (int)0, null, null);
        ((Connection)Mockito.verify((Object)this.connection)).connect();
        ((Connection)Mockito.verify((Object)this.connection)).authenticateWithPassword(this.username, this.password);
    }

    @Test(expected=KettleException.class)
    public void testOpenConnectionUseKey_1() throws Exception {
        Mockito.when((Object)this.fileObject.exists()).thenReturn((Object)false);
        SSHData.OpenConnection((String)this.server, (int)this.port, null, null, (boolean)true, null, null, (int)0, null, null, (int)0, null, null);
        ((FileObject)Mockito.verify((Object)this.fileObject)).exists();
    }

    @Test
    public void testOpenConnectionUseKey_2() throws Exception {
        Mockito.when((Object)this.fileObject.exists()).thenReturn((Object)true);
        Mockito.when((Object)this.fileObject.getContent()).thenReturn((Object)this.fileContent);
        Mockito.when((Object)this.fileContent.getSize()).thenReturn((Object)1000L);
        Mockito.when((Object)this.fileContent.getInputStream()).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5}));
        Mockito.when((Object)this.variableSpace.environmentSubstitute(this.passPhrase)).thenReturn((Object)this.passPhrase);
        Mockito.when((Object)this.connection.authenticateWithPublicKey((String)Matchers.eq((Object)this.username), (char[])Matchers.any(), (String)Matchers.eq((Object)this.passPhrase))).thenReturn((Object)true);
        SSHData.OpenConnection((String)this.server, (int)this.port, (String)this.username, null, (boolean)true, (String)this.keyFilePath, (String)this.passPhrase, (int)0, (VariableSpace)this.variableSpace, null, (int)0, null, null);
        ((Connection)Mockito.verify((Object)this.connection)).connect();
        ((Connection)Mockito.verify((Object)this.connection)).authenticateWithPublicKey((String)Matchers.eq((Object)this.username), (char[])Matchers.any(), (String)Matchers.eq((Object)this.passPhrase));
    }

    @Test
    public void testOpenConnectionProxy() throws Exception {
        Mockito.when((Object)this.connection.authenticateWithPassword(this.username, this.password)).thenReturn((Object)true);
        Assert.assertNotNull((Object)SSHData.OpenConnection((String)this.server, (int)this.port, (String)this.username, (String)this.password, (boolean)false, null, null, (int)0, null, (String)this.proxyHost, (int)this.proxyPort, (String)this.proxyUsername, (String)this.proxyPassword));
        ((Connection)Mockito.verify((Object)this.connection)).connect();
        ((Connection)Mockito.verify((Object)this.connection)).authenticateWithPassword(this.username, this.password);
        ((Connection)Mockito.verify((Object)this.connection)).setProxyData((ProxyData)Matchers.any(HTTPProxyData.class));
    }

    @Test
    public void testOpenConnectionTimeOut() throws Exception {
        Mockito.when((Object)this.connection.authenticateWithPassword(this.username, this.password)).thenReturn((Object)true);
        Assert.assertNotNull((Object)SSHData.OpenConnection((String)this.server, (int)this.port, (String)this.username, (String)this.password, (boolean)false, null, null, (int)100, null, null, (int)this.proxyPort, (String)this.proxyUsername, (String)this.proxyPassword));
        ((Connection)Mockito.verify((Object)this.connection)).connect((ServerHostKeyVerifier)Matchers.isNull(ServerHostKeyVerifier.class), Matchers.eq((int)0), Matchers.eq((int)100000));
    }
}

