/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sql;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.injection.BaseMetadataInjectionTest;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.junit.rules.RestorePDIEngineEnvironment;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.sql.ExecSQLMeta;

public class ExecSQLMetaInjectionTest
extends BaseMetadataInjectionTest<ExecSQLMeta> {
    @ClassRule
    public static RestorePDIEngineEnvironment env = new RestorePDIEngineEnvironment();

    @Before
    public void setup() {
        this.setup(new ExecSQLMeta());
    }

    @Test
    public void test() throws Exception {
        this.check("SQL", () -> ((ExecSQLMeta)this.meta).getSql(), new String[0]);
        this.check("EXECUTE_FOR_EACH_ROW", () -> ((ExecSQLMeta)this.meta).isExecutedEachInputRow());
        this.check("UPDATE_STATS_FIELD", () -> ((ExecSQLMeta)this.meta).getUpdateField(), new String[0]);
        this.check("INSERT_STATS_FIELD", () -> ((ExecSQLMeta)this.meta).getInsertField(), new String[0]);
        this.check("DELETE_STATS_FIELD", () -> ((ExecSQLMeta)this.meta).getDeleteField(), new String[0]);
        this.check("READ_STATS_FIELD", () -> ((ExecSQLMeta)this.meta).getReadField(), new String[0]);
        this.check("EXECUTE_AS_SINGLE_STATEMENT", () -> ((ExecSQLMeta)this.meta).isSingleStatement());
        this.check("REPLACE_VARIABLES", () -> ((ExecSQLMeta)this.meta).isReplaceVariables());
        this.check("QUOTE_STRINGS", () -> ((ExecSQLMeta)this.meta).isQuoteString());
        this.check("BIND_PARAMETERS", () -> ((ExecSQLMeta)this.meta).isParams());
        this.check("PARAMETER_NAME", () -> ((ExecSQLMeta)this.meta).getArguments()[0], new String[0]);
        this.skipPropertyTest("CONNECTIONNAME");
        DatabaseMeta db1 = new DatabaseMeta();
        db1.setName("my connection 1");
        DatabaseMeta db2 = new DatabaseMeta();
        db2.setName("my connection 2");
        DatabaseMeta db3 = new DatabaseMeta();
        db3.setName("my connection 3");
        List<SharedObjectInterface> mockDbs = Arrays.asList(db1, db2, db3);
        StepMeta parentStepMeta = (StepMeta)Mockito.mock(StepMeta.class);
        TransMeta parentTransMeta = (TransMeta)Mockito.mock(TransMeta.class);
        ((TransMeta)Mockito.doReturn(mockDbs).when((Object)parentTransMeta)).getDatabases();
        ((StepMeta)Mockito.doReturn((Object)parentTransMeta).when((Object)parentStepMeta)).getParentTransMeta();
        ((ExecSQLMeta)this.meta).setParentStepMeta(parentStepMeta);
        this.injector.setProperty(this.meta, "CONNECTIONNAME", this.setValue((ValueMetaInterface)new ValueMetaString("my connection 2"), "my connection 2"), "my connection 2");
        Assert.assertEquals((Object)db2, (Object)((ExecSQLMeta)this.meta).getDatabaseMeta());
    }
}

